/*
 * Paraselene
 * Copyright (c) 2009  Akira Terasaki
 * このファイルは同梱されている License.txt に定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene;

import paraselene.supervisor.*;
import java.io.*;
import java.net.*;
import java.util.jar.*;

/**
 * Paraseleneのバージョン番号。
 */
public class Version {
	private Version(){}
	/**
	 * Paraseleneのバージョン番号を表す文字列。
	 * 2.1.1.15
	 */
	public static final String VERSION = "2.1.1.15";
	private static final String	SITE = " (http://paraselene.sourceforge.jp/)";
	private static final String	TITLE = "Paraselene " + VERSION + SITE;
	private static final String[] CLASS_PATH = new String[] {
		"sun.boot.class.path",
		"java.ext.dirs",
		"java.class.path",
	};
	private static final File JAR_PATH = seekJar();

	/**
	 * Paraseleneのアプリタイトル文字列。
	 * @return アプリタイトル。
	 */
	public static String getTitle() {
		return TITLE;
	}

	/**
	 * Paraseleneの著作権表示。
	 * @return 著作権表示。
	 */
	public static String getCopyRight() {
		return "Copyright 2009 Akira Terasaki";
	}

	private static boolean isHit( File f ) {
		try{
			JarFile	file = new JarFile( f );
			JarEntry	ent = file.getJarEntry( "paraselene/Version.class" );
			return ent != null;
		}
		catch( Exception e ) {}
		return false;
	}

	private static File seekJar( File dir, boolean nest_f ){
		if ( dir.isDirectory() ) {
			if ( nest_f )	return null;
			File[]	next = dir.listFiles();
			for ( int  i = 0; i < next.length; i++ ) {
				File	ret = seekJar( next[i], true );
				if ( ret != null )	return ret;
			}
		}
		else {
			if ( isHit( dir ) )	return dir;
		}
		return null;
	}

	private static File seekJar( String key ) {
		String	prop = System.getProperty( key );
		if ( prop == null )	return null;
		String[]	dir = prop.split( File.pathSeparator );
		for ( int i = 0; i < dir.length; i++ ) {
			File	ret = seekJar( new File( dir[i].trim() ), false );
			if ( ret != null )	return ret;
		}
		return null;
	}

	private static File seekJar() {
		try {
			URL	url = Version.class.getResource( "/paraselene/Version.class" );
			URI	uri = new URI( url.toString().split( "!" )[0].substring( 4 ) );
			File	file = new File( uri );
			return file;
		}
		catch( Exception e ) {
			e.printStackTrace();
		}
		for ( int i = 0; i < CLASS_PATH.length; i++ ) {
			File	ret = seekJar( CLASS_PATH[i] );
			if ( ret != null )	return ret;
		}
		return null;
	}

	/**
	 * このjarファイルのフルパス。
	 * @return jarファイルのフルパス。
	 */
	public static File getJarPath() {
		return JAR_PATH;
	}

	/**
	 * リソースの取得。
	 * @param name リソースの名前。
	 * @return リソース。取得に失敗すると null を返します。
	 */
	public static InputStream getResource( String name ) {
		ClassLoader	ld = Version.class.getClassLoader();
		if ( ld != null ) {
			InputStream	is = ld.getResourceAsStream( name );
			if ( is != null )	return is;
		}
		try {
			JarFile	file = new JarFile( getJarPath() );
			return file.getInputStream( file.getJarEntry( name ) );
		}
		catch( Exception e ){
			Option.debug( e );
		}
		return null;
	}
}

