/*
 * Paraselene
 * Copyright (c) 2009  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.tag;

import paraselene.*;

/**
 * タグの属性値で、値の変更が可能なものを示します。
 */
public interface AttributeValuable extends Valuable {
	/**
	 * テキスト化。
	 * @param mode 出力モード。
	 * @return 文字列。
	 */
	String toString( HTMLPart.StringMode mode );

	/**
	 * 複製の作成。
	 * @return 複製。
	 */
	Valuable getValuableReplica();

	/**
	 * 所属先タグの設定。
	 * @param t 所属先。
	 */
	void setAssignedTag( Tag t );
}

