/*
 * Decompiled with CFR 0.152.
 */
package paraselene;

import java.io.File;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import paraselene.supervisor.Option;

public class Version {
    public static final String VERSION = "2.1.1.12";
    private static final String SITE = " (http://paraselene.sourceforge.jp/)";
    private static final String TITLE = "Paraselene 2.1.1.12 (http://paraselene.sourceforge.jp/)";
    private static final String[] CLASS_PATH = new String[]{"sun.boot.class.path", "java.ext.dirs", "java.class.path"};
    private static final File JAR_PATH = Version.seekJar();

    private Version() {
    }

    public static String getTitle() {
        return TITLE;
    }

    public static String getCopyRight() {
        return "Copyright 2009 Akira Terasaki";
    }

    private static boolean isHit(File f) {
        try {
            JarFile file = new JarFile(f);
            JarEntry ent = file.getJarEntry("paraselene/Version.class");
            return ent != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static File seekJar(File dir, boolean nest_f) {
        if (dir.isDirectory()) {
            if (nest_f) {
                return null;
            }
            File[] next = dir.listFiles();
            for (int i = 0; i < next.length; ++i) {
                File ret = Version.seekJar(next[i], true);
                if (ret == null) continue;
                return ret;
            }
        } else if (Version.isHit(dir)) {
            return dir;
        }
        return null;
    }

    private static File seekJar(String key) {
        String prop = System.getProperty(key);
        if (prop == null) {
            return null;
        }
        String[] dir = prop.split(File.pathSeparator);
        for (int i = 0; i < dir.length; ++i) {
            File ret = Version.seekJar(new File(dir[i].trim()), false);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    private static File seekJar() {
        for (int i = 0; i < CLASS_PATH.length; ++i) {
            File ret = Version.seekJar(CLASS_PATH[i]);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public static File getJarPath() {
        return JAR_PATH;
    }

    public static InputStream getResource(String name) {
        InputStream is;
        ClassLoader ld = Version.class.getClassLoader();
        if (ld != null && (is = ld.getResourceAsStream(name)) != null) {
            return is;
        }
        try {
            JarFile file = new JarFile(Version.getJarPath());
            return file.getInputStream(file.getJarEntry(name));
        }
        catch (Exception e) {
            Option.debug(e);
            return null;
        }
    }
}

