/*
 * Decompiled with CFR 0.152.
 */
package paraselene;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import paraselene.Color;
import paraselene.HTMLPart;
import paraselene.HTTPDate;
import paraselene.QueryItem;
import paraselene.Text;
import paraselene.URIValue;
import paraselene.Valuable;
import paraselene.WebColor;
import paraselene.css.CSSValuable;
import paraselene.supervisor.Forward;
import paraselene.supervisor.NullPage;
import paraselene.supervisor.Option;
import paraselene.supervisor.PageFactory;
import paraselene.supervisor.PageID;
import paraselene.supervisor.Popup;
import paraselene.supervisor.RequestItem;
import paraselene.supervisor.RequestParameter;
import paraselene.supervisor.SandBox;
import paraselene.supervisor.TransactionSequencer;
import paraselene.tag.Attribute;
import paraselene.tag.Tag;
import paraselene.tag.form.Button;
import paraselene.tag.form.Control;
import paraselene.tag.form.Form;

public abstract class Page
implements Serializable {
    private volatile int histry_key = 0;
    private static final int ERROR_NO = 403;
    private HashMap<String, Tag> tag_1_dic = new HashMap();
    private HashMap<String, HashMap<String, Tag>> tag_m_dic = new HashMap();
    private HashMap<Tag, String> name_dic = new HashMap();
    private int name_seq = 0;
    private Tag contents = null;
    private boolean init_f = true;
    private boolean xml_f = false;
    private String doctype_def = null;
    private static final long serialVersionUID = 2L;
    private Popup.Type popup_type = null;
    private static volatile short page_id;
    private static final Object obj4uniKey;
    private String uniKey;
    private transient Control[] modified = new Control[0];
    private boolean beginning_called = false;
    private static final String AJAX_BLACK_ID = "paraseleneEclipse";
    private static final String AJAX_TARGET_ID = "paraseleneDragonsTail";
    private static final String AJAX_ADD_ID = "paraseleneDragonsHead";
    private boolean ajax_f = false;
    private RequestParameter now_req;
    private RequestParameter.Mobile access_mobile;
    private RequestParameter.SearchEngine access_se;
    private boolean safari_f = false;

    public abstract AjaxSupport getAjaxSupport();

    public void setHistoryKey(int key) {
        this.histry_key = key;
    }

    public int getHistoryKey() {
        return this.histry_key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeKey() {
        long now = 0L;
        Object object = obj4uniKey;
        synchronized (object) {
            now = page_id;
            page_id = (short)(page_id + 1);
        }
        now = now << 56 ^ new Date().getTime() & 0xFFFFFFFFFFFFFFL;
        StringBuilder buf = new StringBuilder("paraselene_page_key_");
        buf = buf.append(Long.toString(now &= Long.MAX_VALUE, 36));
        this.uniKey = buf.toString();
    }

    public Popup.Type getPopupType() {
        return this.popup_type;
    }

    public void setPopupType(Popup.Type type) {
        this.popup_type = type;
    }

    public boolean isRuntime() {
        return true;
    }

    protected void addVersionMeta(String parser, String date) {
        if (!this.isRuntime()) {
            return;
        }
        Tag head = this.getFirstTagByType("head");
        if (head == null) {
            return;
        }
        StringBuilder buf = new StringBuilder(" Parser[");
        buf = buf.append(parser);
        buf = buf.append(",");
        buf = buf.append(date.toString());
        buf = buf.append("] Runtime[");
        buf = buf.append("2.1.1.12");
        buf = buf.append(",");
        buf = buf.append(new Date().toString());
        buf = buf.append("] ");
        Tag meta = new Tag("meta", true);
        meta.setAttribute(new Attribute("name", "generator"), new Attribute("content", buf.toString()));
        head.addHTMLPart((HTMLPart)meta);
    }

    protected void setDoctype(boolean xml, String doctype) {
        this.xml_f = xml;
        this.doctype_def = doctype;
    }

    public boolean isXML() {
        return this.xml_f;
    }

    public String getDoctype() {
        return this.doctype_def;
    }

    public void clear() {
        this.tag_1_dic = new HashMap();
        this.tag_m_dic = new HashMap();
        this.name_dic = new HashMap();
        this.name_seq = 0;
        this.contents = null;
    }

    public abstract void init();

    public void setInitialized(boolean flag) throws PageException {
        this.init_f = flag;
        if (flag && this.beginning_called) {
            this.beginning_called = false;
            this.beginning(this.now_req);
        }
    }

    public boolean isInitialized() {
        return this.init_f;
    }

    public String[] getDefineNameIndex() {
        ArrayList<String> list = new ArrayList<String>();
        for (String k : this.tag_m_dic.keySet()) {
            list.add(k);
        }
        return list.toArray(new String[0]);
    }

    public String[] getDefineName() {
        ArrayList<String> list = new ArrayList<String>();
        for (String k : this.tag_1_dic.keySet()) {
            list.add(k);
        }
        return list.toArray(new String[0]);
    }

    private ArrayList<Form> getForm(Tag tag, ArrayList<Form> list) {
        Tag[] nest = tag.getTagArray();
        for (int i = 0; i < nest.length; ++i) {
            list = this.getForm(nest[i], list);
        }
        if (tag instanceof Form) {
            list.add((Form)tag);
        }
        return list;
    }

    public Control[] getModifiedControl() {
        return this.modified;
    }

    public void reflect(RequestParameter req) {
        this.modified = new Control[0];
        if (this.getMainTag() == null) {
            return;
        }
        ArrayList<Form> form = this.getForm(this.getMainTag(), new ArrayList<Form>());
        int form_cnt = form.size();
        String form_id = "paraselene_form_id";
        RequestItem item = req.getItem("paraselene$form$id");
        if (item != null) {
            form_id = item.getValue(0);
        }
        for (int i = form_cnt - 1; i >= 0; --i) {
            Form f = form.get(i);
            if (f.getID().equals(form_id)) continue;
            Control[] ctl = f.getAllControl();
            for (int j = 0; j < ctl.length; ++j) {
                if (!(ctl[j] instanceof Button)) continue;
                Button but = (Button)ctl[j];
                but.resetClicked();
            }
            form.remove(i);
        }
        ArrayList<Control> list = new ArrayList<Control>();
        form_cnt = form.size();
        for (int i = 0; i < form_cnt; ++i) {
            list.addAll(form.get(i).reflect(req));
        }
        this.modified = list.toArray(new Control[0]);
        if (this.modified.length > 0) {
            try {
                this.setInitialized(false);
            }
            catch (PageException e) {
                Option.debug(e);
            }
        }
    }

    public Button getClickedButton() {
        if (this.getMainTag() == null) {
            return null;
        }
        ArrayList<Form> form = this.getForm(this.getMainTag(), new ArrayList<Form>());
        int size = form.size();
        for (int i = 0; i < size; ++i) {
            Control[] ctl = form.get(i).getAllControl();
            for (int j = 0; j < ctl.length; ++j) {
                Button btn;
                if (!(ctl[j] instanceof Button) || !(btn = (Button)ctl[j]).isClicked()) continue;
                return btn;
            }
        }
        return null;
    }

    public abstract String getContentType();

    public abstract String getCharset();

    public Attribute createURI(String name, String uri) throws PageException {
        try {
            return new Attribute(name, (Valuable)new URIValue(uri, this.getCharset()));
        }
        catch (Exception e) {
            throw new PageException((Throwable)e);
        }
    }

    public Attribute createPageToURI(String name, PageID pid, String fragment, QueryItem ... query) throws PageException {
        return this.createURI(name, URIValue.pageToURI(pid, fragment, query));
    }

    public Attribute createPageToDownloadURI(String name, PageID pid, String filename, QueryItem ... query) throws PageException {
        return this.createURI(name, URIValue.pageToDownloadURI(pid, filename, query));
    }

    public Attribute createAliasToURI(String name, PageID pid, String body, String fragment, QueryItem ... query) throws PageException {
        PageFactory factory = pid.getPageFactory();
        Page page = factory.getPage(pid);
        String alias = page.getAliasURI();
        factory.returnPage(page);
        if (alias == null) {
            throw new PageException(pid.toString() + " aliasURI is null.");
        }
        StringBuilder buf = new StringBuilder(alias);
        if (!".na".equals(alias.substring(alias.length() - 3))) {
            if (body == null) {
                throw new PageException("body is null.");
            }
            buf = buf.append(body);
            buf = buf.append(".na");
        }
        if (fragment != null) {
            buf = buf.append("#");
            buf = buf.append(fragment);
        }
        try {
            URIValue uv = new URIValue(buf.toString(), this.getCharset());
            if (query.length > 0) {
                uv.setQuery(query);
            }
            Attribute attr = new Attribute(name, (Valuable)uv);
            return attr;
        }
        catch (Exception e) {
            throw new PageException((Throwable)e);
        }
    }

    public String pickAliasURI(RequestParameter req) {
        String alias = this.getAliasURI();
        if (alias == null) {
            return null;
        }
        if (TransactionSequencer.EXTENSION.equals(alias.substring(alias.length() - 3))) {
            return null;
        }
        String uri = req.getURI().getPath();
        String[] path = uri.split("/");
        for (int i = 0; i < path.length; ++i) {
            int end;
            if (path[i].length() < 4 || !TransactionSequencer.EXTENSION.equals(path[i].substring(path[i].length() - 3)) || alias.length() >= path[i].length() || !alias.equals(path[i].substring(0, alias.length()))) continue;
            int start = alias.length();
            if (start < (end = path[i].length() - 3)) {
                return path[i].substring(start, end);
            }
            return "";
        }
        return null;
    }

    public Page() {
        this.makeKey();
    }

    public Tag getTag(String name) {
        return this.tag_1_dic.get(name);
    }

    public Tag[] getAllTag(String name) {
        if (name == null) {
            return new Tag[0];
        }
        String[] pre = name.split("\\$");
        ArrayList<Tag> list = new ArrayList<Tag>();
        HashMap<String, Tag> map = this.tag_m_dic.get(pre[0]);
        if (map == null) {
            return new Tag[0];
        }
        for (String k : map.keySet()) {
            list.add(map.get(k));
        }
        return Tag.sort(list.toArray(new Tag[0]));
    }

    public abstract PageID getID();

    public int hashCode() {
        PageID id = this.getID();
        return id != null ? id.getID() : Integer.MIN_VALUE;
    }

    public String getUniqueKey() {
        return this.uniKey;
    }

    public boolean equals(Object p) {
        if (this instanceof NullPage || p instanceof NullPage) {
            return false;
        }
        if (p instanceof PageID) {
            return this.getID() == p;
        }
        if (p instanceof Page) {
            return this.hashCode() == p.hashCode();
        }
        return false;
    }

    public static String getIndexName(String name) {
        if (name == null) {
            return null;
        }
        String[] idx = name.split("\\$");
        return idx[0];
    }

    private void clearDic(String name) {
        Tag tag = this.tag_1_dic.remove(name);
        this.name_dic.remove(tag);
        String index = Page.getIndexName(name);
        HashMap<String, Tag> map = this.tag_m_dic.get(index);
        if (map == null) {
            return;
        }
        map.remove(name);
        if (map.size() == 0) {
            this.tag_m_dic.remove(index);
        }
    }

    private String extendName(Tag tag) {
        String org_name = tag.getNameAttribute();
        String index = Page.getIndexName(org_name);
        while (this.tag_1_dic.get(org_name = String.format("%s$%d", index, this.name_seq)) != null) {
            ++this.name_seq;
        }
        return org_name;
    }

    private void nameTagSingle(Tag tag) {
        if (tag == null) {
            return;
        }
        String old_name = this.name_dic.get(tag);
        String new_name = tag.getNameAttribute();
        if (old_name == null && new_name == null) {
            return;
        }
        if (old_name != null && new_name == null) {
            this.clearDic(old_name);
            return;
        }
        if (old_name != null && new_name != null) {
            if (old_name.equals(new_name)) {
                return;
            }
            this.clearDic(old_name);
        }
        if (this.tag_1_dic.get(new_name) != null) {
            new_name = this.extendName(tag);
            try {
                tag.setAttribute(new Attribute("name", new_name));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.tag_1_dic.put(new_name, tag);
        this.name_dic.put(tag, new_name);
        String index = Page.getIndexName(new_name);
        HashMap<String, Tag> map = this.tag_m_dic.get(index);
        if (map == null) {
            map = new HashMap();
            this.tag_m_dic.put(index, map);
        }
        map.put(new_name, tag);
    }

    public void nameTag(Tag tag) {
        if (this.getMainTag() == null) {
            return;
        }
        tag.setAssignedPage(this);
        String name = tag.getNameAttribute();
        if (name != null) {
            if ("paraselene$form$id".equals(name)) {
                return;
            }
            if ("paraselene_form_ajax".equals(name)) {
                return;
            }
            if ("paraselene_form_dummy".equals(name)) {
                return;
            }
        }
        this.nameTagSingle(tag);
        int cnt = tag.getHTMLPartCount();
        for (int i = 0; i < cnt; ++i) {
            HTMLPart part = tag.getHTMLPart(i);
            if (!(part instanceof Tag)) continue;
            this.nameTag((Tag)part);
        }
        ArrayList<Form> form = this.getForm(this.getMainTag(), new ArrayList<Form>());
        cnt = form.size();
        for (int i = 0; i < cnt; ++i) {
            Form f = form.get(i);
            if (!f.isInner(tag)) continue;
            f.checkTag(tag);
        }
    }

    public void removeNameEntry(Tag tag) {
        int i;
        if (this.getMainTag() == null) {
            return;
        }
        ArrayList<Form> form = this.getForm(this.getMainTag(), new ArrayList<Form>());
        int cnt = form.size();
        for (i = 0; i < cnt; ++i) {
            Form f = form.get(i);
            if (!f.isInner(tag)) continue;
            f.checkTag4rm(tag);
        }
        cnt = tag.getHTMLPartCount();
        for (i = 0; i < cnt; ++i) {
            HTMLPart part = tag.getHTMLPart(i);
            if (!(part instanceof Tag)) continue;
            this.removeNameEntry((Tag)part);
        }
        tag.setAssignedPage(null);
        String name = tag.getNameAttribute();
        if (name == null) {
            return;
        }
        this.clearDic(name);
    }

    private void clearAssignedPage(Tag tag) {
        Tag[] next = tag.getTagArray();
        if (next != null) {
            for (int i = 0; i < next.length; ++i) {
                this.clearAssignedPage(next[i]);
            }
        }
        this.removeNameEntry(tag);
    }

    public void setMainTag(Tag tag) {
        if (this.contents != null) {
            this.clearAssignedPage(this.contents);
        }
        this.contents = tag;
        if (tag != null) {
            this.nameTag(tag);
        }
    }

    public Tag getMainTag() {
        return this.contents;
    }

    public void moveMainTag(Page src) {
        Tag tag = src.getMainTag();
        src.setMainTag(null);
        this.setMainTag(tag);
    }

    public Tag getFirstTagByType(String name) {
        Tag tag = this.getMainTag();
        if (tag == null) {
            return null;
        }
        return tag.getFirstTagByType(name);
    }

    public Tag[] getAllTagByType(String name) {
        if (this.getMainTag() == null) {
            return new Tag[0];
        }
        Tag tag = this.getMainTag();
        if (tag == null) {
            return new Tag[0];
        }
        return tag.getAllTagByType(name);
    }

    public void replaceTag(Tag from, Tag to, boolean copy_f) {
        if (this.getMainTag() == null) {
            return;
        }
        Tag tag = this.getMainTag().getDirectInnerTag(from);
        int idx = tag.indexOf(from);
        tag.removeHTMLPart(from);
        if (copy_f) {
            to.setVisible(from.isVisible());
            Attribute[] attr = from.getAllAttribute();
            for (int i = 0; i < attr.length; ++i) {
                to.setAttribute(attr[i].getReplica());
            }
            int cnt = from.getHTMLPartCount();
            for (int i = 0; i < cnt; ++i) {
                to.addHTMLPart(from.getHTMLPart(i).getReplica());
            }
        }
        tag.addHTMLPart(idx, (HTMLPart)to);
    }

    public String toString() {
        String doc;
        StringBuilder buf = new StringBuilder();
        if (this.isXML()) {
            buf = buf.append("<?xml version=\"1.0\" encoding=\"");
            buf = buf.append(this.getCharset());
            buf = buf.append("\"?>");
        }
        if ((doc = this.getDoctype()) != null) {
            buf = buf.append(doc);
        }
        if (this.contents != null) {
            buf = buf.append(this.contents.toString());
        }
        return buf.toString();
    }

    public void write(PrintWriter w) throws UnsupportedEncodingException, URISyntaxException {
        String doc;
        if (this.isXML()) {
            w.print("<?xml version=\"1.0\" encoding=\"");
            w.print(this.getCharset());
            w.println("\"?>");
        }
        if ((doc = this.getDoctype()) != null) {
            w.println(doc);
        }
        if (this.contents != null) {
            this.contents.write(w, HTMLPart.StringMode.BODY);
        }
    }

    public HTTPDate getLastModified() {
        return null;
    }

    public boolean isGZIP() {
        return false;
    }

    public abstract boolean isHistoryClear();

    public abstract boolean isAllowHistoryAdd();

    public abstract Forward input(RequestParameter var1, Forward var2) throws PageException;

    public abstract Page output(Page var1, RequestParameter var2) throws PageException;

    public abstract String getAliasURI();

    public abstract int getUploadMaxBytes();

    public abstract boolean isCheckRepeatSameRequest();

    public abstract void firstOutput(RequestParameter var1) throws PageException;

    public void beginning(RequestParameter req) throws PageException {
        if (this.beginning_called) {
            return;
        }
        this.beginning_called = true;
        if (this.getMainTag() == null) {
            return;
        }
        this.firstOutput(req);
        this.ajax_f = true;
        if (!this.safari_f && this.getAccessedMobile() == RequestParameter.Mobile.NO_MOBILE && this.getAccessedSearchEngine() == RequestParameter.SearchEngine.NO_SEARCHENGINE) {
            AjaxSupport ajax = this.getAjaxSupport();
            Tag head = this.getFirstTagByType("head");
            Tag body = this.getFirstTagByType("body");
            if (head != null) {
                Tag tag;
                HTMLPart part;
                int idx;
                int max = head.getHTMLPartCount();
                for (idx = 0; !(idx >= max || (part = head.getHTMLPart(idx)) instanceof Tag && "link".equals((tag = (Tag)part).getName())); ++idx) {
                }
                try {
                    Tag tag2 = new Tag("link", true);
                    tag2.setAttribute(new Attribute("rel", (Valuable)new Text("stylesheet")), new Attribute("href", (Valuable)new URIValue("paraselene.css.na")), new Attribute("type", (Valuable)new Text("text/css")));
                    head.addHTMLPart(idx, (HTMLPart)tag2);
                }
                catch (Exception e) {
                    Option.debug(e);
                }
            } else {
                this.ajax_f = false;
            }
            if (head != null && body != null && ajax != AjaxSupport.NO && this.getPopupType() == null) {
                Tag script = new Tag("script", false);
                try {
                    script.setAttribute(new Attribute("type", "text/javascript"), new Attribute("src", "paraselene.js.na"));
                }
                catch (Exception e) {
                    Option.debug(e);
                }
                head.addHTMLPart((HTMLPart)script);
                Tag[] div = new Tag[]{new Tag("div", false), new Tag("div", false)};
                div[0].include(body, true);
                Tag eclipse = new Tag("div", false);
                eclipse.setAttribute(new Attribute("id", AJAX_BLACK_ID));
                Tag iframe = new Tag("iframe", false);
                iframe.setAttribute(new Attribute("id", AJAX_TARGET_ID), new Attribute("name", AJAX_TARGET_ID), new Attribute("scrolling", (Valuable)new Text("no")), new Attribute("onload", "paraselene_form_comp();"));
                div[1].addHTMLPart(eclipse, iframe);
                div[1].setAttribute(new Attribute("id", AJAX_ADD_ID));
                body.removeHTMLPart();
                body.addHTMLPart(div[0], div[1]);
            } else {
                this.ajax_f = false;
            }
        } else {
            this.ajax_f = false;
        }
        if (this.getPopupType() != null) {
            this.ajax_f = true;
        }
    }

    public boolean isAjax() {
        return this.ajax_f;
    }

    public void setRequestParameter(RequestParameter req) {
        this.now_req = req;
        if (req != null) {
            this.access_mobile = req.judgeMobile();
            this.access_se = req.judgeSearchEngine();
            String[] ua = req.getHeader("User-Agent");
            if (ua != null) {
                this.safari_f = ua[0].indexOf("Chrome") == -1 && ua[0].indexOf("Safari") >= 0;
            }
        }
    }

    public RequestParameter.Mobile getAccessedMobile() {
        return this.access_mobile;
    }

    public RequestParameter.SearchEngine getAccessedSearchEngine() {
        return this.access_se;
    }

    public Tag[] getModifiedTag() {
        Tag tag = this.getFirstTagByType("body");
        if (tag == null) {
            return new Tag[0];
        }
        return tag.getModifiedTag();
    }

    public int getZindex() {
        return 1;
    }

    public CSSValuable[] getPopupBackGround() {
        return new CSSValuable[]{new Color(WebColor.LAVENDER)};
    }

    public boolean isNoCache() {
        return false;
    }

    static {
        obj4uniKey = new Object();
    }

    public static enum AjaxSupport {
        NO,
        POPUP_DIALOG,
        SERVER_PUSH;

        private static final long serialVersionUID = 2L;
    }

    public class PageException
    extends Exception {
        private Throwable ex;
        private Object obj;
        private Page page;
        private RequestParameter request;
        private boolean input_call;

        public PageException(Throwable e) {
            super(e);
            this.ex = null;
            this.obj = null;
            while (e instanceof PageException) {
                e = ((PageException)e).ex;
            }
            this.ex = e;
            this.page = SandBox.getCurrentPage();
            this.request = SandBox.getCurrentRequestParameter();
            this.input_call = SandBox.isCurrentInput();
        }

        public PageException(String mes) {
            super(mes);
            this.ex = null;
            this.obj = null;
            this.ex = null;
            this.page = SandBox.getCurrentPage();
            this.request = SandBox.getCurrentRequestParameter();
            this.input_call = SandBox.isCurrentInput();
        }

        public PageException(Throwable e, Object with) {
            this(e);
            this.obj = with;
        }

        public PageException(String mes, Object with) {
            this(mes);
            this.obj = with;
        }

        public Throwable get() {
            if (this.ex == null) {
                return this;
            }
            if (this.ex instanceof PageException) {
                PageException pe = (PageException)this.ex;
                return pe.get();
            }
            return this.ex;
        }

        public Object getWithObject() {
            return this.obj;
        }

        public Page getPage() {
            return this.page;
        }

        public RequestParameter getRequestParameter() {
            return this.request;
        }

        public boolean isInput() {
            return this.input_call;
        }
    }
}

