/*
 * Decompiled with CFR 0.152.
 */
package paraselene.supervisor;

import paraselene.Page;
import paraselene.supervisor.AjaxForward;
import paraselene.supervisor.Forward;
import paraselene.supervisor.History;
import paraselene.supervisor.OpenOutput;
import paraselene.supervisor.Option;
import paraselene.supervisor.OutputCall;
import paraselene.supervisor.PageID;
import paraselene.supervisor.RequestParameter;
import paraselene.supervisor.SandBox;
import paraselene.supervisor.SessionData;

public class Popup
extends Forward
implements AjaxForward {
    private static final long serialVersionUID = 2L;
    Page active_page = null;
    private Type type;

    public Popup(PageID id, Type dialog_type) {
        super(id);
        this.type = dialog_type;
        History hist = SandBox.getCurrentRequestParameter().getHistory();
        if (hist != null) {
            Page[] page = hist.getBrowsingPage();
            Type ptype = Type.MODELESS;
            for (int i = 0; i < page.length; ++i) {
                if (page[i].getPopupType() != Type.MODAL) continue;
                ptype = Type.MODAL;
                break;
            }
            this.overwriteType(ptype);
        }
    }

    public Popup(Page page) {
        this(page.getID(), Type.MODELESS);
        this.active_page = page;
    }

    @Override
    Page getPage(Page from) {
        if (this.active_page != null) {
            Option.trace("Popup#getPage -> %s", this.active_page.getUniqueKey());
            return this.active_page;
        }
        if (this.out_page == null) {
            Option.trace("Popup#getPage -> null", new Object[0]);
            return null;
        }
        Page p = this.out_page.getPageFactory().getPage(this.out_page.getID());
        Option.trace("Popup#getPage -> %s", p.getUniqueKey());
        return p;
    }

    void overwriteType(Type t) {
        if (this.type == null) {
            return;
        }
        if (t == Type.MODELESS) {
            return;
        }
        this.type = t;
    }

    Type getType() {
        return this.type;
    }

    @Override
    public boolean equals(Object o) {
        return false;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("Popup ");
        if (this.active_page != null) {
            buf = buf.append("active:");
            buf = buf.append(this.active_page.getID().toString());
            buf = buf.append("/").append(this.active_page.getUniqueKey());
        } else {
            buf = buf.append("open:");
            buf = buf.append(this.getPageID().toString());
            buf = buf.append("/").append(this.type.toString());
        }
        return buf.toString();
    }

    @Override
    OutputCall makeOutput(int nk, Page lp, RequestParameter r, SessionData sd) {
        Option.trace("new OpenOutput <- %s", this);
        return new OpenOutput(nk, lp, this, this.getType(), r, sd);
    }

    public static enum Type {
        MODELESS,
        MODAL;

    }
}

