// Paraselene 2.1.1.7 (http://paraselene.sourceforge.jp/) generated this source file.
/*
 * Paraselene
 * Copyright (c) 2009  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.mockup.output.source.base;
public class FormJson extends paraselene.mockup.Output {
protected String getFileByte() { return
"package #1.#x;\n\nimport paraselene.*;\nimport paraselene.supervisor.*;\nimport paraselene.ajax.*;\nimport paraselene.tag.*;\nimport paraselene.tag.form.*;\n\n/**\n * AJAX の Form通信。\n */\npublic class FormJson extends #1.SuperPage {\n	private static final long serialVersionUID = 1L;\n	private Tag	script = new Tag( \"script\", false );\n\n	/**\n	 * コンストラクタ。\n	 */\n	public FormJson() {\n		super();\n		init();\n		script.setAttribute( new Attribute( \"type\", \"text/javascript\" ) );\n	}\n\n	/**\n	 * 初期化。\n	 */\n	public void init(){\n		clear();\n		try {\n			Tag	html = new Tag( \"html\", false );\n			Tag	head = new Tag( \"head\", false );\n			head.addHTMLPart( script );\n			Tag	body = new Tag( \"body\", false );\n			html.addHTMLPart( head, body );\n			setMainTag( html );\n			setDoctype( false, null );\n			super.init();\n			setInitialized( true );\n		}\n		catch( Exception e ) {\n			Option.debug( e );\n		}\n	}\n\n	/**\n	 * ページIDの取得。\n	 * @return ページID。\n	 */\n	public PageID getID() {\n		return PageType.PARASELENE_FORM_JSON;\n	}\n\n	/**\n	 * 別名URI設定。nullを返すと別名は設定しません。\n	 * @return URI。\n	 */\n	public String getAliasURI() {\n		return null;\n	}\n\n	/**\n	 * ブラウザに403を返す。\n	 * @param req リクエスト内容。\n	 * @param fw デフォルト遷移先。\n	 * @exception PageException 処理の継続が不可能(ブラウザには500を返す)。\n	 */\n	public Forward inputMain( RequestParameter req, Forward fw ) throws PageException {\n		return new Forward( 403 );\n	}\n\n	public boolean isHistoryClear() { return false; }\n	public boolean isAllowHistoryAdd() { return false; }\n	public String getCharset() { return \"UTF-8\"; }\n\n	/**\n	 * キャッシュ禁止指定。\n	 * @return true:ブラウザキャッシュを禁止します。\n	 */\n	public boolean isNoCache() { return true; }\n\n	/**\n	 * 初回outputの呼び出しメイン処理。\n	 * @param req リクエスト内容。\n	 * @exception PageException 処理の継続が不可能(ブラウザには500を返す)。\n	 */\n	public void firstOutputMain( RequestParameter req ) throws PageException {\n	}\n\n	/**\n	 * 出力情報の設定を行う。\n	 * @param from 遷移元ページ。直接呼ばれている場合はnullです。\n	 * @param req リクエスト内容。\n	 * @return 出力ページ。\n	 * @exception PageException 処理の継続が不可能(ブラウザには500を返す)。\n	 */\n	public Page outputMain( Page from, RequestParameter req ) throws PageException {\n		StringBuilder	buf = new StringBuilder( \"<!--\\r\\n\" );\n		buf = buf.append( \"parent.paraselene_form_ok('\" );\n		buf = buf.append( from.getUniqueKey() );\n		buf = buf.append( \"');\" );\n		buf = buf.append( \"\\r\\n-->\" );\n		script.setValueString( buf.toString() );\n		return this;\n	}\n}\n\n";}
}
