package #1.#x;

import paraselene.*;
import paraselene.supervisor.*;
import paraselene.ajax.*;
import java.io.*;

/**
 * JSON非同期通信。
 */
public abstract class Json extends #1.SuperPage implements Downloadable {
	private static final long serialVersionUID = 1L;

	/**
	 * クライアントの取得キーを表すパラメータ。
	 */
	protected static final String	KEY = "key";
	private boolean	opera_f = false;
	private JSON	data;
	/**
	 * コンストラクタ。
	 */
	public Json() {
		super();
		try {
			setInitialized( true );
		}
		catch( Exception e ) {
			Option.debug( e );
		}
	}
	/**
	 * ページIDの取得。
	 * @return ページID。
	 */
	public PageID getID() {
		return PageType.PARASELENE_JSON;
	}
	/**
	 * ブラウザに403を返す。
	 * @param req リクエスト内容。
	 * @param fw デフォルト遷移先。
	 * @exception PageException 処理の継続が不可能(ブラウザには500を返す)。
	 */
	public Forward inputMain( RequestParameter req, Forward fw ) throws PageException {
		return new Forward( 403 );
	}
	public boolean isHistoryClear() { return false; }
	public boolean isAllowHistoryAdd() { return false; }
	/**
	 * 別名URI設定。
	 * @return paraselene.json.na
	 */
	public String getAliasURI() {
		return "paraselene.json.na";
	}
	/**
	 * 出力情報のハンドリングを行う。
	 * リクエストに応じて、固定のレスポンスを生成したい時はnull以外を返して下さい。
	 * nullを返すと、Ajaxクラスにキューイングされたものを使用します。
	 * @param req リクエスト内容。
	 * @return レスポンスするインスタンス。null可。
	 */
	protected abstract Serializable outputMain( RequestParameter req ) throws PageException;
	/**
	 * 初回outputの呼び出しメイン処理。
	 * @param req リクエスト内容。
	 * @exception PageException 処理の継続が不可能(ブラウザには500を返す)。
	 */
	public void firstOutputMain( RequestParameter req ) throws PageException{}
	/**
	 * 出力情報の設定を行う。
	 * @param from 遷移元ページ。直接呼ばれている場合はnullです。
	 * @param req リクエスト内容。
	 * @return 出力ページ。
	 * @exception PageException 処理の継続が不可能(ブラウザには500を返す)。
	 */
	public Page outputMain( Page from, RequestParameter req ) throws PageException {
		data = null;
		RequestItem	ajax = req.getItem( Supervisor.A_AJAX_KEY );
		if ( ajax != null ) {
			data = Ajax.get( req.getSession(), ajax.getValue( 0 ) );
		}
		else {
			Serializable	spot = outputMain( req );
			if ( spot != null ) {
				data = new JSON( spot );
			}
			else {
				RequestItem	item = req.getItem( KEY );
				if ( item == null )	return this;
				data = Ajax.get( req.getSession(), item.getValue( 0 ) );
			}
		}
		String[]	ua = req.getHeader( "User-Agent" );
		if ( ua != null ) {
			opera_f = ua[0].indexOf( "Opera" ) != -1;
		}
		return this;
	}
	/**
	 * 出力コンテントタイプ。
	 * @return text/javascript+json; charset=utf-8
	 */
	public String getContentType() {
		return opera_f?
			"text/html; charset=utf-8":
			"text/javascript+json; charset=utf-8";
	}

	/**
	 * キャッシュ禁止指定。
	 * @return true:ブラウザキャッシュを禁止します。
	 */
	public boolean isNoCache() { return true; }

	/**
	 * 出力内容の取得。
	 * @return ストリーム。
	 * @exception PageException 処理の継続が不可能(ブラウザには500を返す)。
	 */
	public InputStream getInputStream() throws PageException {
		String	ret = "{}";
		if ( data != null ) {
			ret = data.toString();
		}
		try {
			return new ByteArrayInputStream( ret.getBytes( "utf-8" ) );
		}
		catch( Exception e ) {
			throw new PageException( e );
		}
	}
}

