/*
 * Decompiled with CFR 0.152.
 */
package paraselene.supervisor;

import java.io.Serializable;
import java.util.ArrayList;
import paraselene.Page;
import paraselene.ajax.data.PostBack;
import paraselene.supervisor.AjaxForward;
import paraselene.supervisor.CloseOutput;
import paraselene.supervisor.Closure;
import paraselene.supervisor.Feedback;
import paraselene.supervisor.Forward;
import paraselene.supervisor.JavaScript;
import paraselene.supervisor.LocationOutput;
import paraselene.supervisor.OpenOutput;
import paraselene.supervisor.Option;
import paraselene.supervisor.OutputCall;
import paraselene.supervisor.Popup;
import paraselene.supervisor.RequestParameter;
import paraselene.supervisor.ScriptOutput;
import paraselene.supervisor.SessionData;

class OutputHolder {
    private Forward[] forward = null;
    private OutputCall[] opc = null;

    OutputHolder(int nk, Page lp, Forward fw, RequestParameter r, SessionData sd) {
        int i;
        Option.trace("%s ajax %s", lp.getID(), lp.isAjax());
        AjaxForward[] af = fw.getAjaxForward(lp.isAjax());
        if (af != null) {
            this.forward = new Forward[af.length];
            for (i = 0; i < af.length; ++i) {
                this.forward[i] = (Forward)((Object)af[i]);
            }
            this.opc = new OutputCall[af.length];
        } else {
            this.forward = new Forward[]{fw};
            this.opc = new OutputCall[1];
        }
        if (lp.isAjax()) {
            for (i = 0; i < this.forward.length; ++i) {
                if (this.forward[i] instanceof JavaScript) {
                    Option.trace("new ScriptOutput <- %s", this.forward[i]);
                    this.opc[i] = new ScriptOutput(nk, lp, this.forward[i], r, sd);
                    continue;
                }
                if (this.forward[i] instanceof Closure) {
                    Closure c = (Closure)this.forward[i];
                    if (c.close_page.getPopupType() == null) {
                        Option.trace("new LocationOutput <- %s", this.forward[i]);
                        this.opc[i] = new LocationOutput(nk, lp, this.forward[i], r, sd);
                        continue;
                    }
                    Option.trace("new CloseOutput <- %s", this.forward[i]);
                    this.opc[i] = new CloseOutput(nk, lp, this.forward[i], r, sd);
                    continue;
                }
                if (this.forward[i] instanceof Feedback) {
                    Option.trace("new OutputCall <- %s", this.forward[i]);
                    this.opc[i] = new OutputCall(nk, lp, this.forward[i], r, sd);
                    continue;
                }
                if (this.forward[i] instanceof Popup) {
                    Option.trace("new OpenOutput <- %s", this.forward[i]);
                    Popup p = (Popup)this.forward[i];
                    this.opc[i] = new OpenOutput(nk, lp, this.forward[i], p.getType(), r, sd);
                    continue;
                }
                Option.trace("new LocationOutput <- %s", this.forward[i]);
                this.opc[i] = new LocationOutput(nk, lp, this.forward[i], r, sd);
            }
            return;
        }
        Option.trace("new OutputCall <- %s", fw);
        this.opc[0] = new OutputCall(nk, lp, fw, r, sd);
    }

    void call() throws Throwable {
        for (int i = 0; i < this.opc.length; ++i) {
            this.opc[i].call();
        }
    }

    Page[] getPage() {
        Page[] p = this.opc[0].getPage();
        return p;
    }

    Serializable[] getPostBack() throws Exception {
        ArrayList<PostBack> ret = new ArrayList<PostBack>();
        for (int i = 0; i < this.opc.length; ++i) {
            PostBack[] pb = this.opc[i].make();
            for (int j = 0; j < pb.length; ++j) {
                ret.add(pb[j]);
            }
        }
        return ret.toArray(new Serializable[0]);
    }
}

