/*
 * Paraselene
 * Copyright (c) 2009  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.supervisor;


/**
 * 遷移先指定。output するページをポップアップ表示します。<br>
 * ただし、遷移元ページのgetAjaxSupportが有効でない場合は、通常の Forward と等価です。
 */
public class Popup extends Forward {
	private static final long serialVersionUID = 2L;
	/**
	 * ポップアップ種別。
	 */
	public enum Type {
		/**
		 * ポップアップの下のページのUI操作を許す。
		 */
		MODELESS,
		/**
		 * ポップアップの下のページのUI操作を禁止する。
		 */
		MODAL
	}

	private Type type;

	/**
	 * コンストラクタ。
	 * @param id 指定ページのポップアップ。
	 * @param dialog_type ポップアップ種別。
	 */
	public Popup( PageID id, Type dialog_type ) {
		super( id );
		type = dialog_type;
	}
}

