/*
 * Paraselene
 * Copyright (c) 2009  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.tag.attr;

import java.io.*;
import java.util.*;
import java.net.*;
import paraselene.*;

/**
 * HTMLタグの属性(色を示すもの)。
 */
public class ColorAttribute extends Attribute {
	private static final long serialVersionUID = 1L;
	private static String[] clr_name = new String[] {
		"color", "bgcolor", "text", "link", "vlink", "alink",
		"bordercolor", "bordercolordark", "bordercolorlight",
	};
	private static HashMap<String,String> clr_map = new HashMap<String,String>();
	static {
		for ( int i = 0; i < clr_name.length; i++ ) {
			clr_map.put( clr_name[i], clr_name[i] );
		}
	}

	/**
	 * 複製の作成。
	 * @return 複製。
	 */
	public Attribute getReplica() {
		return new ColorAttribute( getName(), (Color)get().getReplica() );
	}

	/**
	 * 色属性であるか？
	 * @param n 属性名。
	 * @return true:色属性、false:色属性ではない。
	 */
	public static boolean isColor( String n ) {
		return ( clr_map.get( n.toLowerCase( Locale.ENGLISH ) ) != null );
	}

	private ColorAttribute() {}
	/**
	 * コンストラクタ。
	 * @param n 属性名。
	 * @param clr 色。
	 */
	public ColorAttribute( String n, Color clr ) {
		setName( n );
		set( clr );
	}

	/**
	 * 属性値の設定。
	 * @param clr 色。
	 */
	public void set( Color clr ) {
		super.set( clr );
	}

	/**
	 * 属性値の取得。
	 * @return 色。
	 */
	public Color get() {
		return (Color)super.get();
	}
}

