/*
 * Paraselene
 * Copyright (c) 2009  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.mockup;


import java.util.*;
import java.io.*;
import java.net.*;
import paraselene.*;
import paraselene.tag.*;
import paraselene.tag.attr.*;
import paraselene.supervisor.*;
import paraselene.dyna.*;

/**
 * 解析後バッファ。
 */
public class PrePage extends DynamicPage implements OutputNo {
	class PrePageID implements PageID {
		private int id = 0;
		PrePageID( int p ) {
			id = p;
		}
		public boolean isSame( Page p ) {
			return p.getID().getID() == id;
		}
		public int getID() {
			return id;
		}
		public PageFactory getPageFactory() {
			return null;
		}
		public PageID getPageID( int hash ) {
			return null;
		}
	}

	// 出力タイプ 0:view 1:logic
	static final String[] out_dir = { "view", "logic" };

	private String toName( String name ) {
		char[]	ch = name.toCharArray();
		ch[0] = Character.toUpperCase( ch[0] );
		for ( int i = 1; i < ch.length; i++ ) {
			ch[i] = Character.toLowerCase( ch[i] );
		}
		return new String( ch );
	}

	private HashMap<String,Integer>	method = new HashMap<String,Integer>();

	private StringBuffer toName( String tag, String name ) {
		StringBuffer	buf = new StringBuffer( " get" );
		String[]	part = name.split( "[\\p{Punct}\\p{Space}]+" );
		for ( int i = 0; i < part.length; i++ ) {
			if ( part[i].length() == 0 ) {
				buf = buf.append( "_" );
			}
			else {
				buf = buf.append( toName( part[i] ) );
			}
		}
		buf = buf.append( toName( tag ) );
		name = buf.toString();
		Integer	cnt = method.get( name );
		if ( cnt == null ) {
			method.put( name, 1 );
		}
		else {
			cnt++;
			buf = buf.append( cnt );
			addNote( "警告: " + name + " に類似するメソッドを作成しました。" );
		}
		return buf.append( "() {\n" );
	}

	private StringBuffer getCom( String name, TagSource t ) {
		StringBuffer	buf = new StringBuffer( "/**\n" );
		buf = buf.append( " * " );
		buf = buf.append( name );
		buf = buf.append( "." );
		if ( t != null ) {
			buf = buf.append( "\n" );
			buf = buf.append( " * <br>" );
			buf = buf.append( t.getTagString() );
		}
		return buf.append( "\n **/\npublic " );
	}

	private StringBuffer getMethod( String name, Tag t ) throws TagException {
		StringBuffer	buf = getCom( name, (TagSource)t );
		String	cls = TagMap.getClassString( t );
		buf = buf.append( cls );
		buf = buf.append( toName( t.getName(), name ) );
		buf = buf.append( "return (" );
		buf = buf.append( cls );
		buf = buf.append( ")getTag( \"" );
		buf = buf.append( name );
		return buf.append( "\" );\n}\n" );
	}

	private StringBuffer getMethod( String name ) throws TagException {
		Tag[]	t = getAllTag( name );
		ArrayList<Tag>	left_tag = new ArrayList<Tag>();
		for ( int i = 0; i < t.length; i++ ) {
			if ( Param.isIgnoreTagAccesser( t[i] ) )	continue;
			left_tag.add( t[i] );
		}
		StringBuffer	buf = new StringBuffer();
		if ( left_tag.size() == 0 )	return buf;
		t = left_tag.toArray( new Tag[0] );

		if ( t.length == 1 )	buf = buf.append( getMethod( name, t[0] ) );
		else	addNote( "name=" + name + "のタグは配列化されました。" );
		buf = buf.append( getCom( name, null ) );
		buf = buf.append( TagMap.TAG );
		buf = buf.append( "[]" );
		buf = buf.append( toName( "Tags", name ) );
		buf = buf.append( "return getAllTag( \"" );
		buf = buf.append( name );
		return buf.append( "\" );\n}\n" );
	}

	public String getString( int no ) {
		switch( no ) {
		case 1:
			return Param.PACKAGE.get();
		case 2:
			return package_name;
		case 3:
			return path;
		case 4:
			return class_name;

		case 5:
			{
				TagSource	tag = (TagSource)getMainTag();
				StringBuffer	buf = new StringBuffer( tag.toSource() );
				buf = buf.append( "setMainTag(" );
				buf = buf.append( tag.getValName() );
				buf = buf.append( ");\n" );

				buf = buf.append( "setDoctype(" );
				buf = buf.append( Boolean.toString( isXML() ) );
				buf = buf.append( "," );
				buf = buf.append( Make.escape( getDoctype() ) );
				buf = buf.append( ");\n" );

				buf = buf.append( "addVersionComment(" );
				buf = buf.append( Make.escape( Version.getTitle() ) );
				buf = buf.append( "," );
				buf = buf.append( Make.escape( new Date().toString() ) );
				buf = buf.append( ");\n" );

				return buf.toString();
			}
		case 6:
			return getEnumName( true );
		case 7:
			{
				StringBuffer	buf = new StringBuffer();
				String[]	name = getDefineNameIndex();
				for ( int i = 0; i < name.length; i++ ) {
					try {
						buf = buf.append( getMethod( name[i] ) );
					}
					catch( Exception e ) {}
				}
				return buf.toString();
			}
		}
		return null;
	}

	String getClassName() {
		StringBuffer	buf = new StringBuffer( Param.PACKAGE.get() );
		buf = buf.append( "." );
		buf = buf.append( out_dir[1] );
		if ( package_name.length() > 0 ) {
			buf = buf.append( package_name );
		}
		buf = buf.append( "." );
		buf = buf.append( class_name );
		return buf.toString();
	}

	String getEnumName( boolean only_f ) {
		if ( only_f )	return enum_name;
		StringBuffer	buf = new StringBuffer( Param.PACKAGE.get() );
		buf = buf.append( ".base.PageType." );
		buf = buf.append( enum_name );
		return buf.toString();
	}

	void makeSourceMain( int dir, Output output ) throws Exception {
		Linker.readme.setCurrentPage( this );
		StringBuffer	out_path = new StringBuffer( Make.SRC_PATH );
		out_path = out_path.append( File.separator );
		out_path = out_path.append( out_dir[dir] );
		out_path = out_path.append( File.separator );
		out_path = out_path.append( java_path );
		String	name = out_path.toString();
		File	file = new File( name );
		Linker.readme.echoln( name + " output starts." );
		if ( dir == 1 ) {
			if ( file.exists() ) {
				Linker.readme.echoln( name + " was not output, because it already existed." );
				return;
			}
		}
		Output.Status	stat = output.write( file, this, html_last_time );
		switch( stat ) {
		case OK:
			Linker.readme.echoln( name + " output ended." );
			break;
		case SKIP:
			Linker.readme.echoln( name + " is not modified." );
			break;
		}
	}

	void makeSource() throws Exception {
		Output[]	output = {
			new paraselene.mockup.output.source.view.view(),
			new paraselene.mockup.output.source.logic.logic()
		};
		for ( int i = 0; i < 2; i++ ) {
			makeSourceMain( i, output[i] );
		}
	}

	private static HashMap<Integer, PrePage>	hash_map = new HashMap<Integer, PrePage>();
	private int id = 0;
	private String path = "";
	// package_nameにParam.PACKAGE + view|logic を付加する。
	private String package_name;
	private String java_path;
	private String class_name;
	private String enum_name;
	private long	html_last_time = 0;

	private HashMap<String,String>	name_class = new HashMap<String,String>();
	private HashMap<String,ArrayList<String>>	group_name = new HashMap<String,ArrayList<String>>();
	private ArrayList<String>	note = new ArrayList<String>();

	void addNote( String n ) {
		note.add( n );
	}

	String getNote() {
		StringBuffer	buf = new StringBuffer();
		int	cnt = note.size();
		for ( int i = 0; i < cnt; i++ ) {
			buf = buf.append( note.get( i ) );
			if ( i != ( cnt - 1 ) )	buf = buf.append( "\n" );
		}
		return buf.toString();
	}

	private static final String	NULL_TITLE = "(タイトルなし)";
	private static final String	SKIP_TITLE = "(解析skip) ";

	String getTitle() {
		Tag[]	tag = getAllTagByType( "title" );
		if ( tag == null )	return SKIP_TITLE;
		if ( tag.length == 0 )	return NULL_TITLE;
		String	str = tag[0].getValueString();
		if ( str == null )	return NULL_TITLE;
		if ( str.length() == 0 )	return NULL_TITLE;
		return str;
	}

	private static HashMap<String, String>	name_check = new HashMap<String, String>();

	public void init() {
		path = path.substring( Param.HTML_ROOT.get().length() );
		if ( path.charAt( 0 ) == File.separatorChar ) {
			path = path.substring( 1 );
		}

		String[]	check = path.split( "[/\\\\]" );
		for ( int i = 0; i < check.length; i++ ) {
			boolean	ret;
			if ( i == (check.length - 1) ) {
				ret = JavaDefine.isDefine( check[i], false );
			}
			else {
				ret = JavaDefine.isDefine( check[i], true );
			}
			if ( ret ) {
				System.err.println( "ディレクトリ名またはファイル名に使用できない文字が含まれています" );
				System.err.println( path );
				System.exit( 1 );
			}
		}

		File	tmp = new File( path );
		java_path = tmp.getParent();
		if ( java_path == null ) {
			package_name = "";
			java_path = "";
		}
		else {
			char[]	ch = java_path.toCharArray();
			for ( int i = 0; i < ch.length; i++ ) {
				if ( ch[i] == '.' ) {
					ch[i] = '_';
				}
				if ( ch[i] == File.separatorChar ) {
					ch[i] = '.';
				}
			}
			package_name = "." + new String( ch );
		}
		char[]	ch = java_path.toCharArray();
		for ( int i = 0; i < ch.length; i++ ) {
			if ( ch[i] == File.separatorChar ) {
				ch[i] = '_';
			}
			else {
				ch[i] = Character.toUpperCase( ch[i] );
			}
		}
		if ( ch.length > 0 ) {
			enum_name = new String( ch ) + "_";
		}
		else {
			enum_name = "";
		}

		class_name = tmp.getName().toLowerCase( Locale.ENGLISH );
		String[]	part = class_name.split( "[\\p{Punct}\\p{Space}]+" );
		StringBuffer	buf = new StringBuffer();
		for ( int i = 0; i < part.length; i++ ) {
			ch = part[i].toCharArray();
			ch[0] = Character.toUpperCase( ch[0] );
			buf = buf.append( new String( ch ) );
		}
		class_name = buf.toString();

		buf = new StringBuffer( enum_name );
		enum_name = tmp.getName().toUpperCase();
		part = enum_name.split( "[\\p{Punct}\\p{Space}]+" );
		for ( int i = 0; i < part.length; i++ ) {
			if ( i > 0 )	buf = buf.append( "_" );
			buf = buf.append( part[i] );
		}
		enum_name = buf.toString();

		java_path = java_path + File.separatorChar + class_name + ".java";
		String	cf = name_check.get( java_path );
		if ( cf != null ) {
			System.err.println( "似たファイル名が存在するため、生成するクラス名が衝突します" );
			System.err.println( cf );
			System.err.println( path );
			System.exit( 1 );
		}
		name_check.put( java_path, path );

		id = (Param.PACKAGE.get() + path).hashCode();
		if ( id < 0 )	id *= -1;
		while( true ) {
			PrePage	page = hash_map.get( id );
			if ( page == null )	break;
			id++;
			if ( id < 10 )	id = 10;
		}
		hash_map.put( id, this );
	}

	protected DynamicPage makePage() {
		return new PrePage( this );
	}

	private PrePage( Page p ) {
		super( Boolean.valueOf( Param.NEKO.get() ), null, p, Param.provider );
	}

	PrePage( File p )
	throws FileNotFoundException, UnsupportedEncodingException, IOException,
	DynamicPageException {
		this( p, false );
	}

	PrePage( File p, boolean dev_f )
	throws FileNotFoundException, UnsupportedEncodingException, IOException,
	DynamicPageException {
		super( Boolean.valueOf( Param.NEKO.get() ), null, Param.provider );
		path = p.getPath();
		html_last_time = p.lastModified();
		if ( !dev_f )	init();
		if ( this instanceof Download )	return;

		StringBuffer	out_path = new StringBuffer( Make.SRC_PATH );
		out_path = out_path.append( File.separator );
		out_path = out_path.append( out_dir[0] );
		out_path = out_path.append( File.separator );
		out_path = out_path.append( java_path );
		if ( new File( out_path.toString() ).lastModified() > html_last_time )	return;

		Linker.readme.setCurrentPage( this );
		create( p, Param.IN_ENCODE.get() );
	}

	public PageID getID() { return new PrePageID( id ); }
	protected URI getMyselfURI() {
		try {
			return new URI( Output.toHtmlPath( path ) );
		}
		catch( Exception e ) {
			return null;
		}
	}

	public String getContentType() {
		return "text/html; charset=" + getCharset();
	}

	public String getCharset() {
		return Param.OUT_ENCODE.get();
	}

	public static void main( String[] argc ) throws Exception {
		File	inp = new File( argc[0] );
		SourceHead.init( new File( argc[2] ) );
		PrePage	pp = new PrePage( inp, true );
		paraselene.mockup.output.source.view.readme	readme = new paraselene.mockup.output.source.view.readme();
		readme.write( new File( argc[1] ), pp, Long.MAX_VALUE );
	}

	protected Tag makeTag( String name, ArrayList<Attribute> attr ) throws Exception {
		TagSource	nt = new TagSource( name, isSimpleTag( name ) );
		int	cnt = attr.size();
		for ( int i = 0; i < cnt; i++ ) {
			nt.setAttribute( attr.get( i ) );
		}
		return nt;
	}

	protected Comment makeComment( String str ) {
		return new CommentSource( str );
	}

	protected Text makeText( String str ) {
		return new TextSource( str );
	}

	protected boolean isRuntime() {
		return false;
	}
}


