/*
 * Paraselene
 * Copyright (c) 2009  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */

package paraselene.dyna.mockup;

import java.net.*;

/**
 * スケルトンソースに含めるURIの扱いを示します。
 */
public class URIHandle {
	/**
	 * URI処理方法。
	 */
	public enum URIProcess {
		/**
		 * 全処理を行う。
		 * URIHandleが示すパスをスケルトン生成ツールが通常通りURI解決する。
		 */
		FULL_PROCESS,
		/**
		 * -other未適用。
		 * URIHandleが示すパスをスケルトン生成ツールが通常通りURI解決する。
		 * ただし、静的コンテンツだった場合、-otherのパスを適用せず、
		 * URIHandleが示すパスをそのまま使用する。
		 */
		NOT_USE_OTHER,
		/**
		 * 処理しない。
		 * URIHandleが示すパスをスケルトン生成ツールは一切URI解決しない。
		 * URIHandleが示すパスをそのまま使用する。
		 * ページクラスに解決されないので注意。
		 */
		NO_PROCESS
	}

	private URI	uri;
	private URIProcess process;
	/**
	 * コンストラクタ。
	 * @param u スケルトン生成ツールに渡すURI。
	 * @param p スケルトン生成ツールのURI処理の指示。
	 */
	public URIHandle( URI u, URIProcess p ) {
		uri = u;
		process = p;
	}
	/**
	 * URI取得。
	 * @return URI。
	 */
	public URI getURI() {
		return uri;
	}
	/**
	 * URI処理方法の取得。
	 * @return URI処理方法。
	 */
	public URIProcess getURIProcess() {
		return process;
	}
}


