/*
 * Decompiled with CFR 0.152.
 */
package paraselene.css;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;
import paraselene.HTMLPart;
import paraselene.Text;
import paraselene.Valuable;
import paraselene.css.CSSParser;
import paraselene.css.CSSValuable;
import paraselene.mockup.Converter;
import paraselene.tag.Tag;

public class Property
implements Serializable {
    private static final long serialVersionUID = 2L;
    public static final String IMPORTANT = "!important";
    private String name;
    private CSSValuable[] value;
    private boolean important_f;
    private Tag embed_tag = HTMLPart.getDummyTag();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAssignedTag(Tag t) {
        if (t == null) {
            t = HTMLPart.getDummyTag();
        }
        this.embed_tag = t;
        Property property = this;
        synchronized (property) {
            if (this.value != null) {
                for (int i = 0; i < this.value.length; ++i) {
                    this.value[i].setAssignedTag(t);
                }
            }
        }
    }

    public Property getReplica() {
        Valuable[] rep = new Text[this.value.length];
        for (int i = 0; i < rep.length; ++i) {
            rep[i] = (CSSValuable)((Object)this.value[i].getReplica());
        }
        return new Property(this.important_f, this.name, rep);
    }

    public static Property[] create(String str, String dec) {
        str = str.trim();
        ArrayList<Property> ret = new ArrayList<Property>();
        String[] line = CSSParser.split(str, ';');
        for (int i = 0; i < line.length; ++i) {
            String[] part = CSSParser.split(line[i], ':');
            ret.add(new Property(part[0].trim(), part[1].trim(), dec));
        }
        return ret.toArray(new Property[0]);
    }

    private Property() {
    }

    public Property(boolean important, String n, String v, String dec) {
        this.setImportant(important);
        this.setName(n);
        this.set(v, dec);
    }

    public Property(String n, String v, String dec) {
        this(false, n, v, dec);
    }

    public Property(boolean important, String n, Valuable ... v) {
        this.setImportant(important);
        this.setName(n);
        this.set(v);
    }

    public Property(String n, Valuable ... v) {
        this(false, n, v);
    }

    public void setImportant(boolean important) {
        this.important_f = important;
        this.embed_tag.setModify();
    }

    public boolean isImportant() {
        return this.important_f;
    }

    private void setName(String n) {
        this.name = n.toLowerCase(Locale.ENGLISH);
        this.embed_tag.setModify();
    }

    public String getName() {
        return this.name;
    }

    public void set(String v, String dec) {
        if (v == null) {
            this.value = null;
            this.embed_tag.setModify();
            return;
        }
        String[] str = CSSParser.split(CSSParser.split(v, ';')[0], ' ');
        ArrayList<CSSValuable> list = new ArrayList<CSSValuable>();
        for (int i = 0; i < str.length; ++i) {
            str[i] = str[i].trim();
            if (str[i].isEmpty()) continue;
            if ("!".equals(str[i])) {
                if (i >= str.length - 1) continue;
                str[i + 1] = "!" + str[i + 1];
                continue;
            }
            if (IMPORTANT.equals(str[i])) {
                this.setImportant(true);
                continue;
            }
            list.add(Converter.toCSSValuable(str[i], dec));
        }
        this.set(list.toArray(new CSSValuable[0]));
        this.embed_tag.setModify();
    }

    public void set(Valuable ... v) {
        this.value = Converter.toCSSValuable(v);
        this.embed_tag.setModify();
    }

    public CSSValuable[] get() {
        return this.value;
    }

    private String[] getStringArray() {
        CSSValuable[] t = this.get();
        if (t == null) {
            return null;
        }
        if (t.length == 0) {
            return null;
        }
        String[] ret = new String[t.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = t[i].toString(HTMLPart.StringMode.CSS);
        }
        return ret;
    }

    public String getString() {
        String[] s = this.getStringArray();
        if (s == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(s[0]);
        for (int i = 1; i < s.length; ++i) {
            buf = buf.append(" ");
            buf = buf.append(s[i]);
        }
        return buf.toString();
    }

    public String toHtmlString() {
        StringBuilder buf = new StringBuilder(this.name);
        buf = buf.append(":");
        buf = buf.append(this.getString());
        buf = buf.append(";");
        return buf.toString();
    }

    public String toString() {
        return this.toHtmlString();
    }
}

