/*
 * Paraselene
 * Copyright (c) 2009  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.tag.table;


import java.io.*;
import paraselene.*;
import paraselene.tag.*;

/**
 * カラムを表す。tdタグまたはthタグ。
 * スレッドセーフです。
 */
public class Column extends Tag {
	private static final long serialVersionUID = 2L;
	/**
	 * タイプ。
	 */
	public enum Type {
		/**
		 * テーブルヘッダ。THタグ。
		 */
		HEADER("th"),
		/**
		 * テーブルデータ。TDタグ。
		 */
		DATA("td");

		private static final long serialVersionUID = 1L;
		String str;

		private Type( String s ) {
			str = s;
		}
	}

	private Type	const_type;
	/**
	 * 種別の取得。
	 * @return 種別。
	 */
	public Type getType() {
		return const_type;
	}

	/**
	 * コンストラクタ。
	 * @param type タイプ。
	 */
	public Column( Type type ) {
		super( type.str, false );
		const_type = type;
	}

	protected Tag newReplica() {
		return new Column( const_type );
	}
}

