/*
 * Decompiled with CFR 0.152.
 */
package paraselene.tag;

import java.io.Serializable;
import java.util.Locale;
import paraselene.HTMLPart;
import paraselene.Valuable;
import paraselene.mockup.Converter;
import paraselene.tag.AttributeValuable;
import paraselene.tag.Tag;

public class Attribute
implements Serializable {
    private static final long serialVersionUID = 2L;
    private String name;
    private AttributeValuable[] value = null;
    private Tag embed_tag = HTMLPart.getDummyTag();

    protected Attribute() {
    }

    synchronized void setAssignedTag(Tag t) {
        if (t == null) {
            t = HTMLPart.getDummyTag();
        }
        this.embed_tag = t;
        if (this.value != null) {
            for (int i = 0; i < this.value.length; ++i) {
                this.value[i].setAssignedTag(t);
            }
        }
    }

    public Attribute getReplica() {
        Valuable[] attr = new AttributeValuable[this.value.length];
        for (int i = 0; i < attr.length; ++i) {
            attr[i] = (AttributeValuable)this.value[i].getValuableReplica();
        }
        return new Attribute(this.name, attr);
    }

    public Attribute(String n, String v) {
        this.setName(n);
        this.set(v);
    }

    public Attribute(String n) {
        this.setName(n);
    }

    public Attribute(String n, Valuable v) {
        this.setName(n);
        this.set(v);
    }

    public Attribute(String n, Valuable ... v) {
        this.setName(n);
        this.set(v);
    }

    protected void setName(String n) {
        this.name = n.toLowerCase(Locale.ENGLISH);
        this.embed_tag.setModify();
    }

    public String getName() {
        return this.name;
    }

    public void set(String v) {
        this.set(null, v);
    }

    public void set(String dec, String v) {
        this.value = Converter.toAttributeValuable(this.getName(), v, dec);
        this.setAssignedTag(this.embed_tag);
        this.embed_tag.setModify();
    }

    public void set(Valuable ... v) {
        this.set((String)null, v);
    }

    public void set(String dec, Valuable ... v) {
        this.value = Converter.toAttributeValuable(this.getName(), v, dec);
        this.setAssignedTag(this.embed_tag);
        this.embed_tag.setModify();
    }

    public AttributeValuable[] getAll() {
        return this.value;
    }

    public AttributeValuable get() {
        AttributeValuable[] ret = this.getAll();
        if (ret == null) {
            return null;
        }
        if (ret.length < 1) {
            return null;
        }
        return ret[0];
    }

    public String getString() {
        return this.getValueString();
    }

    protected String getValueString() {
        AttributeValuable[] v = this.getAll();
        if (v == null) {
            return null;
        }
        if (v.length < 1) {
            return null;
        }
        StringBuilder buf = new StringBuilder(v[0].toString(HTMLPart.StringMode.ATTRIBUTE));
        for (int i = 1; i < v.length; ++i) {
            buf = buf.append(",");
            buf = buf.append(v[i].toString(HTMLPart.StringMode.ATTRIBUTE));
        }
        return buf.toString();
    }

    public String toHtmlString(boolean xml) {
        StringBuilder buf = new StringBuilder(this.name);
        if (this.getValueString() != null) {
            buf = buf.append("=");
            buf = buf.append("\"");
            buf = buf.append(this.getValueString());
            buf = buf.append("\"");
        } else if (xml) {
            buf = buf.append("=");
            buf = buf.append("\"");
            buf = buf.append(this.name);
            buf = buf.append("\"");
        }
        return buf.toString();
    }

    public String toString() {
        try {
            return this.toHtmlString(false);
        }
        catch (Exception e) {
            return e.toString();
        }
    }
}

