/*
 * Decompiled with CFR 0.152.
 */
package paraselene.supervisor;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import paraselene.Page;
import paraselene.supervisor.Null;
import paraselene.supervisor.PageFactory;
import paraselene.supervisor.PageID;
import paraselene.supervisor.PathData;

public class TransactionSequencer
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final String[] SALANE = new String[]{"lu", "mo", "on", "na"};
    public static final String EXTENSION = "." + SALANE[3];
    private volatile int seq = 0;
    private HashMap<Integer, Boolean> no_map = new HashMap();
    private static final String[] HEAD = new String[]{"seleno", "lilith"};
    private static final int HEAD_LENGTH = 6;

    TransactionSequencer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int newNo(PageID id) {
        long dt = new Date().getTime() / 1000L & 0x7FFFFFL;
        int ret = (int)(dt << 8);
        TransactionSequencer transactionSequencer = this;
        synchronized (transactionSequencer) {
            this.seq += (int)(Math.random() * 5.0);
            this.no_map.put(ret |= this.seq & 0xFF, false);
        }
        return ret;
    }

    public static String makeURI(TransactionSequencer seq, PageID from, PageID to) {
        StringBuilder buf = new StringBuilder();
        if (seq != null) {
            buf = buf.append(SALANE[0]);
            buf = buf.append(".");
            buf = buf.append(HEAD[0]);
            buf = buf.append(Integer.toString(seq.newNo(to), 36));
            buf = buf.append(".");
        }
        if (from != null) {
            buf = buf.append(SALANE[1]);
            buf = buf.append(".");
            buf = buf.append(Integer.toString(from.getID(), 36));
            buf = buf.append(".");
        }
        buf = buf.append(SALANE[2]);
        buf = buf.append(".");
        buf = buf.append(Integer.toString(to.getID(), 36));
        buf = buf.append(".");
        buf = buf.append(SALANE[3]);
        return buf.toString();
    }

    static String makeRedirectURI(TransactionSequencer seq, PageID to) {
        StringBuilder buf = new StringBuilder();
        buf = buf.append(SALANE[0]);
        buf = buf.append(".");
        buf = buf.append(HEAD[1]);
        buf = buf.append(Integer.toString(seq.newNo(null), 36));
        buf = buf.append(".");
        buf = buf.append(SALANE[2]);
        buf = buf.append(".");
        buf = buf.append(Integer.toString(to.getID(), 36));
        buf = buf.append(".");
        buf = buf.append(SALANE[3]);
        return buf.toString();
    }

    private static Page getPage(String no, PageFactory fact) {
        Page ret = null;
        try {
            ret = fact.getPage(Integer.parseInt(no, 36));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ret == null) {
            return new Null();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PathData parsePath(TransactionSequencer seq, String uri, PageFactory fact) {
        String[] path = uri.split("\\?");
        if (path != null) {
            uri = path[0];
        }
        path = uri.split("/");
        for (int i = path.length - 1; i >= 0; --i) {
            String[] body = path[i].split("\\.");
            if (body.length == 0 || !SALANE[3].equals(body[body.length - 1])) continue;
            PathData ret = new PathData();
            int cnt = body.length - 1;
            boolean redirect_f = false;
            boolean request_id = false;
            for (int j = 0; j < cnt; j += 2) {
                if (seq != null && SALANE[0].equals(body[j])) {
                    if (body[j + 1].length() <= 6) {
                        return null;
                    }
                    String head = body[j + 1].substring(0, 6);
                    String number = body[j + 1].substring(6);
                    if (HEAD[1].equals(head)) {
                        redirect_f = true;
                    } else if (!HEAD[0].equals(head)) {
                        return null;
                    }
                    int no = Integer.parseInt(number, 36);
                    TransactionSequencer transactionSequencer = seq;
                    synchronized (transactionSequencer) {
                        Boolean flag = seq.no_map.get(no);
                        if (flag == null) {
                            return null;
                        }
                        request_id = true;
                        ret.called = flag;
                        seq.no_map.put(no, true);
                        continue;
                    }
                }
                if (SALANE[1].equals(body[j])) {
                    ret.from = TransactionSequencer.getPage(body[j + 1], fact);
                    continue;
                }
                if (!SALANE[2].equals(body[j])) continue;
                if (redirect_f) {
                    ret.redirect = TransactionSequencer.getPage(body[j + 1], fact);
                    continue;
                }
                ret.to = TransactionSequencer.getPage(body[j + 1], fact);
            }
            if (ret.from != null) {
                Page out = ret.to;
                if (out == null) {
                    out = ret.redirect;
                }
                if (out != null && seq != null && out.isCheckRepeatSameRequest() && !request_id) {
                    return null;
                }
            }
            return ret;
        }
        return null;
    }

    static boolean isMustSession(String uri) {
        String[] path = uri.split("/");
        for (int i = path.length - 1; i >= 0; --i) {
            String[] body = path[i].split("\\.");
            if (body.length == 0 || !SALANE[3].equals(body[body.length - 1])) continue;
            int cnt = body.length - 1;
            for (int j = 0; j < cnt; j += 2) {
                if (SALANE[0].equals(body[j])) {
                    return true;
                }
                if (!SALANE[1].equals(body[j])) continue;
                return true;
            }
            return false;
        }
        return false;
    }
}

