/*
 * Decompiled with CFR 0.152.
 */
package paraselene.css;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;
import paraselene.css.CSSParser;
import paraselene.css.SelectorAttribute;
import paraselene.tag.Attribute;
import paraselene.tag.Tag;

public class Selector
implements Serializable {
    private static final long serialVersionUID = 2L;
    private String tag_name;
    private String id_name;
    private String class_name;
    private ArrayList<SelectorAttribute> attr = new ArrayList();
    private Selector parent;
    private Selector child;
    private Selector up;
    private Selector down;
    private Selector define_prev;
    private Selector define_next;
    private boolean parent_near_f = false;
    private boolean child_near_f = false;

    private Selector getStart() {
        if (this.parent != null) {
            return this.parent.getStart();
        }
        if (this.up != null) {
            return this.up.getStart();
        }
        return this;
    }

    private Selector getEnd() {
        if (this.child != null) {
            return this.child.getEnd();
        }
        if (this.down != null) {
            return this.down.getEnd();
        }
        return this;
    }

    private Selector getDefineStart() {
        if (this.define_prev != null) {
            return this.define_prev.getStart();
        }
        return this;
    }

    private Selector getDefineEnd() {
        if (this.define_next != null) {
            return this.define_next.getEnd();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Selector joinChild(Selector parent, Selector child, boolean direct) {
        Selector ret = child;
        if (parent == null || child == null) {
            return ret;
        }
        Selector selector = ret;
        synchronized (selector) {
            parent = parent.getEnd();
            parent.child = child = child.getStart();
            parent.child_near_f = direct;
            child.parent = parent;
            child.parent_near_f = direct;
            return ret.getEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Selector joinNext(Selector up, Selector down) {
        Selector ret = down;
        if (up == null || down == null) {
            return ret;
        }
        Selector selector = ret;
        synchronized (selector) {
            up = up.getEnd();
            up.down = down = down.getStart();
            down.up = up;
            return ret.getEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Selector joinClass(Selector main, Selector cls) {
        Selector ret = main;
        if (main == null || cls == null) {
            return ret;
        }
        Selector selector = ret;
        synchronized (selector) {
            main = main.getDefineEnd();
            main.define_next = cls = cls.getDefineStart();
            cls.define_prev = main;
            return ret.getDefineStart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Selector getReplica() {
        Selector selector = this;
        synchronized (selector) {
            Selector myself = new Selector(this.tag_name, this.id_name, this.class_name, this.attr.toArray(new SelectorAttribute[0]));
            if (this.define_next != null) {
                Selector.joinClass(myself, this.define_next.getReplica());
            }
            if (this.parent != null) {
                Selector.joinChild(this.parent.getReplica(), myself, this.parent_near_f);
            }
            if (this.up != null) {
                Selector.joinNext(this.up.getReplica(), myself);
            }
            return myself;
        }
    }

    private StringBuilder toStringBuilder(StringBuilder buf) {
        if (this.parent != null) {
            buf = this.parent.toStringBuilder(buf);
            buf = buf.append(" ");
            if (this.child_near_f) {
                buf = buf.append("> ");
            }
        }
        if (this.up != null) {
            buf = this.up.toStringBuilder(buf);
            buf = buf.append(" + ");
        }
        if (this.tag_name != null) {
            buf = buf.append(CSSParser.escape(this.tag_name));
        }
        if (this.id_name != null) {
            buf = buf.append("#");
            buf = buf.append(CSSParser.escape(this.id_name));
        }
        if (this.class_name != null) {
            buf = buf.append(".");
            buf = buf.append(CSSParser.escape(this.class_name));
        }
        if (this.define_next != null) {
            buf = buf.append(":");
            buf = this.define_next.toStringBuilder(buf);
        }
        int cnt = this.attr.size();
        for (int i = 0; i < cnt; ++i) {
            buf = buf.append(this.attr.get(i).toString());
        }
        return buf;
    }

    public String toString() {
        return this.toStringBuilder(new StringBuilder()).toString();
    }

    public boolean isHit(Tag tag) {
        return this.isHit(tag, false);
    }

    private boolean isHit(Tag tag, boolean pa_f) {
        if (tag == null) {
            return false;
        }
        if (this.tag_name != null && !"*".equals(this.tag_name) && !this.tag_name.equals(tag.getName())) {
            return pa_f ? this.isHit(tag.getOuterTag(), true) : false;
        }
        int cnt = this.attr.size();
        for (int i = 0; i < cnt; ++i) {
            SelectorAttribute sa = this.attr.get(i);
            Attribute a = tag.getAttribute(sa.name);
            if (a == null) {
                return pa_f ? this.isHit(tag.getOuterTag(), true) : false;
            }
            String str = a.getString();
            if (str == null) {
                return pa_f ? this.isHit(tag.getOuterTag(), true) : false;
            }
            boolean flag = false;
            if (sa.include_f || sa.part_f) {
                String[] p = CSSParser.split(str, sa.include_f ? (char)' ' : '-');
                for (int j = 0; j < p.length && !(flag = p[j].equals(sa.value)); ++j) {
                }
            } else {
                flag = str.equals(sa.value);
            }
            if (flag) continue;
            return pa_f ? this.isHit(tag.getOuterTag(), true) : false;
        }
        if (this.parent != null) {
            return this.isHit(tag.getOuterTag(), !this.parent_near_f);
        }
        if (this.up != null) {
            return this.isHit(tag.getOverTag(), false);
        }
        return true;
    }

    private Selector() {
    }

    public Selector(String t, String id, String cls, SelectorAttribute ... a) {
        this.tag_name = t.toLowerCase(Locale.ENGLISH).trim();
        this.id_name = id.trim();
        this.class_name = cls.trim();
        for (int i = 0; i < a.length; ++i) {
            this.attr.add(a[i]);
        }
    }

    private static void set(Selector s, char m, StringBuilder b) {
        String str = b.toString().trim();
        switch (m) {
            case '.': {
                s.class_name = str;
                s.attr.add(new SelectorAttribute("class", str, true, false));
                break;
            }
            case '#': {
                s.id_name = str;
                s.attr.add(new SelectorAttribute("id", str, false, false));
                break;
            }
            default: {
                s.tag_name = str.toLowerCase(Locale.ENGLISH);
            }
        }
    }

    private void makeAttribute(String str) {
        if (str == null) {
            return;
        }
        String[] part = CSSParser.split(str, '[', ']');
        for (int i = 0; i < part.length; ++i) {
            int len;
            if (part[i].isEmpty()) continue;
            String[] next = CSSParser.split(part[i], '=');
            char ch = next[0].charAt((len = next[0].length()) - 1);
            if (ch == '~' || ch == '|') {
                next[0] = next[0].substring(0, len - 1);
            }
            String v = null;
            if (next.length > 1) {
                v = next[1];
            }
            SelectorAttribute s = new SelectorAttribute(next[0], v, ch == '~', ch == '|');
            this.attr.add(s);
        }
    }

    private static Selector make(String str) {
        if (str.isEmpty()) {
            return null;
        }
        Selector ret = new Selector();
        StringBuilder buf = new StringBuilder();
        char[] ch = str.toCharArray();
        char marker = ' ';
        for (int i = 0; i < ch.length; ++i) {
            if (ch[i] == ':' || ch[i] == '.' || ch[i] == '#' || ch[i] == '[') {
                Selector.set(ret, marker, buf);
                if (ch[i] == '[') {
                    ret.makeAttribute(new String(ch, i, ch.length - i));
                    return ret;
                }
                marker = ch[i];
                buf = new StringBuilder();
                continue;
            }
            buf = buf.append(ch[i]);
        }
        Selector.set(ret, marker, buf);
        return ret;
    }

    private static Selector nest(String str) {
        String[] part = CSSParser.split(str, ' ', '\t', '\n', '\r', '\f');
        ArrayList<Selector> list = new ArrayList<Selector>();
        Selector last = null;
        boolean pc_f = false;
        boolean br_f = false;
        for (int i = 0; i < part.length; ++i) {
            if (part[i].isEmpty()) continue;
            if (part[i].equals(">")) {
                pc_f = true;
                continue;
            }
            if (part[i].equals("+")) {
                br_f = true;
                continue;
            }
            ArrayList<Selector> define = new ArrayList<Selector>();
            String[] def = CSSParser.split(part[i], ':');
            for (int j = 1; j < def.length; ++j) {
                def[j] = def[j].trim();
                if (def[j].isEmpty()) continue;
                define.add(Selector.make(def[j]));
            }
            Selector sel = Selector.make(def[0]);
            int cnt = define.size();
            Selector loop = sel;
            for (int j = 0; j < cnt; ++j) {
                Selector d;
                loop.define_next = d = (Selector)define.get(j);
                d.define_prev = loop;
                loop = d;
            }
            if (br_f && last != null) {
                last.down = sel;
                sel.up = last;
            } else if (last != null) {
                last.child = sel;
                sel.parent = last;
                if (pc_f) {
                    last.child_near_f = true;
                    sel.parent_near_f = true;
                }
            }
            last = sel;
            list.add(sel);
        }
        return last;
    }

    public static Selector[] create(String str) {
        String[] pare = CSSParser.split(str.trim(), ',');
        ArrayList<Selector> list = new ArrayList<Selector>();
        for (int i = 0; i < pare.length; ++i) {
            pare[i] = pare[i].trim();
            if (pare[i].isEmpty()) continue;
            Selector sel = Selector.nest(pare[i]);
            if ((sel = sel.getEnd()) == null) continue;
            list.add(sel);
        }
        return list.toArray(new Selector[0]);
    }
}

