/*
 * Decompiled with CFR 0.152.
 */
package paraselene.tag.attr;

import java.io.Serializable;
import java.util.Locale;
import paraselene.HTMLPart;
import paraselene.Text;

public class Attribute
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private Text value;

    protected Attribute() {
    }

    public Attribute getReplica() {
        return new Attribute(this.name, (Text)this.value.getReplica());
    }

    public Attribute(String n, String v) {
        this.setName(n);
        this.set(v);
    }

    public Attribute(String n) {
        this.setName(n);
    }

    public Attribute(String n, Text v) {
        this.setName(n);
        this.set(v);
    }

    protected void setName(String n) {
        this.name = n.toLowerCase(Locale.ENGLISH);
    }

    public String getName() {
        return this.name;
    }

    public void set(String v) {
        if (this.value != null) {
            this.value.setText(v);
            return;
        }
        this.value = v == null ? null : new Text(v, HTMLPart.StringMode.ATTRIBUTE);
    }

    public void set(Text v) {
        this.value = v;
    }

    public Text get() {
        return this.value;
    }

    public String getString() {
        Text t = this.get();
        if (t == null) {
            return null;
        }
        return t.toString();
    }

    protected String getValueString() {
        if (this.value == null) {
            return null;
        }
        return this.value.toString(HTMLPart.StringMode.ATTRIBUTE);
    }

    public String toHtmlString(boolean xml) {
        StringBuffer buf = new StringBuffer(this.name);
        if (this.getValueString() != null) {
            buf = buf.append("=");
            buf = buf.append("\"");
            buf = buf.append(this.getValueString());
            buf = buf.append("\"");
        } else if (xml) {
            buf = buf.append("=");
            buf = buf.append("\"");
            buf = buf.append(this.name);
            buf = buf.append("\"");
        }
        return buf.toString();
    }

    public String toString() {
        try {
            return this.toHtmlString(false);
        }
        catch (Exception e) {
            return e.toString();
        }
    }
}

