/*
 * Paraselene
 * Copyright (c) 2009  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.supervisor;


import java.net.*;
import java.io.*;
import paraselene.*;


/**
 * Nullページ(直接呼び出し検証用)。
 */
public abstract class NullPage extends Page {

	/**
	 * コンストラクタ。
	 */
	public NullPage() {
	}

	public final String getContentType() {
		return null;
	}

	public final String getCharset() {
		return null;
	}

	public final PageID getID() {
		return null;
	}

	public final Page output( Page from, RequestParameter req ) throws PageException { return null; }

	public void write( PrintWriter w ) throws UnsupportedEncodingException, URISyntaxException {}

	public final boolean isHistoryClear() {
		return true;
	}

	public final boolean isAllowHistoryAdd() {
		return false;
	}

	public final void init(){ }

	public final String getAliasURI() { return null; }

	public final int getUploadMaxBytes() { return 0; }

	public final boolean isCheckRepeatSameRequest() { return false; }

	public AjaxSupport getAjaxSupport() { return AjaxSupport.NO; }

	public void firstOutput( RequestParameter req ) throws PageException{}
}

