/*
 * Decompiled with CFR 0.152.
 */
package paraselene.tag;

import java.io.Serializable;
import java.util.Locale;
import paraselene.HTMLPart;
import paraselene.Page;
import paraselene.Valuable;
import paraselene.mockup.Converter;
import paraselene.tag.AttributeValuable;

public class Attribute
implements Serializable {
    private static final long serialVersionUID = 2L;
    private String name;
    private AttributeValuable value;
    private Page embed;

    protected Attribute() {
    }

    synchronized void setPage(Page p) {
        this.embed = p;
        if (this.value != null) {
            this.value.setPage(p);
        }
    }

    public Attribute getReplica() {
        return new Attribute(this.name, this.value.getValuableReplica());
    }

    public Attribute(String n, String v) {
        this.setName(n);
        this.set(v);
    }

    public Attribute(String n) {
        this.setName(n);
    }

    public Attribute(String n, Valuable v) {
        this.setName(n);
        this.set(v);
    }

    protected void setName(String n) {
        this.name = n.toLowerCase(Locale.ENGLISH);
    }

    public String getName() {
        return this.name;
    }

    public void set(String v) {
        this.value = Converter.toAttributeValuable(this.getName(), v, null);
        this.setPage(this.embed);
    }

    public void set(String v, String dec) {
        this.value = Converter.toAttributeValuable(this.getName(), v, dec);
        this.setPage(this.embed);
    }

    public void set(Valuable v) {
        this.value = Converter.toAttributeValuable(this.getName(), v, null);
        this.setPage(this.embed);
    }

    public void set(Valuable v, String dec) {
        this.value = Converter.toAttributeValuable(this.getName(), v, dec);
        this.setPage(this.embed);
    }

    public AttributeValuable get() {
        return this.value;
    }

    public String getString() {
        AttributeValuable t = this.get();
        if (t == null) {
            return null;
        }
        return t.toString(HTMLPart.StringMode.ATTRIBUTE);
    }

    protected String getValueString() {
        if (this.value == null) {
            return null;
        }
        return this.value.toString(HTMLPart.StringMode.ATTRIBUTE);
    }

    public String toHtmlString(boolean xml) {
        StringBuilder buf = new StringBuilder(this.name);
        if (this.getValueString() != null) {
            buf = buf.append("=");
            buf = buf.append("\"");
            buf = buf.append(this.getValueString());
            buf = buf.append("\"");
        } else if (xml) {
            buf = buf.append("=");
            buf = buf.append("\"");
            buf = buf.append(this.name);
            buf = buf.append("\"");
        }
        return buf.toString();
    }

    public String toString() {
        try {
            return this.toHtmlString(false);
        }
        catch (Exception e) {
            return e.toString();
        }
    }
}

