/*
 * Decompiled with CFR 0.152.
 */
package paraselene;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import paraselene.HTMLPart;
import paraselene.HTTPDate;
import paraselene.QueryItem;
import paraselene.URIValue;
import paraselene.supervisor.Forward;
import paraselene.supervisor.NullPage;
import paraselene.supervisor.PageFactory;
import paraselene.supervisor.PageID;
import paraselene.supervisor.RequestItem;
import paraselene.supervisor.RequestParameter;
import paraselene.supervisor.TransactionSequencer;
import paraselene.tag.Attribute;
import paraselene.tag.Tag;
import paraselene.tag.form.Button;
import paraselene.tag.form.Control;
import paraselene.tag.form.Form;

public abstract class Page
implements Serializable {
    private static final int ERROR_NO = 403;
    private HashMap<String, Tag> tag_1_dic = new HashMap();
    private HashMap<String, HashMap<String, Tag>> tag_m_dic = new HashMap();
    private HashMap<Tag, String> name_dic = new HashMap();
    private int name_seq = 0;
    private Tag contents = null;
    private boolean init_f = true;
    private boolean xml_f = false;
    private String doctype_def = null;
    private static final long serialVersionUID = 2L;
    private Control[] modified = new Control[0];
    private boolean beginning_called = false;

    public abstract AjaxSupport getAjaxSupport();

    public boolean isRuntime() {
        return true;
    }

    protected void addVersionMeta(String parser, String date) {
        if (!this.isRuntime()) {
            return;
        }
        Tag head = this.getFirstTagByType("head");
        if (head == null) {
            return;
        }
        StringBuilder buf = new StringBuilder(" Parser[");
        buf = buf.append(parser);
        buf = buf.append(",");
        buf = buf.append(date.toString());
        buf = buf.append("] Runtime[");
        buf = buf.append("2.0.1");
        buf = buf.append(",");
        buf = buf.append(new Date().toString());
        buf = buf.append("] ");
        Tag meta = new Tag("meta", false);
        meta.setAttribute(new Attribute("name", "generator"), new Attribute("content", buf.toString()));
        head.addHTMLPart((HTMLPart)meta);
    }

    protected synchronized void setDoctype(boolean xml, String doctype) {
        this.xml_f = xml;
        this.doctype_def = doctype;
    }

    public boolean isXML() {
        return this.xml_f;
    }

    public String getDoctype() {
        return this.doctype_def;
    }

    public synchronized void clear() {
        this.tag_1_dic = new HashMap();
        this.tag_m_dic = new HashMap();
        this.name_dic = new HashMap();
        this.name_seq = 0;
        this.contents = null;
    }

    public abstract void init();

    public void setInitialized(boolean flag) {
        this.init_f = flag;
    }

    public boolean isInitialized() {
        return this.init_f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getDefineNameIndex() {
        ArrayList<String> list = new ArrayList<String>();
        Page page = this;
        synchronized (page) {
            for (String k : this.tag_m_dic.keySet()) {
                list.add(k);
            }
        }
        return list.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getDefineName() {
        ArrayList<String> list = new ArrayList<String>();
        Page page = this;
        synchronized (page) {
            for (String k : this.tag_1_dic.keySet()) {
                list.add(k);
            }
        }
        return list.toArray(new String[0]);
    }

    private synchronized ArrayList<Form> getForm(Tag tag, ArrayList<Form> list) {
        Tag[] nest = tag.getTagArray();
        for (int i = 0; i < nest.length; ++i) {
            list = this.getForm(nest[i], list);
        }
        if (tag instanceof Form) {
            list.add((Form)tag);
        }
        return list;
    }

    public Control[] getModified() {
        return this.modified;
    }

    public synchronized void reflect(RequestParameter req) {
        this.modified = new Control[0];
        if (this.getMainTag() == null) {
            return;
        }
        ArrayList<Form> form = this.getForm(this.getMainTag(), new ArrayList<Form>());
        int form_cnt = form.size();
        String form_id = "paraselene_form_id";
        RequestItem item = req.getItem("paraselene$form");
        if (item != null) {
            form_id = item.getValue(0);
        }
        for (int i = form_cnt - 1; i >= 0; --i) {
            Form f = form.get(i);
            if (f.getID().equals(form_id)) continue;
            Control[] ctl = f.getAllControl();
            for (int j = 0; j < ctl.length; ++j) {
                if (!(ctl[j] instanceof Button)) continue;
                Button but = (Button)ctl[j];
                but.resetClicked();
            }
            form.remove(i);
        }
        ArrayList<Control> list = new ArrayList<Control>();
        form_cnt = form.size();
        for (int i = 0; i < form_cnt; ++i) {
            list.addAll(form.get(i).reflect(req));
        }
        this.modified = list.toArray(new Control[0]);
        if (this.modified.length > 0) {
            this.setInitialized(false);
        }
    }

    public synchronized Button getClickedButton() {
        ArrayList<Form> form = this.getForm(this.getMainTag(), new ArrayList<Form>());
        int size = form.size();
        for (int i = 0; i < size; ++i) {
            Control[] ctl = form.get(i).getAllControl();
            for (int j = 0; j < ctl.length; ++j) {
                Button btn;
                if (!(ctl[j] instanceof Button) || !(btn = (Button)ctl[j]).isClicked()) continue;
                return btn;
            }
        }
        return null;
    }

    public abstract String getContentType();

    public abstract String getCharset();

    public Attribute createURI(String name, String uri) throws PageException {
        try {
            return new Attribute(name, new URIValue(uri, this.getCharset()));
        }
        catch (Exception e) {
            throw new PageException((Throwable)e);
        }
    }

    public Attribute createPageToURI(String name, PageID pid, String fragment, QueryItem ... query) throws PageException {
        return this.createURI(name, URIValue.pageToURI(pid, fragment, query));
    }

    public Attribute createPageToDownloadURI(String name, PageID pid, String filename, QueryItem ... query) throws PageException {
        return this.createURI(name, URIValue.pageToDownloadURI(pid, filename, query));
    }

    public Attribute createAliasToURI(String name, PageID pid, String body, String fragment, QueryItem ... query) throws PageException {
        PageFactory factory = pid.getPageFactory();
        Page page = factory.getPage(pid);
        String alias = page.getAliasURI();
        factory.returnPage(page);
        if (alias == null) {
            throw new PageException(pid.toString() + " aliasURI is null.");
        }
        StringBuilder buf = new StringBuilder(alias);
        if (!".na".equals(alias.substring(alias.length() - 3))) {
            if (body == null) {
                throw new PageException("body is null.");
            }
            buf = buf.append(body);
            buf = buf.append(".na");
        }
        if (fragment != null) {
            buf = buf.append("#");
            buf = buf.append(fragment);
        }
        try {
            URIValue uv = new URIValue(buf.toString(), this.getCharset());
            if (query.length > 0) {
                uv.setQuery(query);
            }
            Attribute attr = new Attribute(name, uv);
            return attr;
        }
        catch (Exception e) {
            throw new PageException((Throwable)e);
        }
    }

    public String pickAliasURI(RequestParameter req) {
        String alias = this.getAliasURI();
        if (alias == null) {
            return null;
        }
        if (TransactionSequencer.EXTENSION.equals(alias.substring(alias.length() - 3))) {
            return null;
        }
        String uri = req.getURI().getPath();
        String[] path = uri.split("/");
        for (int i = 0; i < path.length; ++i) {
            if (path[i].length() < 4 || !TransactionSequencer.EXTENSION.equals(path[i].substring(path[i].length() - 3)) || alias.length() >= path[i].length() || !alias.equals(path[i].substring(0, alias.length()))) continue;
            return path[i].substring(alias.length(), path[i].length() - 3);
        }
        return null;
    }

    public synchronized Tag getTag(String name) {
        return this.tag_1_dic.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tag[] getAllTag(String name) {
        String[] pre = name.split("\\$");
        ArrayList<Tag> list = new ArrayList<Tag>();
        Page page = this;
        synchronized (page) {
            HashMap<String, Tag> map = this.tag_m_dic.get(pre[0]);
            if (map == null) {
                return null;
            }
            for (String k : map.keySet()) {
                list.add(map.get(k));
            }
        }
        return list.toArray(new Tag[0]);
    }

    public abstract PageID getID();

    public int hashCode() {
        PageID id = this.getID();
        return id != null ? id.getID() : Integer.MIN_VALUE;
    }

    public String getUniKey() {
        return Integer.toString(super.hashCode());
    }

    public boolean equals(Object p) {
        if (this instanceof NullPage || p instanceof NullPage) {
            return false;
        }
        if (p instanceof PageID) {
            return this.getID() == p;
        }
        if (p instanceof Page) {
            return this.hashCode() == p.hashCode();
        }
        return false;
    }

    public static String getIndexName(String name) {
        if (name == null) {
            return null;
        }
        String[] idx = name.split("\\$");
        return idx[0];
    }

    private synchronized void clearDic(String name) {
        Tag tag = this.tag_1_dic.remove(name);
        this.name_dic.remove(tag);
        String index = Page.getIndexName(name);
        HashMap<String, Tag> map = this.tag_m_dic.get(index);
        if (map == null) {
            return;
        }
        map.remove(name);
        if (map.size() == 0) {
            this.tag_m_dic.remove(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String extendName(Tag tag) {
        String org_name = tag.getNameAttribute();
        String index = Page.getIndexName(org_name);
        Page page = this;
        synchronized (page) {
            while (this.tag_1_dic.get(org_name = String.format("%s$%d", index, this.name_seq)) != null) {
                ++this.name_seq;
            }
        }
        return org_name;
    }

    private synchronized void nameTagSingle(Tag tag) {
        if (tag == null) {
            return;
        }
        String old_name = this.name_dic.get(tag);
        String new_name = tag.getNameAttribute();
        if (old_name == null && new_name == null) {
            return;
        }
        if (old_name != null && new_name == null) {
            this.clearDic(old_name);
            return;
        }
        if (old_name != null && new_name != null) {
            if (old_name.equals(new_name)) {
                return;
            }
            this.clearDic(old_name);
        }
        if (this.tag_1_dic.get(new_name) != null) {
            new_name = this.extendName(tag);
            try {
                tag.setAttribute(new Attribute("name", new_name));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.tag_1_dic.put(new_name, tag);
        this.name_dic.put(tag, new_name);
        String index = Page.getIndexName(new_name);
        HashMap<String, Tag> map = this.tag_m_dic.get(index);
        if (map == null) {
            map = new HashMap();
            this.tag_m_dic.put(index, map);
        }
        map.put(new_name, tag);
    }

    public synchronized void nameTag(Tag tag) {
        tag.setPage(this);
        String name = tag.getNameAttribute();
        if (name != null && "paraselene$form".equals(name)) {
            return;
        }
        this.nameTagSingle(tag);
        int cnt = tag.getHTMLPartCount();
        for (int i = 0; i < cnt; ++i) {
            HTMLPart part = tag.getHTMLPart(i);
            if (part instanceof Tag) {
                this.nameTag((Tag)part);
                continue;
            }
            part.setPage(this);
        }
        ArrayList<Form> form = this.getForm(this.getMainTag(), new ArrayList<Form>());
        cnt = form.size();
        for (int i = 0; i < cnt; ++i) {
            Form f = form.get(i);
            if (!f.isInner(tag)) continue;
            f.checkTag(tag);
        }
    }

    public synchronized void removeNameEntry(Tag tag) {
        int i;
        ArrayList<Form> form = this.getForm(this.getMainTag(), new ArrayList<Form>());
        int cnt = form.size();
        for (i = 0; i < cnt; ++i) {
            Form f = form.get(i);
            if (!f.isInner(tag)) continue;
            f.checkTag4rm(tag);
        }
        cnt = tag.getHTMLPartCount();
        for (i = 0; i < cnt; ++i) {
            HTMLPart part = tag.getHTMLPart(i);
            if (part instanceof Tag) {
                this.removeNameEntry((Tag)part);
                continue;
            }
            part.setPage(null);
        }
        String name = tag.getNameAttribute();
        if (name == null) {
            return;
        }
        this.clearDic(name);
        tag.setPage(null);
    }

    public synchronized void setMainTag(Tag tag) {
        this.contents = tag;
        this.nameTag(tag);
    }

    public Tag getMainTag() {
        return this.contents;
    }

    public Tag getFirstTagByType(String name) {
        Tag tag = this.getMainTag();
        if (tag == null) {
            return null;
        }
        return tag.getFirstTagByType(name);
    }

    public Tag[] getAllTagByType(String name) {
        Tag tag = this.getMainTag();
        if (tag == null) {
            return null;
        }
        return tag.getAllTagByType(name);
    }

    public synchronized void replaceTag(Tag from, Tag to, boolean copy_f) {
        Tag tag = this.getMainTag().getDirectInnerTag(from);
        int idx = tag.indexOf(from);
        tag.removeHTMLPart(from);
        if (copy_f) {
            to.setVisible(from.isVisible());
            Attribute[] attr = from.getAllAttribute();
            for (int i = 0; i < attr.length; ++i) {
                to.setAttribute(attr[i].getReplica());
            }
            int cnt = from.getHTMLPartCount();
            for (int i = 0; i < cnt; ++i) {
                to.addHTMLPart(from.getHTMLPart(i).getReplica());
            }
        }
        tag.addHTMLPart(idx, (HTMLPart)to);
    }

    public String toString() {
        String doc;
        StringBuilder buf = new StringBuilder();
        if (this.isXML()) {
            buf = buf.append("<?xml version=\"1.0\" encoding=\"");
            buf = buf.append(this.getCharset());
            buf = buf.append("\"?>");
        }
        if ((doc = this.getDoctype()) != null) {
            buf = buf.append(doc);
        }
        if (this.contents != null) {
            buf = buf.append(this.contents.toString());
        }
        return buf.toString();
    }

    public void write(PrintWriter w) throws UnsupportedEncodingException, URISyntaxException {
        String doc;
        if (this.isXML()) {
            w.print("<?xml version=\"1.0\" encoding=\"");
            w.print(this.getCharset());
            w.println("\"?>");
        }
        if ((doc = this.getDoctype()) != null) {
            w.println(doc);
        }
        if (this.contents != null) {
            this.contents.write(w, HTMLPart.StringMode.BODY);
        }
    }

    public HTTPDate getLastModified() {
        return null;
    }

    public boolean isGZIP() {
        return false;
    }

    public abstract boolean isHistoryClear();

    public abstract boolean isAllowHistoryAdd();

    public abstract Forward input(RequestParameter var1, Forward var2) throws PageException;

    public abstract Page output(Page var1, RequestParameter var2) throws PageException;

    public abstract String getAliasURI();

    public abstract int getUploadMaxBytes();

    public abstract boolean isCheckRepeatSameRequest();

    public abstract void firstOutput(RequestParameter var1) throws PageException;

    public void beginning(RequestParameter req) throws PageException {
        if (!this.beginning_called) {
            return;
        }
        this.beginning_called = true;
        this.firstOutput(req);
    }

    public static enum AjaxSupport {
        NO,
        POPUP_DIALOG,
        SERVER_PUSH;

        private static final long serialVersionUID = 2L;
    }

    public class PageException
    extends Exception {
        private Throwable ex;
        private Object obj;

        public PageException(Throwable e) {
            super(e);
            this.ex = null;
            this.obj = null;
            while (e instanceof PageException) {
                e = ((PageException)e).ex;
            }
            this.ex = e;
        }

        public PageException(String mes) {
            super(mes);
            this.ex = null;
            this.obj = null;
            this.ex = null;
        }

        public PageException(Throwable e, Object with) {
            this(e);
            this.obj = with;
        }

        public PageException(String mes, Object with) {
            this(mes);
            this.obj = with;
        }

        public Throwable get() {
            if (this.ex == null) {
                return this;
            }
            if (this.ex instanceof PageException) {
                PageException pe = (PageException)this.ex;
                return pe.get();
            }
            return this.ex;
        }

        public Object getWithObject() {
            return this.obj;
        }
    }
}

