/*
 * Paraselene
 * Copyright (c) 2009  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.mockup;


import java.util.*;
import java.net.*;
import java.io.*;
import java.nio.charset.*;
import paraselene.*;
import paraselene.dyna.*;
import paraselene.dyna.mockup.*;


enum LineSeparator {
	CR( "cr", "\r" ),
	LF( "lf", "\n" ),
	CRLF( "crlf", "\r\n" ),
	LFCR( "lfcr", "\n\r" );

	private static LineSeparator	use;
	private String name;
	private String code;
	private LineSeparator( String n, String c ) {
		name = n;
		code = c;
	}
	static String getOSName() {
		LineSeparator[]	ls = values();
		for ( int i = 0; i < ls.length; i++ ) {
			if ( ls[i].code.equals( System.getProperty("line.separator") ) ) {
				return ls[i].name;
			}
		}
		return CRLF.name;
	}

	static boolean setUse( String name ) {
		LineSeparator[]	ls = values();
		for ( int i = 0; i < ls.length; i++ ) {
			if ( ls[i].name.equals( name ) ) {
				use = ls[i];
				return true;
			}
		}
		return false;
	}

	static String getUse() {
		if ( use == null )	return System.getProperty("line.separator");
		return use.code;
	}
}

class HtmlExt {
	private static String[]	ext = new String[] {
		"htm", "html", "xht", "xhtml"
	};

	static String[] getParam() {
		String[]	ret = new String[ext.length];
		for ( int i = 0; i < ret.length; i++ ) {
			ret[i] = "*." + ext[i];
		}
		return ret;
	}

	static boolean isHtml( String e ) {
		for ( int i = 0; i < ext.length; i++ ) {
			if ( ext[i].equalsIgnoreCase( e ) )	return true;
		}
		return false;
	}
}

public enum Param {
	HTML_ROOT( "-html",
		"読み込むhtmlの配置ディレクトリ。その直下より再帰読み込みします。",
		true, true ),
	NEKO( "-neko",
		"true を指定すると、HTMLのパースにCyberNeko HTML Parserを使用します。\n" +
		"falseを指定すると、Java標準付属のパーサーを使用します。",
		false, true, "false" ),
	OUT_PATH( "-out",
		"出力ディレクトリ。スケルトンソースファイルや定義ファイルの出力先です。\n" +
		"出力ディレクトリが無ければ作成します。\n" +
		"入力htmlと出力ファイルはタイムスタンプを比較し、必要な物のみ出力します。",
		true, true  ),
	OUT_SOURCE_PATH( "-out_source",
		OUT_PATH.key + "で指定したディレクトリの中に作成する\n" +
		"ソースファイル出力ディレクトリ名を指定します。",
		false, true, "src" ),
	PACKAGE( "-package",
		"ソースファイルのルートパッケージ名。\n" +
		"パッケージはルートパッケージ名を起点に階層化されます。",
		true, true  ),
	OTHER( "-other",
		"画像などの静的コンテンツのルートパス。\n" +
		HTML_ROOT.key + " とこのパスが一致しているとみなし、\n" +
		"IMGタグ等に登場する相対パスを置換します。\n" +
		"静的コンテンツもアプリケーションサーバーに収納するならば、\n" +
		"Contextのpathと一致させて下さい。",
		false, true, "/" ),
	CLASS_PATH( "-class_path",
		"GrantTagProvider 実装クラスや URIPreProcess 実装クラスを探すクラスパスです。\n" +
		"クラスのあるディレクトリパスやjarファイルのファイルパスになります。\n" +
		"java コマンドと違い、指定ディレクトリを起点に可能性のあるファイルが\n" +
		"あれば、ターゲットとなるクラスであるか、内容を検証します。\n" +
		"ディレクトリを再帰検索し、何らかのjarファイルを見つければその内容も\n" +
		"確認します。",
		false, false ),
	URI_PP( "-uri_preprocess",
		"URI事前検証クラスを登録します。\n" +
		"paraselene.dyna.mockup.URIPreProcess を実装したクラス名を指定して下さい。\n" +
		"このクラスにクラスパスが通されている必要があります。",
		false, true ),
	CLEAR( "-clear",
		"true を指定すると、既にある出力ファイルを消去して再作成します。\n" +
		"ただし、既に存在するスケルトンソースは消去しませんし、上書きもしません。",
		false, true, "false" ),
	NO_CLEAR_DIR( "-no_clear_dir",
		CLEAR.key + " 指定された場合でも、ここで指定した\n" +
		"ディレクトリ下のファイルは保護し、削除対象としません。\n" +
		"*?を使ったワイルドカード指定が可能です。\n" +
		"ディレクトリ階層に関係なく、ディレクトリ名がマッチすると保護します。\n" +
		"指定例) .svn   Subversionの管理ファイルを削除しない\n",
		false, false ),
	DTD( "-dtd",
		"DTDキャッシュディレクトリ。\n" +
		"ディレクトリを指定すると、その場所にダウンロードしたDTDを保存します。\n" +
		"次回起動時に、指定ディレクトリに目的のDTDがあればリモートアクセスせずに\n" +
		"それを使用します。\n" +
		"ただし、HTMLファイルに対しては、このオプションは無視されます。",
		false, true, System.getProperty( "java.io.tmpdir" ) ),
	USER_AGENT( "-agent",
		"DTDを取得する際のHTTPアクセスで使用するUser-Agent。", false, true,
		"Mozilla/5.0 (compatible; " + System.getProperty( "os.name" ) + "; " +
		System.getProperty( "user.language" ) + "-" +
		System.getProperty( "user.country" ) + ") Paraselene " + Version.VERSION ),
	IN_ENCODE( "-html_encode",
		"HTMLファイルの文字コード。\n" +
		"HTMLファイルは予め、この文字コードで統一しておいて下さい。\n" +
		"ただし、XHTMLファイルに対しては、このオプションは無視されます。" ,
		false, true, "UTF-8" ),
	OUT_ENCODE( "-output_encode",
		"実行時の文字コード。\n" +
		"実行時、ブラウザにはこの文字コードで出力されます。",
		false, true, "UTF-8" ),
	SOURCE_ENCODE( "-source_encode",
		"生成するスケルトンソースファイルの出力文字コード。",
		false, true, Charset.defaultCharset().name() ),
	SOURCE_LINE( "-source_line",
		"生成するスケルトンソースファイルの改行コード。\n" +
		"cr,lf,crlf,lfcrの何れかを指定可能です。\n" +
		"Windows crlf\n" + "UNIX/Linux lf\n" + "MAC OS cr,lfcr",
		false, true, LineSeparator.getOSName() ),
	SOURCE_HEAD( "-source_head",
		"生成するスケルトンソースファイルの先頭に付けるコメントを書いたファイル。\n" +
		"/* から */ で囲まれた文章、または // で始まる文章を記載したテキストファイル。\n" +
		"このテキストファイルにコピーライト等をヘッダとして付ける事ができます。\n" +
		"このテキストファイルの文字コード及び改行コードは実行環境のそれと同じもの\n" +
		"であると仮定して読み込みます。\n" +
		"出力文字コードは、" + SOURCE_ENCODE.key + " の指定に従い、\n" +
		"出力改行コードは、" + SOURCE_LINE.key + " の指定に従います。",
		false, true ),
	PARAM_URI( "-uri_param_name",
		"<PARAM>タグでURIを示すname(大文字小文字を同一視します)を指定します。\n" +
		"指定されたname属性値が一致した場合、対応するvalue属性値を\n" +
		"URIとして解決しようとします。",
		false, false ),
	TAG_PROVIDER( "-grant_tag_provider",
		"タグの独自派生クラスを登録します。\n" +
		"paraselene.dyna.GrantTagProvider を実装したクラス名を指定して下さい。\n" +
		"このクラスにクラスパスが通されている必要があります。",
		false, false ),
	JSON( "-json",
		"Paraselene が提供する Json クラス(非同期通信クラス)を使用する場合\n" +
		"true を指定して下さい。使用しない場合は false を指定して下さい。",
		false, true, "false" ),
	INCLUDE( "-include",
		"ソースファイル化するファイル。*?を使ったワイルドカード指定が可能です。",
		false, false, HtmlExt.getParam() ),
	EXCLUDE( "-exclude",
		"ソースファイル化しないファイル。*?を使ったワイルドカード指定が可能です。\n" +
		INCLUDE.key + " 指定より優先されます。\n" +
		"静的コンテンツ扱いになるので " + OTHER.key + " の対象となります。",
		false, false  ),
	IGNORE( "-ignore_dir",
		"指定したディレクトリ下のファイルを全て無視します。\n" +
		"HTMLファイルであってもスケルトンソースを生成しませんし、\n" +
		"excludeディレクトリにも格納されず、完全に無視します。\n" +
		"*?を使ったワイルドカード指定が可能です。\n" +
		"ディレクトリ階層に関係なく、ディレクトリ名がマッチすると無視します。\n" +
		"指定例) .svn   Subversionの管理ファイルを無視\n" +
		"        _notes Dreamweaverの管理ファイルを無視",
		false, false );

	String	key, info;
	boolean req_f, one_f;
	ArrayList<String>	data = new ArrayList<String>();
	static GrantTagProvider[]	provider = null;
	static URIPreProcess	uri_pp = null;

	public String get() {
		return getData( 0 );
	}

	public int getDataCount() {
		return data.size();
	}
	public String getData( int no ) {
		if ( data.size() == 0 )	return null;
		return data.get( no );
	}
	public String getHelp() {
		return key + " " + (req_f? "(必須)": "") + "\n" + info;
	}
	public String getKey() {
		return key;
	}

	public void clear() {
		data.clear();
	}

	public void add( String str ) {
		data.add( str );
	}

	private Param( String k, String in, boolean r, boolean o, String ... d ) {
		key = k;
		info = in;
		req_f = r;
		one_f = o;
		if ( data != null ) {
			for ( int i = 0; i < d.length; i++ ) {
				data.add( d[i] );
			}
		}
	}

	private static Param getParam( String k ) {
		Param[]	param = values();
		for ( int i = 0; i < param.length; i++ ) {
			if ( param[i].key.equals( k ) )	return param[i];
		}
		return null;
	}

	static void setParam( String[] input ) {
		if ( input.length == 0 )	help();

		Param	crt = null;
		for ( int i = 0; i < input.length; i++ ) {
			if ( input[i].charAt( 0 ) == '-' ) {
				crt = getParam( input[i] );
				if ( crt == null ) {
					System.err.println( "未知のパラメータです " + input[i] );
					System.exit( 1 );
				}
				continue;
			}
			if ( crt == null )	continue;
			if ( input[i].isEmpty() )	continue;
			if ( crt.one_f ) {
				crt.data = new ArrayList<String>();
			}
			crt.data.add( input[i] );
		}

		Param[] param = values();
		boolean	exit_f = false;
		for ( int i = 0; i < param.length; i++ ) {
			if ( param[i].req_f ) {
				if ( param[i].data.size() == 0 ) {
					System.err.println( param[i].key + " を指定して下さい" );
					exit_f = true;
				}
			}
		}
		if ( exit_f ) {
			System.exit( 1 );
		}
		Make.SRC_PATH = OUT_SOURCE_PATH.get();
		String[]	pkg = PACKAGE.get().split( "\\." );
		for ( int i = 0; i < pkg.length; i++ ) {
			if ( JavaDefine.isDefine( pkg[i], true ) ) {
				System.err.println( PACKAGE.key + " に使用できない文字が含まれています" );
				System.exit( 1 );
			}
		}
		if ( !LineSeparator.setUse( SOURCE_LINE.get() ) ) {
			System.err.println( SOURCE_LINE.key + " の指定が不正です" );
			System.exit( 1 );
		}
		try {
			URLEncoder.encode( "XXX", IN_ENCODE.get() );
		}
		catch(Exception e) {
			System.err.println( IN_ENCODE.key + " の指定が不正です" );
			System.exit( 1 );
		}
		try {
			URLEncoder.encode( "XXX", OUT_ENCODE.get() );
		}
		catch(Exception e) {
			System.err.println( OUT_ENCODE.key + " の指定が不正です" );
			System.exit( 1 );
		}
		try {
			Boolean.valueOf( CLEAR.get() );
		}
		catch(Exception e) {
			System.err.println( CLEAR.key + " の指定が不正です" );
			System.exit( 1 );
		}
		try {
			Boolean.valueOf( NEKO.get() );
		}
		catch(Exception e) {
			System.err.println( NEKO.key + " の指定が不正です" );
			System.exit( 1 );
		}
		try {
			Boolean.valueOf( JSON.get() );
		}
		catch(Exception e) {
			System.err.println( JSON.key + " の指定が不正です" );
			System.exit( 1 );
		}
		try {
			String	f = SOURCE_HEAD.get();
			if ( f != null ) {
				SourceHead.init( new File( f ) );
			}
		}
		catch(Exception e) {
			System.out.println( SOURCE_HEAD.key + " の読み込みに失敗しました。" );
			System.exit( 1 );
		}
		try {
			String	name = URI_PP.get();
			if ( name != null ) {
				Loader	loader = new Loader();
				uri_pp = (URIPreProcess)loader.loadClass( name ).getConstructor().newInstance();
				Linker.readme.echoln( "Loaded URIPreProcess " + name );
			}
		}
		catch( Exception e ) {
			System.err.println( e.toString() );
			System.err.println( URI_PP.key + " の初期化に失敗しました。" );
			System.exit( 1 );
		}
		try {
			int	cnt = TAG_PROVIDER.getDataCount();
			provider = new GrantTagProvider[cnt];
			Loader	loader = new Loader();
			for ( int i = 0; i < cnt; i++ ) {
				String	name = TAG_PROVIDER.getData( i );
				provider[i] = (GrantTagProvider)loader.loadClass( name ).getConstructor().newInstance();
				Linker.readme.echoln( "Loaded GrantTagProvider " + name );
			}
		}
		catch( Exception e ) {
			System.err.println( e.toString() );
			System.err.println( TAG_PROVIDER.key + " の初期化に失敗しました。" );
			System.exit( 1 );
		}
		for ( int i = 0; i < param.length; i++ ) {
			Linker.readme.echo( param[i].key );
			int	cnt = param[i].data.size();
			for ( int j = 0; j < cnt; j++ ) {
				Linker.readme.echo( j == 0?	": ":	", " );
				Linker.readme.echo( param[i].data.get( j ) );
			}
			Linker.readme.echo( "\n" );
		}
		Linker.readme.echo( "\n\n" );
	}

	private String getInfo() {
		String[]	str = info.split( "\n" );
		StringBuffer	buf = new StringBuffer();
		for ( int i = 0; i < str.length; i++ ) {
			buf = buf.append( "    " );
			buf = buf.append( str[i] );
			buf = buf.append( "\n" );
		}
		return buf.toString();
	}

	private static void help() {
		Param[]	param = values();
		Linker.readme.echoln( "以下のオプションがあります。\n" +
			"複数指定可のオプションは、指定したパラメータ全てが追加されていきます。\n" +
			"複数指定できないオプションは、最後に指定したもの１つが有効になります。\n"
		);
		for ( int i = 0; i < param.length; i++ ) {
			Linker.readme.echoln( param[i].key + "  " + (param[i].req_f?	"(必須)":	"") +
				(param[i].one_f?	"":	"(複数指定化)" ) );
			Linker.readme.echo( param[i].getInfo() );
			int	cnt = param[i].data.size();
			if ( cnt > 0 ) {
				Linker.readme.echo( "  (デフォルト設定値):" );
				for ( int o = 0; o < cnt; o++ ) {
					if ( o > 0 )	Linker.readme.echo( "," );
					Linker.readme.echo( "\"" + param[i].data.get( o ) + "\"" );
				}
				Linker.readme.echoln( "" );
			}
			Linker.readme.echoln( "" );
		}
		System.exit( 0 );
	}

	static boolean isHit( String filename, String syntax ) {
		char[]	syn = syntax.toCharArray();
		char[]	file = filename.toCharArray();
		int	syn_idx = 0, file_idx = 0;

		while( true ) {
			if ( syn_idx >= syn.length )	break;
			if ( file_idx >= file.length )	break;
			if ( syn[syn_idx] == '*' ) {
				for ( ; syn_idx < syn.length; syn_idx++ ) {
					if ( syn[syn_idx] != '*' && syn[syn_idx] != '?' )	break;
				}
				if ( syn_idx == syn.length ) {
					file_idx = file.length;
					break;
				}
				for ( ; file_idx < file.length; file_idx++ ) {
					if ( syn[syn_idx] == file[file_idx] )	break;
				}
				syn_idx++;
				file_idx++;
				continue;
			}
			if ( syn[syn_idx] == '?' );
			else	if ( syn[syn_idx] != file[file_idx] )	break;
			syn_idx++;
			file_idx++;
		}
		return syn_idx == syn.length && file_idx == file.length;
	}

	static boolean isHit( String filename ) {
		int	ex_cnt = EXCLUDE.data.size();
		for ( int i = 0; i < ex_cnt; i++ ) {
			if ( isHit( filename, EXCLUDE.data.get( i ) ) )	return false;
		}
		int	in_cnt = INCLUDE.data.size();
		for ( int i = 0; i < in_cnt; i++ ) {
			if ( isHit( filename, INCLUDE.data.get( i ) ) )	return true;
		}
		return false;
	}

	static boolean isIgnore( String dir ) {
		int ex_cnt = IGNORE.data.size();
		for ( int i = 0; i < ex_cnt; i++ ) {
			if ( isHit( dir, IGNORE.data.get( i ) ) )	return true;
		}
		return false;
	}

	static boolean isNoClear( String dir ) {
		int ex_cnt = NO_CLEAR_DIR.data.size();
		for ( int i = 0; i < ex_cnt; i++ ) {
			if ( isHit( dir, NO_CLEAR_DIR.data.get( i ) ) )	return true;
		}
		return false;
	}
}

