/*
 * Paraselene
 * Copyright (c) 2009  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene;

import java.net.*;
import java.io.*;

/**
 * 色を示す文字列。
 */
public class Color extends Text {
	private static final long serialVersionUID = 1L;
	private int red, green, blue;

	/**
	 * 複製の作成。
	 * @return 複製。
	 */
	public HTMLPart getReplica() {
		return new Color( red, green, blue );
	}

	/**
	 * コンストラクタ。
	 * @param s 文字列。
	 */
	public Color( String s ) {
		setColor( s );
	}

	/**
	 * 色の設定。
	 * @param s 文字列。
	 */
	public void setColor( String s ) {
		if ( s == null ) {
			setText( s );
			return;
		}
		s = s.trim();
		if ( s.isEmpty() ) {
			setText( s );
			return;
		}
		if ( s.charAt( 0 ) != '#' ) {
			setColor( WebColor.valueOf( s.toUpperCase() ) );
			return;
		}
		char[]	org = s.toCharArray();
		char[]	ch = new char[7];
		int	org_len = org.length - 1;
		int	ch_len = ch.length - 1;
		for ( ; org_len >= 1 && ch_len >= 1; org_len--, ch_len-- ) ch[ch_len] = org[org_len];
		for ( ; ch_len >= 1; ch_len-- )	ch[ch_len] = '0';
		setColor( Integer.parseInt( new String( ch, 1, 2 ), 16 ),
			Integer.parseInt( new String( ch, 3, 2 ), 16 ),
			Integer.parseInt( new String( ch, 5, 2 ), 16 ) );
	}

	/**
	 * コンストラクタ。
	 * @param wc 規定色。
	 */
	public Color( WebColor wc ) {
		setColor( wc );
	}

	/**
	 * 色の設定。
	 * @param wc 規定色。
	 */
	public void setColor( WebColor wc ) {
		setColor( wc.red, wc.green, wc.blue );
	}

	/**
	 * コンストラクタ。全てのパラメータは下位１バイトのみ取り出して使用する。
	 * @param r 赤(0x00 ～ 0xff)。
	 * @param g 緑(0x00 ～ 0xff)。
	 * @param b 青(0x00 ～ 0xff)。
	 */
	public Color( int r, int g, int b ) {
		setColor( r, g, b );
	}

	/**
	 * 色の設定。全てのパラメータは下位１バイトのみ取り出して使用する。
	 * @param r 赤(0x00 ～ 0xff)。
	 * @param g 緑(0x00 ～ 0xff)。
	 * @param b 青(0x00 ～ 0xff)。
	 */
	public void setColor( int r, int g, int b ) {
		red = r & 0xff;
		green = g & 0xff;
		blue = b & 0xff;
		setText( String.format( "#%06X", (red << (8*2)) | (green << 8) | blue ) );
	}

	/**
	 * 赤の取得。
	 * @return 赤。
	 */
	public int getRed() {
		return red;
	}

	/**
	 * 緑の取得。
	 * @return 緑。
	 */
	public int getGreen() {
		return green;
	}

	/**
	 * 青の取得。
	 * @return 青。
	 */
	public int getBlue() {
		return blue;
	}
}


