/*
 * Decompiled with CFR 0.152.
 */
package paraselene.mockup;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import paraselene.Comment;
import paraselene.Page;
import paraselene.Text;
import paraselene.dyna.DynamicPage;
import paraselene.dyna.DynamicPageException;
import paraselene.mockup.CommentSource;
import paraselene.mockup.Download;
import paraselene.mockup.JavaDefine;
import paraselene.mockup.Linker;
import paraselene.mockup.Make;
import paraselene.mockup.Output;
import paraselene.mockup.OutputNo;
import paraselene.mockup.Param;
import paraselene.mockup.SourceHead;
import paraselene.mockup.TagException;
import paraselene.mockup.TagMap;
import paraselene.mockup.TagSource;
import paraselene.mockup.TextSource;
import paraselene.mockup.output.source.logic.logic;
import paraselene.mockup.output.source.view.readme;
import paraselene.mockup.output.source.view.view;
import paraselene.supervisor.PageFactory;
import paraselene.supervisor.PageID;
import paraselene.tag.Tag;
import paraselene.tag.attr.Attribute;

public class PrePage
extends DynamicPage
implements OutputNo {
    static final String[] out_dir = new String[]{"view", "logic"};
    private HashMap<String, Integer> method = new HashMap();
    private static HashMap<Integer, PrePage> hash_map = new HashMap();
    private int id = 0;
    private String path = "";
    private String package_name;
    private String java_path;
    private String class_name;
    private String enum_name;
    private long html_last_time = 0L;
    private HashMap<String, String> name_class = new HashMap();
    private HashMap<String, ArrayList<String>> group_name = new HashMap();
    private ArrayList<String> note = new ArrayList();
    private static final String NULL_TITLE = "(\u30bf\u30a4\u30c8\u30eb\u306a\u3057)";
    private static final String SKIP_TITLE = "(\u89e3\u6790skip) ";
    private static HashMap<String, String> name_check = new HashMap();

    private String toName(String name) {
        char[] ch = name.toCharArray();
        ch[0] = Character.toUpperCase(ch[0]);
        for (int i = 1; i < ch.length; ++i) {
            ch[i] = Character.toLowerCase(ch[i]);
        }
        return new String(ch);
    }

    private StringBuffer toName(String tag, String name) {
        StringBuffer buf = new StringBuffer(" get");
        String[] part = name.split("[\\p{Punct}\\p{Space}]+");
        for (int i = 0; i < part.length; ++i) {
            buf = part[i].length() == 0 ? buf.append("_") : buf.append(this.toName(part[i]));
        }
        name = (buf = buf.append(this.toName(tag))).toString();
        Integer cnt = this.method.get(name);
        if (cnt == null) {
            this.method.put(name, 1);
        } else {
            Integer n = cnt;
            Integer n2 = cnt = Integer.valueOf(cnt + 1);
            buf = buf.append(cnt);
            this.addNote("\u8b66\u544a: " + name + " \u306b\u985e\u4f3c\u3059\u308b\u30e1\u30bd\u30c3\u30c9\u3092\u4f5c\u6210\u3057\u307e\u3057\u305f\u3002");
        }
        return buf.append("() {\n");
    }

    private StringBuffer getCom(String name, TagSource t) {
        StringBuffer buf = new StringBuffer("/**\n");
        buf = buf.append(" * ");
        buf = buf.append(name);
        buf = buf.append(".");
        if (t != null) {
            buf = buf.append("\n");
            buf = buf.append(" * <br>");
            buf = buf.append(t.getTagString());
        }
        return buf.append("\n **/\npublic ");
    }

    private StringBuffer getMethod(String name, Tag t) throws TagException {
        StringBuffer buf = this.getCom(name, (TagSource)t);
        String cls = TagMap.getClassString(t);
        buf = buf.append(cls);
        buf = buf.append(this.toName(t.getName(), name));
        buf = buf.append("return (");
        buf = buf.append(cls);
        buf = buf.append(")getTag( \"");
        buf = buf.append(name);
        return buf.append("\" );\n}\n");
    }

    private StringBuffer getMethod(String name) throws TagException {
        Tag[] t = this.getAllTag(name);
        StringBuffer buf = new StringBuffer();
        if (t.length == 1) {
            buf = buf.append(this.getMethod(name, t[0]));
        } else {
            this.addNote("name=" + name + "\u306e\u30bf\u30b0\u306f\u914d\u5217\u5316\u3055\u308c\u307e\u3057\u305f\u3002");
        }
        buf = buf.append(this.getCom(name, null));
        buf = buf.append("paraselene.tag.Tag");
        buf = buf.append("[]");
        buf = buf.append(this.toName("Tags", name));
        buf = buf.append("return getAllTag( \"");
        buf = buf.append(name);
        return buf.append("\" );\n}\n");
    }

    @Override
    public String getString(int no) {
        switch (no) {
            case 1: {
                return Param.PACKAGE.get();
            }
            case 2: {
                return this.package_name;
            }
            case 3: {
                return this.path;
            }
            case 4: {
                return this.class_name;
            }
            case 5: {
                TagSource tag = (TagSource)this.getMainTag();
                StringBuffer buf = new StringBuffer(tag.toSource());
                buf = buf.append("setMainTag(");
                buf = buf.append(tag.getValName());
                buf = buf.append(");\n");
                buf = buf.append("setDoctype(");
                buf = buf.append(Boolean.toString(this.isXML()));
                buf = buf.append(",");
                buf = buf.append(Make.escape(this.getDoctype()));
                buf = buf.append(");");
                return buf.toString();
            }
            case 6: {
                return this.getEnumName(true);
            }
            case 7: {
                StringBuffer buf = new StringBuffer();
                String[] name = this.getDefineNameIndex();
                for (int i = 0; i < name.length; ++i) {
                    try {
                        buf = buf.append(this.getMethod(name[i]));
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                return buf.toString();
            }
        }
        return null;
    }

    String getClassName() {
        StringBuffer buf = new StringBuffer(Param.PACKAGE.get());
        buf = buf.append(".");
        buf = buf.append(out_dir[1]);
        if (this.package_name.length() > 0) {
            buf = buf.append(this.package_name);
        }
        buf = buf.append(".");
        buf = buf.append(this.class_name);
        return buf.toString();
    }

    String getEnumName(boolean only_f) {
        if (only_f) {
            return this.enum_name;
        }
        StringBuffer buf = new StringBuffer(Param.PACKAGE.get());
        buf = buf.append(".base.PageType.");
        buf = buf.append(this.enum_name);
        return buf.toString();
    }

    void makeSourceMain(int dir, Output output) throws Exception {
        Linker.readme.setCurrentPage(this);
        StringBuffer out_path = new StringBuffer(Make.SRC_PATH);
        out_path = out_path.append(File.separator);
        out_path = out_path.append(out_dir[dir]);
        out_path = out_path.append(File.separator);
        out_path = out_path.append(this.java_path);
        String name = out_path.toString();
        File file = new File(name);
        Linker.readme.echoln(name + " output starts.");
        if (dir == 1 && file.exists()) {
            Linker.readme.echoln(name + " was not output, because it already existed.");
            return;
        }
        Output.Status stat = output.write(file, this, this.html_last_time);
        switch (stat) {
            case OK: {
                Linker.readme.echoln(name + " output ended.");
                break;
            }
            case SKIP: {
                Linker.readme.echoln(name + " is not modified.");
            }
        }
    }

    void makeSource() throws Exception {
        Output[] output = new Output[]{new view(), new logic()};
        for (int i = 0; i < 2; ++i) {
            this.makeSourceMain(i, output[i]);
        }
    }

    void addNote(String n) {
        this.note.add(n);
    }

    String getNote() {
        StringBuffer buf = new StringBuffer();
        int cnt = this.note.size();
        for (int i = 0; i < cnt; ++i) {
            buf = buf.append(this.note.get(i));
            if (i == cnt - 1) continue;
            buf = buf.append("\n");
        }
        return buf.toString();
    }

    String getTitle() {
        Tag[] tag = this.getAllTagByType("title");
        if (tag == null) {
            return SKIP_TITLE;
        }
        if (tag.length == 0) {
            return NULL_TITLE;
        }
        String str = tag[0].getValueString();
        if (str == null) {
            return NULL_TITLE;
        }
        if (str.length() == 0) {
            return NULL_TITLE;
        }
        return str;
    }

    @Override
    public void init() {
        PrePage page;
        int i;
        int i2;
        this.path = this.path.substring(Param.HTML_ROOT.get().length());
        if (this.path.charAt(0) == File.separatorChar) {
            this.path = this.path.substring(1);
        }
        String[] check = this.path.split("[/\\\\]");
        for (int i3 = 0; i3 < check.length; ++i3) {
            boolean ret = i3 == check.length - 1 ? JavaDefine.isDefine(check[i3], false) : JavaDefine.isDefine(check[i3], true);
            if (!ret) continue;
            System.err.println("\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u540d\u307e\u305f\u306f\u30d5\u30a1\u30a4\u30eb\u540d\u306b\u4f7f\u7528\u3067\u304d\u306a\u3044\u6587\u5b57\u304c\u542b\u307e\u308c\u3066\u3044\u307e\u3059");
            System.err.println(this.path);
            System.exit(1);
        }
        File tmp = new File(this.path);
        this.java_path = tmp.getParent();
        if (this.java_path == null) {
            this.package_name = "";
            this.java_path = "";
        } else {
            char[] ch = this.java_path.toCharArray();
            for (i2 = 0; i2 < ch.length; ++i2) {
                if (ch[i2] != File.separatorChar) continue;
                ch[i2] = 46;
            }
            this.package_name = "." + new String(ch);
        }
        char[] ch = this.java_path.toCharArray();
        for (i2 = 0; i2 < ch.length; ++i2) {
            ch[i2] = ch[i2] == File.separatorChar ? 95 : Character.toUpperCase(ch[i2]);
        }
        this.enum_name = ch.length > 0 ? new String(ch) + "_" : "";
        this.class_name = tmp.getName().toLowerCase(Locale.ENGLISH);
        String[] part = this.class_name.split("[\\p{Punct}\\p{Space}]+");
        StringBuffer buf = new StringBuffer();
        for (i = 0; i < part.length; ++i) {
            ch = part[i].toCharArray();
            ch[0] = Character.toUpperCase(ch[0]);
            buf = buf.append(new String(ch));
        }
        this.class_name = buf.toString();
        buf = new StringBuffer(this.enum_name);
        this.enum_name = tmp.getName().toUpperCase();
        part = this.enum_name.split("[\\p{Punct}\\p{Space}]+");
        for (i = 0; i < part.length; ++i) {
            if (i > 0) {
                buf = buf.append("_");
            }
            buf = buf.append(part[i]);
        }
        this.enum_name = buf.toString();
        this.java_path = this.java_path + File.separatorChar + this.class_name + ".java";
        String cf = name_check.get(this.java_path);
        if (cf != null) {
            System.err.println("\u4f3c\u305f\u30d5\u30a1\u30a4\u30eb\u540d\u304c\u5b58\u5728\u3059\u308b\u305f\u3081\u3001\u751f\u6210\u3059\u308b\u30af\u30e9\u30b9\u540d\u304c\u885d\u7a81\u3057\u307e\u3059");
            System.err.println(cf);
            System.err.println(this.path);
            System.exit(1);
        }
        name_check.put(this.java_path, this.path);
        this.id = (Param.PACKAGE.get() + this.path).hashCode();
        if (this.id < 0) {
            this.id *= -1;
        }
        while ((page = hash_map.get(this.id)) != null) {
            ++this.id;
            if (this.id >= 10) continue;
            this.id = 10;
        }
        hash_map.put(this.id, this);
    }

    @Override
    protected DynamicPage makePage() {
        return new PrePage(this);
    }

    private PrePage(Page p) {
        super(Boolean.valueOf(Param.NEKO.get()), null, p, Param.provider);
    }

    PrePage(File p) throws FileNotFoundException, UnsupportedEncodingException, IOException, DynamicPageException {
        this(p, false);
    }

    PrePage(File p, boolean dev_f) throws FileNotFoundException, UnsupportedEncodingException, IOException, DynamicPageException {
        super(Boolean.valueOf(Param.NEKO.get()), null, Param.provider);
        this.path = p.getPath();
        this.html_last_time = p.lastModified();
        if (!dev_f) {
            this.init();
        }
        if (this instanceof Download) {
            return;
        }
        StringBuffer out_path = new StringBuffer(Make.SRC_PATH);
        out_path = out_path.append(File.separator);
        out_path = out_path.append(out_dir[0]);
        out_path = out_path.append(File.separator);
        if (new File((out_path = out_path.append(this.java_path)).toString()).lastModified() > this.html_last_time) {
            return;
        }
        Linker.readme.setCurrentPage(this);
        this.create(p, Param.IN_ENCODE.get());
    }

    @Override
    public PageID getID() {
        return new PrePageID(this.id);
    }

    protected URI getMyselfURI() {
        try {
            return new URI(Output.toHtmlPath(this.path));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String getContentType() {
        return "text/html; charset=" + this.getCharset();
    }

    @Override
    public String getCharset() {
        return Param.OUT_ENCODE.get();
    }

    public static void main(String[] argc) throws Exception {
        File inp = new File(argc[0]);
        SourceHead.init(new File(argc[2]));
        PrePage pp = new PrePage(inp, true);
        readme readme2 = new readme();
        readme2.write(new File(argc[1]), pp, Long.MAX_VALUE);
    }

    @Override
    protected Tag makeTag(String name, ArrayList<Attribute> attr) throws Exception {
        TagSource nt = new TagSource(name, PrePage.isSimpleTag(name));
        int cnt = attr.size();
        for (int i = 0; i < cnt; ++i) {
            nt.setAttribute(attr.get(i));
        }
        return nt;
    }

    @Override
    protected Comment makeComment(String str) {
        return new CommentSource(str);
    }

    @Override
    protected Text makeText(String str) {
        return new TextSource(str);
    }

    class PrePageID
    implements PageID {
        private int id = 0;

        PrePageID(int p) {
            this.id = p;
        }

        @Override
        public boolean isSame(Page p) {
            return p.getID().getID() == this.id;
        }

        @Override
        public int getID() {
            return this.id;
        }

        @Override
        public PageFactory getPageFactory() {
            return null;
        }

        @Override
        public PageID getPageID(int hash) {
            return null;
        }
    }
}

