/*
 * Decompiled with CFR 0.152.
 */
package paraselene.dyna;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.text.html.parser.ParserDelegator;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;
import paraselene.Comment;
import paraselene.Page;
import paraselene.Text;
import paraselene.Version;
import paraselene.dyna.Cache;
import paraselene.dyna.CallBack;
import paraselene.dyna.DynamicPageException;
import paraselene.dyna.GrantTagProvider;
import paraselene.dyna.Handler;
import paraselene.dyna.InStream;
import paraselene.dyna.URIEcho;
import paraselene.dyna.URIResolver;
import paraselene.mockup.TagMap;
import paraselene.supervisor.Forward;
import paraselene.supervisor.PageID;
import paraselene.supervisor.RequestParameter;
import paraselene.tag.Tag;
import paraselene.tag.attr.Attribute;

public class DynamicPage
extends Page {
    private static final long serialVersionUID = 2L;
    private static String[] simple = new String[]{"area", "base", "basefont", "bgsound", "br", "col", "frame", "hr", "img", "input", "isindex", "keygen", "link", "meta", "nextid", "param", "spacer", "wbr"};
    private static HashMap<String, String> simple_map = new HashMap();
    private Page page = null;
    private URIResolver resolve = null;
    private GrantTagProvider[] provider = null;
    private boolean neko_f = false;
    private static final String START_XML = "<?xml";
    private static final String START_DOCTYPE = "<!DOCTYPE";
    private static final String START_HTML = "<html";

    public static boolean isSimpleTag(String name) {
        return simple_map.get(name = name.toLowerCase(Locale.ENGLISH)) != null;
    }

    public DynamicPage(boolean neko, URIResolver ur, GrantTagProvider[] gtp) {
        this.neko_f = neko;
        this.resolve = ur;
        this.provider = gtp;
    }

    public DynamicPage(boolean neko, URIResolver ur, Page p, GrantTagProvider[] gtp) {
        this(neko, ur, gtp);
        this.page = p;
    }

    private boolean isXHTML(InputStream in) throws IOException {
        String line;
        BufferedReader r = new BufferedReader(new InputStreamReader(in));
        boolean xml = false;
        StringBuffer doc = null;
        while ((line = r.readLine()) != null) {
            int start;
            if ((line = line.trim() + " ").isEmpty()) continue;
            int loc = line.indexOf(START_XML);
            if (loc >= 0) {
                xml = true;
            }
            if ((start = line.indexOf(START_DOCTYPE)) >= 0) {
                doc = new StringBuffer();
            }
            if (doc != null) {
                int end;
                if (start > 0) {
                    line = line.substring(start);
                }
                if ((end = line.indexOf(62)) < 0) {
                    doc = doc.append(line);
                    continue;
                }
                doc = doc.append(line.substring(0, end + 1));
                break;
            }
            if (line.toLowerCase(Locale.ENGLISH).indexOf(START_HTML) < 0) continue;
            break;
        }
        r.close();
        this.setDoctype(xml, doc == null ? null : doc.toString());
        return xml;
    }

    public void create(String str) throws DynamicPageException {
        try {
            if (this.isXHTML(new InStream(str))) {
                this.createXML(new InStream(str));
            } else {
                this.createHTML(new InStream(str), null);
            }
        }
        catch (DynamicPageException dpe) {
            throw dpe;
        }
        catch (Exception e) {
            throw new DynamicPageException(e);
        }
    }

    public void create(File f, String enc) throws DynamicPageException {
        try {
            if (this.isXHTML(new InStream(f))) {
                this.createXML(new InStream(f));
            } else {
                this.createHTML(new InStream(f), enc);
            }
        }
        catch (DynamicPageException dpe) {
            throw dpe;
        }
        catch (Exception e) {
            throw new DynamicPageException(e);
        }
    }

    private void createXML(InputStream in) throws DynamicPageException {
        try {
            if (this.neko_f) {
                this.createHTML(in, null);
                return;
            }
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            parser.parse(in, (DefaultHandler)new Handler(this));
            in.close();
        }
        catch (Exception e) {
            try {
                in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new DynamicPageException(e);
        }
    }

    private void createHTML(InputStream is, String enc) throws DynamicPageException {
        try {
            if (this.neko_f) {
                org.cyberneko.html.parsers.SAXParser parser = new org.cyberneko.html.parsers.SAXParser();
                if (enc != null) {
                    parser.setProperty("http://cyberneko.org/html/properties/default-encoding", (Object)enc);
                }
                InputSource in = new InputSource();
                in.setByteStream(is);
                parser.setContentHandler((ContentHandler)new Handler(this));
                parser.parse(in);
            } else {
                Reader in = null;
                in = enc == null ? new InputStreamReader(is) : new InputStreamReader(is, enc);
                in = new BufferedReader(in);
                ParserDelegator pd = new ParserDelegator();
                pd.parse(in, new CallBack(this), true);
                in.close();
            }
        }
        catch (Exception e) {
            try {
                is.close();
            }
            catch (Exception ee) {
                // empty catch block
            }
            throw new DynamicPageException(e);
        }
    }

    protected DynamicPage makePage() {
        return new DynamicPage(this.neko_f, this.resolve, this, this.provider);
    }

    protected Tag makeTag(String name, ArrayList<Attribute> attr) throws Exception {
        return TagMap.makeTag(name, attr, this.getCharset(), this.resolve, this.provider);
    }

    protected Comment makeComment(String str) {
        return new Comment(str);
    }

    protected Text makeText(String str) {
        return new Text(str);
    }

    @Override
    public void init() {
    }

    @Override
    public String getContentType() {
        if (this.page != null) {
            return this.page.getContentType();
        }
        return null;
    }

    @Override
    public String getCharset() {
        if (this.page != null) {
            return this.page.getCharset();
        }
        return "UTF-8";
    }

    @Override
    public PageID getID() {
        return null;
    }

    @Override
    public boolean isHistoryClear() {
        return false;
    }

    @Override
    public boolean isAllowHistoryAdd() {
        return false;
    }

    @Override
    public Forward input(RequestParameter req, Forward fw) throws Page.PageException {
        return fw;
    }

    @Override
    public Page output(Page from, RequestParameter req) throws Page.PageException {
        return this;
    }

    @Override
    public String getAliasURI() {
        return null;
    }

    @Override
    public int getUploadMaxBytes() {
        return -1;
    }

    @Override
    public boolean isCheckRepeatSameRequest() {
        return false;
    }

    public static void main(String[] argv) throws Exception {
        System.out.println(Version.getTitle());
        System.out.println(Version.getCopyRight());
        if (argv.length != 2) {
            System.out.println("HTML\u30d5\u30a1\u30a4\u30eb\u540d \u30d5\u30a1\u30a4\u30eb\u306e\u6587\u5b57\u30b3\u30fc\u30c9");
            System.out.println("\u3092\u6307\u5b9a\u3057\u3066\u4e0b\u3055\u3044\u3002");
            System.exit(0);
        }
        DynamicPage page = new DynamicPage(false, new URIEcho(), null);
        page.create(new File(argv[0]), argv[1]);
        String[] name = page.getDefineNameIndex();
        for (int i = 0; i < name.length; ++i) {
            System.out.print("name\u5c5e\u6027: ");
            System.out.println(name[i]);
            Tag[] tag = page.getAllTag(name[i]);
            for (int j = 0; j < tag.length; ++j) {
                System.out.print(" -> ");
                System.out.println(tag[j].getClass().getName());
            }
        }
        System.out.println("\u6b63\u5e38\u306b\u89e3\u6790\u53ef\u80fd\u3067\u3059");
        System.exit(0);
    }

    static {
        try {
            Cache.init();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        Cache.save();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int i = 0; i < simple.length; ++i) {
            simple_map.put(simple[i], simple[i]);
        }
    }
}

