/*
 * Decompiled with CFR 0.152.
 */
package statistics;

import java.util.Arrays;

public class stas {
    int count = 0;
    double sum1 = 0.0;
    double sum2 = 0.0;
    double max = 0.0;
    int maxPos = 0;

    public void clear() {
        this.count = 0;
        this.sum2 = 0.0;
        this.sum1 = 0.0;
        this.max = 0.0;
        this.maxPos = 0;
    }

    public void putArray(double[] data) {
        this.clear();
        int i = 0;
        while (i < data.length) {
            this.sample(data[i]);
            ++i;
        }
    }

    public void sample(double datum) {
        if (!Double.isNaN(datum) && !Double.isInfinite(datum)) {
            if (this.max < datum) {
                this.max = datum;
                this.maxPos = this.count;
            }
            ++this.count;
            this.sum1 += datum;
            this.sum2 += datum * datum;
        }
    }

    public void noData() {
        ++this.count;
    }

    public double mean() {
        if (this.count == 0) {
            return 0.0;
        }
        return this.sum1 / ((double)this.count + 0.0);
    }

    public double variance() {
        double tmp = (double)this.count + 0.0;
        if (this.count <= 1) {
            return 0.0;
        }
        double smp = this.sum2 / tmp - this.mean() * this.mean();
        return smp * (tmp / (tmp - 1.0));
    }

    public double SD() {
        return Math.sqrt(this.variance());
    }

    public double CV() {
        return this.SD() / this.mean();
    }

    public double max() {
        return this.max;
    }

    public int maxPos() {
        return this.maxPos;
    }

    public double Grubbs() {
        return (this.max() - this.mean()) / this.SD();
    }

    public static double top(double[] data) {
        double[] copy = new double[data.length];
        int i = 0;
        while (i < data.length) {
            copy[i] = data[i];
            ++i;
        }
        Arrays.sort(copy);
        double result = 0.0;
        int i2 = 1;
        while (i2 <= 1) {
            result += copy[copy.length - i2];
            ++i2;
        }
        return result;
    }

    public static double mean(double[] data) {
        stas stas2 = new stas();
        stas2.putArray(data);
        return stas2.mean();
    }

    public static double Grubbs(double[] data) {
        stas stas2 = new stas();
        stas2.putArray(data);
        return stas2.Grubbs();
    }
}

