/*
 * Decompiled with CFR 0.152.
 */
package sequence;

import FFT.corr;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import sequence.abstChar;
import sequence.aminoacid;
import sequence.nucleotide;

public class sequenceBase {
    abstChar type = new abstChar();
    double[][] baseSeqProperty;
    String Base;

    public void setSequence(String baseSequence) {
        this.Base = baseSequence;
        this.type = sequenceBase.isDNA(baseSequence) ? new nucleotide() : new aminoacid();
        this.baseSeqProperty = sequenceBase.numerize(baseSequence);
    }

    public void setSequence(String[] baseSequence) {
        this.Base = baseSequence[0];
        this.type = sequenceBase.isDNA(baseSequence[0]) ? new nucleotide() : new aminoacid();
        this.baseSeqProperty = this.numerize(baseSequence);
    }

    static boolean isDNA(String sequence) {
        double count = 0.0;
        int checklen = 100;
        if (checklen > sequence.length()) {
            checklen = sequence.length();
        }
        int i = 0;
        while (i < checklen) {
            char c = sequence.charAt(i);
            if (sequenceBase.canBeNucleotide(c)) {
                count += 1.0;
            }
            ++i;
        }
        return count / (double)checklen > 0.8;
    }

    static boolean canBeNucleotide(char c) {
        switch (c) {
            case 'A': 
            case 'C': 
            case 'G': 
            case 'N': 
            case 'T': 
            case 'U': 
            case 'a': 
            case 'c': 
            case 'g': 
            case 'n': 
            case 't': 
            case 'u': {
                return true;
            }
        }
        return false;
    }

    public static double[][] numerize(String seq) {
        abstChar type = sequenceBase.isDNA(seq) ? new nucleotide() : new aminoacid();
        int len = seq.length();
        double[][] result = new double[len][];
        int i = 0;
        while (i < len) {
            result[i] = type.get(seq.charAt(i));
            ++i;
        }
        return result;
    }

    public double[][] numerize(String[] seq) {
        int size = seq.length;
        double[][][] tmp = new double[size][][];
        int i = 0;
        while (i < size) {
            tmp[i] = sequenceBase.numerize(seq[i]);
            ++i;
        }
        int len = tmp[0].length;
        double[][] result = new double[len][];
        int j = 0;
        while (j < len) {
            int num = tmp[0][0].length;
            int i2 = 0;
            while (i2 < size) {
                if (num > tmp[0][j].length) {
                    num = tmp[0][j].length;
                }
                ++i2;
            }
            result[j] = new double[num];
            int k = 0;
            while (k < num) {
                result[j][k] = 0.0;
                int i3 = 0;
                while (i3 < size) {
                    double[] dArray = result[j];
                    int n = k;
                    dArray[n] = dArray[n] + tmp[i3][j][k];
                    ++i3;
                }
                ++k;
            }
            ++j;
        }
        return result;
    }

    public static double[] corr(String seq1, String seq2) {
        double[][] seq1Property = sequenceBase.numerize(seq1);
        double[][] seq2Property = sequenceBase.numerize(seq2);
        return corr.corr0(seq1Property, seq2Property);
    }

    public int lag(String seq2) {
        double[] data = corr.corr0(this.baseSeqProperty, sequenceBase.numerize(seq2));
        int imax = 0;
        double max = 0.0;
        int i = 0;
        while (i < data.length) {
            if (max < data[i]) {
                imax = i;
                max = data[i];
            }
            ++i;
        }
        if ((double)imax <= 0.5 * (double)data.length) {
            return imax;
        }
        return imax - data.length;
    }

    public int groupLag(String[] seq2) {
        double[] data = corr.corr0(this.baseSeqProperty, this.numerize(seq2));
        int imax = 0;
        double max = 0.0;
        int i = 0;
        while (i < data.length) {
            if (max < data[i]) {
                imax = i;
                max = data[i];
            }
            ++i;
        }
        if ((double)imax <= 0.5 * (double)data.length) {
            return imax;
        }
        return imax - data.length;
    }

    public String[] roughAlign(String[] seqArr) {
        int size = seqArr.length;
        int[] lag = new int[size];
        int n = 0;
        while (n < size) {
            lag[n] = this.lag(seqArr[n]);
            ++n;
        }
        int min = 0;
        int n2 = 0;
        while (n2 < size) {
            if (min > lag[n2]) {
                min = lag[n2];
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < size) {
            int n3 = n2++;
            lag[n3] = lag[n3] - min;
        }
        int max = 0;
        int n4 = 0;
        while (n4 < size) {
            if (max < lag[n4] + seqArr[n4].length()) {
                max = lag[n4] + seqArr[n4].length();
            }
            ++n4;
        }
        String[] result = new String[size];
        int n5 = 0;
        while (n5 < size) {
            char[] head = new char[lag[n5]];
            int i = 0;
            while (i < head.length) {
                head[i] = 45;
                ++i;
            }
            String tmp0 = new String(head);
            int tailLen = max - (lag[n5] + seqArr[n5].length());
            char[] tail = new char[tailLen];
            int i2 = 0;
            while (i2 < tail.length) {
                tail[i2] = 45;
                ++i2;
            }
            String tmp1 = new String(tail);
            result[n5] = String.valueOf(tmp0) + seqArr[n5] + tmp1;
            ++n5;
        }
        result = sequenceBase.gapSkip(result);
        return result;
    }

    public String hybridyze(int lag, String query) {
        StringBuffer result = new StringBuffer();
        char[] head = new char[lag];
        Arrays.fill(head, '-');
        result.append(head);
        result.append(query);
        char[] tail = new char[lag];
        Arrays.fill(tail, '-');
        result.append(tail);
        return result.toString();
    }

    public String align2(String query) {
        int lag = this.lag(query);
        return this.hybridyze(lag, query);
    }

    public String[][] groupAlign(String[][] seqArr) {
        int size = seqArr.length;
        int[] lag = new int[size];
        int n = 0;
        while (n < size) {
            lag[n] = this.groupLag(seqArr[n]);
            ++n;
        }
        int min = 0;
        int n2 = 0;
        while (n2 < size) {
            if (min > lag[n2]) {
                min = lag[n2];
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < size) {
            int n3 = n2++;
            lag[n3] = lag[n3] - min;
        }
        int max = 0;
        int n4 = 0;
        while (n4 < size) {
            int i = 0;
            while (i < seqArr[n4].length) {
                if (max < lag[n4] + seqArr[n4][i].length()) {
                    max = lag[n4] + seqArr[n4][i].length();
                }
                ++i;
            }
            ++n4;
        }
        String[][] result = new String[size][];
        int n5 = 0;
        while (n5 < size) {
            char[] head = new char[lag[n5]];
            int i = 0;
            while (i < head.length) {
                head[i] = 45;
                ++i;
            }
            String tmp0 = new String(head);
            int tailLen = max - (lag[n5] + seqArr[n5][0].length());
            char[] tail = new char[tailLen];
            int i2 = 0;
            while (i2 < tail.length) {
                tail[i2] = 45;
                ++i2;
            }
            String tmp1 = new String(tail);
            result[n5] = new String[seqArr[n5].length];
            int i3 = 0;
            while (i3 < seqArr[n5].length) {
                result[n5][i3] = String.valueOf(tmp0) + seqArr[n5][i3] + tmp1;
                ++i3;
            }
            ++n5;
        }
        return result;
    }

    public static String[] gapSkip(String[] data) {
        int size = data.length;
        if (size <= 1) {
            return data;
        }
        StringBuffer[] newdata = new StringBuffer[size];
        int i = 0;
        while (i < size) {
            newdata[i] = new StringBuffer();
            ++i;
        }
        int len = data[0].length();
        int j = 0;
        while (j < len) {
            boolean no_gap = false;
            int i2 = 0;
            while (i2 < size) {
                if (data[i2].charAt(j) != '-') {
                    no_gap = true;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < size) {
                if (no_gap) {
                    newdata[i2].append(data[i2].charAt(j));
                }
                ++i2;
            }
            ++j;
        }
        String[] result = new String[size];
        int i3 = 0;
        while (i3 < size) {
            result[i3] = newdata[i3].toString();
            ++i3;
        }
        return result;
    }

    public static String[][] gapReset(String[][] data) {
        int size = data[0].length;
        String[][] result = new String[2][size];
        result[0] = data[0];
        StringBuffer[] newdata = new StringBuffer[size];
        int i = 0;
        while (i < size) {
            newdata[i] = new StringBuffer();
            ++i;
        }
        i = 0;
        while (i < size) {
            int len = data[1][i].length();
            int j = 0;
            while (j < len) {
                if (data[1][i].charAt(j) != '-') {
                    newdata[i].append(data[1][i].charAt(j));
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < size) {
            result[1][i] = newdata[i].toString();
            ++i;
        }
        return result;
    }

    public static String consensus(String[] data) {
        int size = data.length;
        if (size <= 1) {
            return data[0];
        }
        StringBuffer result = new StringBuffer();
        int len = data[0].length();
        int j = 0;
        while (j < len) {
            HashMap<Character, Integer> dataList = new HashMap<Character, Integer>();
            int i = 0;
            while (i < data.length) {
                Character c = new Character(data[i].charAt(j));
                if (dataList.containsKey(c)) {
                    int former = (Integer)dataList.get(c);
                    dataList.put(c, new Integer(former + 1));
                } else {
                    dataList.put(c, new Integer(1));
                }
                ++i;
            }
            Iterator e = dataList.keySet().iterator();
            char c = '-';
            int max = 0;
            while (e.hasNext()) {
                Character C = (Character)e.next();
                int count = (Integer)dataList.get(C);
                if (count <= max) continue;
                max = count;
                c = C.charValue();
            }
            result.append(c);
            ++j;
        }
        return result.toString();
    }
}

