package blast;

public class BlastTest {
	public static int extention = 20; // Altschul et al. 1990 JMB 215:405

	public static void main(String[] args){
		String query =  "QQAAA";
		String genome = "TATATAAQQAAATAAAAAAAAATAAAAAAAAATAAAAA";
//		String genome = "ATGC";
		int queryLen = query.length();
		double [][] ScoreMatrix = initMatrix(100);
		for(int i=0;i<genome.length();i++){
			double[] s = score(genome,i,query,0);
			if(s[0]>0){
				System.out.print( i );
				System.out.print( "\t" );
				System.out.print( s[0] );
				System.out.print( "\t" );
				System.out.print( s[1] );
				System.out.print( "\t" );
				System.out.println( s[2] );
			}
		}
	}
	
	public static void oldMain(String[] args){
		String query = "TATATA";
		String genome = "AQQAAATAAAAAAAAATAAAAAAAAATAAAAA";
		int queryLen = query.length();
		double [][] ScoreMatrix = initMatrix(100);
		double Stmp=0;
		double Smax=0;
		int maxEnd=0;
		int tsuishiCount=0;// ǎ󂯂
		for(int i=0;i<queryLen;i++){
			char g = genome.charAt(i);
			char q = query.charAt(i);
			Stmp += ScoreMatrix[charToInt(g)][charToInt(q)];
			tsuishiCount++;
			if(tsuishiCount>extention) break;
			if(Stmp>Smax){
			     Smax=Stmp;
			     maxEnd = i;
			     tsuishiCount=0;  //ǎōi
			}
		}
		System.out.print(maxEnd);
		System.out.println();
	}
	
	public static double[] score(String database, int dataPos, String query, int queryPos){
		int queryLen = query.length();
		double [][] ScoreMatrix = initMatrix(100);
		double Stmp=0;
		double Smax=0;
		int maxStart=0;
		int maxEnd=0;
		int tsuishiCount=0;// ǎ󂯂
		//OɐL΂
		for(int i=0;i>-queryLen;i--){
			if(i+dataPos<0)  break; // ͈͊O
			if(i+queryPos<0) break; // ͈͊O
			char g = database.charAt(i+dataPos);
			char q = query.charAt(i+queryPos);
			Stmp += ScoreMatrix[charToInt(g)][charToInt(q)];
			tsuishiCount++;
			if(tsuishiCount>extention) break;
			if(Stmp>Smax){
			     Smax=Stmp;
			     maxStart = i;
			     tsuishiCount=0;  //ǎōi
			}
		}
		//ɐL΂
		for(int i=1;i<queryLen;i++){
			if(i+dataPos>=database.length()) break; // ͈͊O
			if(i+queryPos>=query.length())   break; // ͈͊O
			char g = database.charAt(i+dataPos);
			char q = query.charAt(i+queryPos);
			Stmp += ScoreMatrix[charToInt(g)][charToInt(q)];
			tsuishiCount++;
			if(tsuishiCount>extention) break;
			if(Stmp>Smax){
			     Smax=Stmp;
			     maxEnd = i;
			     tsuishiCount=0;  //ǎōi
			}
		}
		double[] result = new double[3];
		result[0] = Smax; // maximum score
		result[1] = maxStart; // maximum score
		result[2] = maxEnd; // maximum score
		return result;
	}
	
	public static int genomeChar(int pos, String genome){
		return 1;
	}
	
	public static int queryChar(int pos, String genome){
		return (int) Math.random()*10; 
	}
	
	public static double[][] initMatrix(int max){
		double[][] result = new double[max][max];
		for(int i=0;i<max;i++){
			for(int j=0;j<max;j++){
				result[i][j]=-1;
			}
			result[i][i]=1;
		}
		return result;
	}
	
    public static int charToInt(char c){
    	String alphabet = "$,ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz";
    	int max = alphabet.length();
    	int result = alphabet.indexOf(c);
    	if (result<0) result = 0; // no char
    	return result;
    }
}
