#include <stdio.h>
#include <stdlib.h>
#include <math.h>
//#include <iostream>
#include <string>
//#include <vector>
#include <search.h>

//#define _TEST_OUT

extern "C" int printflag;

extern "C" {
// ysh string utilities : 変更改修版　for RPD project.
// 200603 NIS ysh
/* 空白区切り文字列操作 */
/* 指定した番号のカラムを抜き出し。 whichindex は0からはじまる。 */
int spcExtractCol(char* oneline, int whichindex, int extColSize, char* extCol);
/* csv文字列操作 */
/* csvカラム数を数える。*/
int csvCountCol(char* oneline);
/* csv文字列操作 */
/* csvである文字列の指定した番号のカラムを抜き出し。 whichindex は0からはじまる。 */
int csvExtractCol(char* oneline, int whichindex, char* extCol);
/* 私家版 isnumerical() */
/* 与えられた文字列が数値に変換できるかどうかを調べる。*/
int StrCanBeANum(char* numstring);
/* 私家版trim */
/* 最初と最後の続いている空白文字と最後のリターンコードを削除する。*/
int RmTopLastSpaceAndRet(char* numstring);
/* ファイル拡張子のチェック */
int FileExCheck(char* OrgStr, char* ExStr);
/* 簡易型カラム抜き出し。エラーチェックなし。一度にカラムに分解。*/
int csvEasyExtractCol(char DivCh, char* OneLine, int maxcol, int NumOfCol, char* extCol);
/* tab区切文字列操作 */
/* tab区切カラム数を数える。*/
int tabCountCol(char* oneline);
/* tab区切文字列操作 */
/* tab区切である文字列の指定した番号のカラムを抜き出し。 whichindex は0からはじまる。 */
int tabExtractCol(char* oneline, int whichindex, char* extCol);
// "//"以降を削除する。返値は'/'の位置
int slashCommentCut(char* oneline);
// 汎用文字区切り(空白文字以外のascii文字で区切られている)カラム数をかぞえる
int charCountCol(char divchar, char* oneline);
// 汎用文字区切り(空白文字以外のascii文字で区切られている)カラム取り出し。
int charExtractCol(char divchar, char* oneline, int whichindex, char* extCol);
// CommentChar文字以降を削除する。返値はCommentCharの位置。
int charCommentCut(char CommentChar, char* oneline);
// rmChar で指定される文字を消去して左詰めする。
int charRmChar(char rmChar, char* oneline);
//add by yyukawa:2008/5/12
/* csvである文字列のカラムを一気に配列にコピーする */
int csvCopyCol(char* oneline, char** copycol, int maxcolnum);
//add by yyukawa:2008/6/12
int tabCopyCol(char* oneline, char** copycol, int maxcolnum);
//add by yyukawa:2008/11/4
int spcCountCol(char* oneline);
int spcCopyCol(char* oneline, char** copycol, int maxcolnum);
}
 
#define _STR_MAX_ 100 //FinalReportの一部のSampleIDが長いが未確認
#define _SAMPLE_MAX_ 6000 //_STR_MAX_ 100にしたことで、少し減らした
#define _MAX_ONELINE_ 100000

#include "snpslist.h"

/*
snp1から
pSNPsChr
caseSNPsPosition
controlSNPsPosition
を拡張した
*/
CSNPsData::CSNPsData() {
  pSNPsName[0] = '\0';
  pSNPsChr[0] = '\0';
  SNPsPos = 0;
  genotype1 = '!'; //万が一未定義の場合、変なgenotypeに変換されるようにしておく
  genotype2 = '!';
  not_active = 0;
};
CSNPsData::~CSNPsData() {
};

// pSNPsName名でqsort()、の比較関数
int _CompSNPsItem( const void *a, const void *b )
{
  int ret = strcmp(((CSNPsData*)a)->pSNPsName, ((CSNPsData*)b)->pSNPsName);

	if( ret > 0 ){
		return 1;
	}
	if( ret < 0 ){
		return -1;
	}

	return 0;
}
// pSNPsName名でbsearch()、の比較関数
int _CompSNPsItemS( const void *a, const void *b )
{
  int ret = strcmp((char*)a, ((CSNPsData*)b)->pSNPsName);

	if( ret > 0 ){
		return 1;
	}
	if( ret < 0 ){
		return -1;
	}

	return 0;
}

/*
snp1のmake_diffdata()の代わりに、単純に読み込むread_data()に変更
*/
CSNPsList::CSNPsList() {
  //pSNPsFile = NULL;
  pSNPsDataList = NULL;
  numberlst = 0;
  currentpos = 0;
  sorttype = 0;
};
CSNPsList::~CSNPsList() {
  //if(pSNPsFile) fclose(pSNPsFile);
  /*
  for(int i = 0; i < numberlst; i++) {
    delete pSNPsDataList[i];
  }
  */
  delete [] pSNPsDataList;
};

CSNPsData* CSNPsList::iterate_snpsdata(int &iterator) { //順番に取り出す
  if(iterator >= numberlst) return NULL;
  return &(pSNPsDataList[iterator++]);
}

//単純にSNPsListを読み込む
int CSNPsList::read_data(const char* filename2) { //SNPsListを作成する
  int ret = 0;
#ifdef _DEBUG
  FILE* fpd;
#endif

  FILE* fp2 = fopen(filename2, "r");
  if(!fp2) {
    printf("CSNPsList::make_diffdata:error fopen(%s)", filename2);
    ret = -1;
    return ret;
  }

  //ライン数
  int snpsnum2 = 0;
  char oneline[_MAX_ONELINE_]; //1行格納

  //先頭の8行を読み飛ばす
  for(int i = 0; i < 8; i++) {
    fgets(oneline, _MAX_ONELINE_, fp2);
    if(i == 5) {
      //6行目にはデータ数が書き込まれているので取得する
      ret = RmTopLastSpaceAndRet(oneline);
      char onecol[_STR_MAX_];
      ret = csvExtractCol(oneline, 1, onecol); //2カラム目を取り出す
      snpsnum2 = atoi(onecol);
    }
  }

  //SNPsの数は、6行目のデータ数と同じ
  //numberlst = snpsnum2;

  //SNPs名の配列を作成する
  pSNPsDataList = new CSNPsData[snpsnum2];

  //読み込み
  fseek(fp2, 0L, SEEK_SET); //先頭に戻す
  //先頭の8行を読み飛ばす
  for(int i = 0; i < 8; i++) {
    fgets(oneline, _MAX_ONELINE_, fp2);
  }

#ifdef _DEBUG
  fpd = fopen("C:\\cygwin\\home\\riken\\readsnps.txt", "w");
  fprintf(fpd, "snpsnum2 = %d\n", snpsnum2);
#endif
  //SNPs名、chromosome情報を格納する
  int iterator = 0;
  numberlst = 0; //SNPsの数を数える
  for(int i = 0; i < snpsnum2; i++) {
    fgets(oneline, _MAX_ONELINE_, fp2);
    char onecol[_STR_MAX_];

    ret = csvExtractCol(oneline, 1, onecol); //2カラム目"Name"を取り出す
    //SNPs名を格納する
    strcpy(pSNPsDataList[iterator].pSNPsName , onecol); //SNPs名を格納する

    ret = csvExtractCol(oneline, 9, onecol); //10カラム目"Chr"を取り出す
    //chromosome情報を格納する
    strcpy(pSNPsDataList[iterator].pSNPsChr , onecol); //chromosome情報を格納する

    ret = csvExtractCol(oneline, 10, onecol); //11カラム目"MapInfo"を取り出す
    //chromosome情報を格納する
    pSNPsDataList[iterator].SNPsPos = atoi(onecol); //Position情報を格納する

    ret = csvExtractCol(oneline, 3, onecol); //4カラム目"SNP"を取り出す
    //genotype情報を格納する
    pSNPsDataList[iterator].genotype1 = onecol[1]; //genotype情報を格納する
    pSNPsDataList[iterator].genotype2 = onecol[3]; //genotype情報を格納する

    //位置情報チェック
    if(pSNPsDataList[iterator].SNPsPos == 0) {
      //return -1;
      //実在するが、参照されないことを願って続行する
    }

#ifdef _DEBUG
    fprintf(fpd, "pSNPsName = %s, pSNPsChr = %s, SNPsPos = %d\n", pSNPsDataList[iterator].pSNPsName, pSNPsDataList[iterator].pSNPsChr, pSNPsDataList[iterator].SNPsPos);
#endif
    iterator++;

    numberlst++;
  }
#ifdef _DEBUG
  fclose(fpd);
#endif

  //SNPs名配列をソートする（検索用）
  sort_by_SNPsName();

exit_function:
  return ret;
};

void CSNPsList::get_listnum(int& n) { n = numberlst; } //SNPs数を返す

void CSNPsList::sort_by_SNPsName() {
  //SNPsNameで検索用にソートしておく
  qsort( pSNPsDataList, numberlst, sizeof(CSNPsData), _CompSNPsItem );
  sorttype = 1;
};

int CSNPsList::del_list_by_Name(char* name) { //not_activeを1にするだけ
  int ret = 0;
  int flag = 0;
  CSNPsData* pSL = search_list(name, flag);
  if(flag && pSL) {
    pSL->not_active = 1;
  }
  return ret;
};

CSNPsData* CSNPsList::search_list(char* name, int& flag) { //flag:1あり
  if(sorttype != 1) {
    printf("!!!bug:not sort by SNPsName!!!\n");
    exit(1);
  }
  CSNPsData* result = (CSNPsData*)bsearch( name, pSNPsDataList, numberlst, sizeof(CSNPsData), _CompSNPsItemS );
  if(result) {
    if(result->not_active == 0) {
      flag = 1;
      return result;
    }
  }
  flag = 0;
  return NULL;
};

