#!/bin/sh

if [ $# != 6 ];
  then
    echo "[usage]`basename $0` [InputFile] [LDblockFile] [OutputFile] [PhasingType] [SNPNumLimit] [ProcNum]"
    exit
fi

InputFile=$1
LDblockFile=$2
OutputFile=$3
PhasingType=$4
SNPNumLimit=$5
ProcNum=${6}

ScriptFile=`basename $OutputFile`.batch

### InputFile is not exist, exit
if [ ! -e "$InputFile" ];
  then
    echo "$InputFile is not exist"
    exit
fi

### LDblockFile is not exist, exit
if [ ! -e "$LDblockFile" ];
  then
    echo "$LDblockFile is not exist"
    exit
fi

### Check PhasingType
if [ $PhasingType != 0 -a $PhasingType != 1 ];
  then
    echo "Input error of PhasingType"
    exit
fi


### Make BatchScriptFile
echo "#!/bin/sh" > $ScriptFile
echo "" >> $ScriptFile
echo "#MJS: -mpc" >> $ScriptFile
echo "#MJS: -proc $ProcNum" >> $ScriptFile
echo "#MJS: -time 24:00:00" >> $ScriptFile
echo "#MJS: -cwd" >> $ScriptFile
echo "#MJS: -eo" >> $ScriptFile
echo "#MJS: -rerun y" >> $ScriptFile
echo "" >> $ScriptFile
#echo "#FTLDIR: \${MJS_CWD}" >> $ScriptFile
echo "#BEFORE:MASTER: $InputFile" >> $ScriptFile
echo "#BEFORE:MASTER: $LDblockFile" >> $ScriptFile
echo "#AFTER:MASTER:$OutputFile" >> $ScriptFile
#echo "#BEFORE:*: ../bin/haplotypePhasingParallel.exe" >> $ScriptFile
#echo "#BEFORE:*: ../bin/PHASE" >> $ScriptFile
echo "#BEFORE:*: $SNP_HOME/bin/haplotypePhasingParallel.exe" >> $ScriptFile
echo "#BEFORE:*: $SNP_HOME/bin/PHASE" >> $ScriptFile
echo "" >> $ScriptFile
echo "cd \${MJS_CWD}" >> $ScriptFile
echo "mpirun haplotypePhasingParallel.exe $InputFile $LDblockFile $OutputFile $PhasingType $SNPNumLimit" >> $ScriptFile


### Execute Batch Job
qsub $ScriptFile

### Delete BatchScriptFile
rm $ScriptFile
