#!/bin/sh

if [ $# != 10 ];
  then
    echo "[usage]`basename $0` [InputFile1] [InputFile2] [OutputFile1] [AreaFileType] [BlockAreaFile] [Score] [Gen] [Burnin] [DataType] [ProcNum]"
    exit
fi

InputFile1=$1
InputFile2=$2
OutputFile1=$3
AreaFileType=$4
BlockAreaFile=$5
Score=$6
Gen=$7
Burnin=$8
DataType=$9
shift
ProcNum=$9

ScriptFile=`basename $OutputFile1`.batch

### InputFile1 is not exist, exit
#if [ ! -e "$InputFile1" ];
#  then
#    echo "$InputFile1 is not exist"
#    exit
#fi

### InputFile2 is not exist, exit
#if [ ! -e "$InputFile2" ];
#  then
#    echo "$InputFile2 is not exist"
#    exit
#fi

### Check AreaFileType
#if [ $AreaFileType != 0 -a $AreaFileType != 1 ];
#  then
#    echo "Input error of AreaFileType"
#    exit
#fi

### BlockAreaFile is not exist, exit
#if [ ! -e "$BlockAreaFile" ];
#  then
#    echo "$BlockAreaFile is not exist"
#    exit
#fi

### Check Score
if [ $Score != 0 -a $Score != 1 ];
  then
    echo "Input error of Score"
    exit
fi

### Check DataType
if [ $DataType != 0 -a $DataType != 1 -a $DataType != 2 ];
  then
    echo "Input error of DataType"
    exit
fi

### Make BatchScriptFile
echo "#!/bin/sh" > $ScriptFile
echo "" >> $ScriptFile
echo "#FX: -proc $ProcNum" >> $ScriptFile
echo "#FX: -time 2:00:00" >> $ScriptFile
echo "#FX: -q fx32" >> $ScriptFile
echo "#FX: -eo" >> $ScriptFile
echo "" >> $ScriptFile
echo "cd \${QSUB_WORKDIR}" >> $ScriptFile
echo "mpiexec -n \${QSUB_VNODES} ratParallel.exe $InputFile1 $InputFile2 $OutputFile1 $AreaFileType $BlockAreaFile $Score $Gen $Burnin $DataType" >> $ScriptFile


### Execute Batch Job
qsub $ScriptFile

### Delete BatchScriptFile
rm $ScriptFile
