#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#include "snp_Config.h"
#include "snp_Random.h"

#ifdef _OPENMP
#include <omp.h>
#endif

/* 0以上1未満の値を返す乱数発生関数 */
double myRand(dsfmt_t *snp_dsfmt_data)
{
    double result = 0;


    /* C言語組み込みのランダム関数 */
    //result = (double)(rand()-1) / (RAND_MAX);
    //return (double)(rand()-1) / (RAND_MAX);
    
    /* NumericalRecipes in C のran2 */
    //result = ran2(&idum);
    //return ran2(&idum);
    
    /* メルセンヌツイスター */
    //result = dsfmt_gv_genrand_close_open();
    result = dsfmt_genrand_close_open(snp_dsfmt_data);
    //return dsfmt_gv_genrand_close_open();


    /* resultに格納するより直接returnしたほうがはやい？ */
    return result;
}

/* 乱数発生関数初期化 */
void initMyRand(dsfmt_t *snp_dsfmt_data)
{
    int myThreadNum = 1;
    unsigned int seed = 0;

#ifdef _OPENMP
    /* スレッド番号を取得 */
    myThreadNum = omp_get_thread_num();
#endif

    /* 乱数のseedを決定 */
    seed = myThreadNum * 100000 + (unsigned)time(NULL) % 10000;

    /* 乱数系列の変更 */
    srand(seed);
    /* ran2の引数idumの初期値をランダムに決定*/
    idum = rand();
    /* メルセンヌツイスターの乱数seed設定 */
    //dsfmt_gv_init_gen_rand(rand());
    dsfmt_init_gen_rand(snp_dsfmt_data, seed);
}


/* ran2専用の定義（define文は例外的に認める） */
#define IM1 2147483563
#define IM2 2147483399
#define AM (1.0/IM1)
#define IMM1 (IM1-1)
#define IA1 40014
#define IA2 40692
#define IQ1 53668
#define IQ2 52774
#define IR1 12211
#define IR2 3791
#define NTAB 32
#define NDIV (1+IMM1/NTAB)
#define EPS 1.2e-7
#define RNMX (1.0-EPS)

double ran2(long *idum)
{
    int j;
    long k;
    static long idum2 = 123456789;
    static long iy = 0;
    static long iv[NTAB];
    double temp;

    if (*idum <= 0){
        if (-(*idum) < 1){
            *idum = 1;
        }
        else{
            *idum = -(*idum);
        }
        idum2 = (*idum);
        for (j = NTAB+7; j >= 0; j--){
            k = (*idum) / IQ1;
            *idum = IA1 * (*idum - k * IQ1) - k * IR1;
            if (*idum < 0){
                *idum += IM1;
            }
            if (j < NTAB){
                iv[j] = *idum;
            }
        }
        iy = iv[0];
    }
    k = (*idum) / IQ1;
    *idum = IA1 * (*idum - k * IQ1) - k * IR1;
    if (*idum < 0){
        *idum += IM1;
    }
    k = idum2 / IQ2;
    idum2 = IA2 * (idum2 - k * IQ2) - k * IR2;
    if (idum2 < 0){
        idum2 += IM2;
    }
    j = iy / NDIV;
    iy = iv[j] - idum2;
    iv[j] = *idum;
    if (iy < 1){
        iy += IMM1;
    }
    if ((temp = AM * iy) > RNMX){
        return RNMX;
    }
    else{
        return temp;
    }
}
