/************************************************************************/
/************************************************************************/
#ifndef __HEADER_FILE_MEMORY_CONTROL__
#define __HEADER_FILE_MEMORY_CONTROL__

/* malloc-free回数カウント */
static int malloc_count = 0;

/* プロトタイプ宣言 */
/* 1次元配列のメモリ確保 */
void *malloc1Dim(int size, int dim1);

/* int型の2次元配列のメモリ確保 */
void **mallocInt2Dim(int dim1, int dim2);
/* char型の2次元配列のメモリ確保 */
void **mallocChar2Dim(int dim1, int dim2);
/* double型の2次元配列のメモリ確保 */
void **mallocDouble2Dim(int dim1, int dim2);

/* int型の3次元配列のメモリ確保 */
void ***mallocInt3Dim(int dim1, int dim2, int dim3);


/* 1次元配列のメモリ開放 */
void free1Dim(void *array);

/* int型2次元配列のメモリ開放 */
void freeInt2Dim(int **array, int dim1);
/* char型2次元配列のメモリ開放 */
void freeChar2Dim(char **array, int dim1);
/* double型2次元配列のメモリ開放 */
void freeDouble2Dim(double **array, int dim1);

/* int型の3次元配列のメモリ開放 */
void freeInt3Dim(int ***array, int dim1, int dim2);


/* molloc_countを返す */
int getMallocCount();

#endif /* __HEADER_FILE_MEMORY_CONTROL__ */
