package sequence;

public class mutKimura2 extends simple_mut { 
    double rho; // ts/tv
    double a, b;

    public mutKimura2(double tstv){
        contents = new double [4];
        //  under Kimura's 2 parameter model
        for(int i=0;i<4;i++) contents[i] = (double) 0.25;
        char tmp[] = {'t','c','a','g'};
        rho = tstv;
        numnuc = tmp;
        // Kimura 1980
        a = rho/(1+rho);
        b = 0.5/(1+rho);
/*Jan 21*/
//        a = (1+rho)/(2+rho);
//        b = 1/(2+rho);
//        b = b/2;
    }
 
    public char mutate(double T_v,char c0){ 
        int mut;
        double P,Q,same;

//        System.out.println(T_v*100);

        int nucNo,LEN;
        LEN = numnuc.length;
        for(nucNo=0;nucNo<LEN;nucNo++){
             if (numnuc[nucNo]==c0) break;
        }

        double p[] = new double[LEN];   // next content
        // under Kimura 2 parameter (Kimura 1980)
        //transition type
//                    System.err.print(T_v);
//                    System.err.print('\t');
        P = 0.25-0.5*Math.exp(-4*(a+b)*T_v)+0.25*Math.exp(-8*b*T_v);
        //transversion type
        Q = 0.25-0.25*Math.exp(-8*b*T_v);
/*
                    System.out.print(P);
                    System.out.print(',');
                    System.out.println(Q);
*/
        same = 1 - P - 2*Q;

        for(int i=0;i<LEN;i++) p[i]=Q;  // for simplification
        p[nucNo] = same;
        p[transitionType(c0)] = P;  //transition
//                    System.err.println(P);
        // dis.value() returns discrete ramdom number.
        mut = dis.value(p);
        return( numnuc[mut] );
    }
 
    static int transitionType(char c0){ 
//        char tmp[] = {'t','c','a','g'};
        if(c0=='U'||c0=='u') return 1;
        if(c0=='T'||c0=='t') return 1;
        if(c0=='C'||c0=='c') return 0;
        if(c0=='A'||c0=='a') return 3;
        if(c0=='G'||c0=='g') return 2;
        return -1;
    }
 
    static boolean isPu(char c){  //Purine 
        if(c=='A'||c=='a') return true;
        if(c=='G'||c=='g') return true;
        return false;
    }
 
    static boolean isPy(char c){ //Pyrimidine 
        if(c=='T'||c=='t') return true;
        if(c=='U'||c=='u') return true;
        if(c=='C'||c=='c') return true;
        return false;
    }
 
    static boolean isTs(char c1,char c2){  //Purine 
        if (c1==c2) return false;
        if ( isPu(c1)&&isPu(c2) ) return true;
        if ( isPy(c1)&&isPy(c2) ) return true;
        return false;
    }
 
    static boolean isTv(char c1,char c2){  //Purine 
        if (c1==c2) return false;
        if ( isTs(c1,c2) ) return false;
        return true;
    }
    
    public boolean isDNA(){
    	return true;
    }
}
  
