package node;
import java.awt.*; 
import java.io.*;
import java.util.*;

import parameters.parameters;

public class node0 implements Cloneable{ 
    public int MinNo;
    public int No;
    public int NoChildren;
    public node0 branch1, branch2, parent;
    public String name;
    public Point begin;
    public Point end;


    node0(){ 
        MinNo=0;
        No=0;
        NoChildren = 1;
        branch1 = branch2 = parent = null;
        name = "#";//String.valueOf( No );
        begin = new Point(0,0);
        end = new Point(0,0);
    }
 
    node0(int no){ 
        MinNo=no;
        No=no;
        NoChildren = 1;
        branch1 = branch2 = parent = null;
        name = String.valueOf( No );
        begin = new Point(0,0);
        end = new Point(0,0);
    }
 
    node0(node0 child1, node0 child2){ 
        if (child1.MinNo<child2.MinNo){
            branch1 = child1;
            branch2 = child2;
        } else {
            branch1 = child2;
            branch2 = child1;
        }
        branch1.parent = branch2.parent = this;
        MinNo = branch1.MinNo;
        No = -1; // internal node
        NoChildren = branch1.NoChildren + branch2.NoChildren;
        name = String.valueOf( No );
        begin = new Point(0,0);
        end = new Point(0,0);
    }
 
    node0(node0 org){ 
        MinNo=org.MinNo;
        No=org.No;
        NoChildren = org.NoChildren;
        branch1 = org.branch1;
        branch2 = org.branch2;
        parent = org.parent;
        name = org.name;
        begin = new Point(0,0);
        end = new Point(0,0);
    }

    public static int compareTreeAssumingRootAs0(parameters param, node tree1, node tree2){ 
    	node rooted1 = tree1.setRoot(0);
    	node rooted2 = tree2.setRoot(0);
    	if(param.compareMethod.equals("exact")){
    		if (node0.IsSame(rooted1,rooted2) ) return 1;
    		return 0;
    	}else{
    		return node0.RzhetskyNei92(rooted1, rooted2);
    	}
    }
 
    public static boolean IsSame(node0 tree1, node0 tree2){ 
        if ( (tree1 == null) && (tree2 == null) ) {
        	System.err.println("both null");
        	return true;  // no comparison
        }
        if ( (tree1 == null) || (tree2 == null) ) return false; // one of ... (xor)
        if (tree1.NoChildren != tree2.NoChildren ) return false; // diffrent offspring
        if (tree1.MinNo != tree2.MinNo ) return false;
        if ( (tree1.isTip() ) && (tree1.No==tree2.No) ){
        	return true;
        }
        return ( IsSame(tree1.branch1, tree2.branch1) && IsSame(tree1.branch2, tree2.branch2) );
    }
 
    public void setParent(node0 p0) { 
        parent = p0;
    }
 
    public int min(){ 
        if (branch1==null) return MinNo;
        if (branch2==null) return branch1.min();
        int m = branch1.min();
        int m2 = branch1.min();
        if (m>m2 ) m = m2;
       return m;
    }
 
    public boolean isTip(){ 
        if ( (branch1==null) || (branch2==null) ) return true;
        return false;
    }

 
    public void connect(node0[] list){ 
        int target;
        if (branch1==null) return ;
        if (branch1.isTip()){
            target = branch1.No;
            if ( 0<=target && target<list.length){
                if (list[target]!=null) branch1 = list[target];
                branch1.setParent(this);
                list[target] = null;
            }
        }else{
            branch1.connect(list);
        }

        if (branch2==null) return ;
        if (branch2.isTip()){
            target = branch2.No;
            if ( 0<=target && target<list.length){
                if (list[target]!=null) branch2 = list[target];
                branch2.setParent(this);
                list[target] = null;
            }
        }else{
            branch2.connect(list);
        }
    }

    
	public static int RzhetskyNei92AssumingRootAs0(node tree1, node tree2){
    	node rooted1 = tree1.setRoot(0);
    	node rooted2 = tree2.setRoot(0);

        return RzhetskyNei92(rooted1,rooted2); // success
    }
	
	public static int RzhetskyNei92(node tree1, node tree2){
		int same=0;
		String[][] taxa1 = tree1.all_taxa();//Taxa are sets of taxa (tautology) 
		int branchNumber = taxa1.length;
		String[][] taxa2 = tree2.all_taxa();//A taxon is a set of species 
		if(branchNumber!=taxa2.length) return -1; // different dataset
		for(int i=0;i<taxa1.length;i++){
			for(int j=0;j<taxa2.length;j++){
				if( sameTaxa(taxa1[i],taxa2[j]) ){
					same++;
				}
			}
		}
		return (branchNumber-same)*2; //Rzhetsky and Nei 1992
	}
	
	public static boolean sameTaxa(String[] taxon1, String[] taxon2){
        Hashtable<String, Integer> H = new Hashtable<String, Integer>();
        for(int i=0;i<taxon1.length;i++){
        	H.put(taxon1[i], 1); // ł
        }
        for(int i=0;i<taxon2.length;i++){
        	if( !H.containsKey(taxon2[i]) ){
        		return false; 
        	}else{
        		H.remove(taxon2[i]);
        	}
        }
        if ( H.isEmpty() ) return true;
		return false;
	}
 
    boolean isData(){ return false;} 
 
    public void setLociNo(int lociNo){} // do nothing 
 
    public void recount(){ 
        if ( isTip() ) {
            NoChildren =1;
            MinNo = No;
        } else {
            branch1.recount();
            branch2.recount();
            NoChildren = branch1.NoChildren + branch2.NoChildren ;
            node0 swap;
            if (branch2.MinNo<branch1.MinNo){
                swap = branch1;
                branch1 = branch2;
                branch2 = swap;
            }
            MinNo = branch1.MinNo;
        }
    }

     public void setName(String Name0){ 
        name=Name0;
    }

    public boolean isLeaf(){ 
        if( branch1==null ) return true;
        if( branch2==null ) return true;
        return false;
    }

    public int[] order(){ 
        int [] result;
        if( isLeaf() ){
            result = new int[1];
            result[0]=No;
            return result;
        }
        int   n1 = branch1.NoChildren;
        int[] o1 = branch1.order();
        int   n2 = branch2.NoChildren;
        int[] o2 = branch2.order();

        result = new int[n1+n2];
        for(int i=0;i<n1;i++)   result[i]    = o1[i];
        for(int i=0;i<n2;i++)   result[i+n1] = o2[i];
        return result; 
    }
} 
  

