package main;

//2009 june 10

import java.io.*;

import parameters.parameters;
import modelTree.ModelTree;
import node.*;
import distanceManager.*;
import weight.*;
import nj.*;
import output.*;
import io.SequenceLoad;
import java.util.Vector;

public class MisawaTajima{   // class for initializing parameters 
 
    public static void main(String args[]) throws FileNotFoundException,IOException { 
    	//p[^߂
    	parameters params = new parameters(args);
    	if ( params.inputFromFile ){ // reconstructing tree
    		reconstruct(params);
    	}else{ // simulation
    		simulation(params);
    	}
    }
    
    public static void reconstruct(parameters params){
    	String[][] seq = null;
    	//zload
    	try{
    		seq = SequenceLoad.sequences(params);
    	}catch(Exception e){
    		System.out.println(e.getMessage());
    		return;
    	}
    	if(params.compareMethod.equals("sequence")){ // zo
    		SequenceLoad.output(seq,params);
    	}else{ //n쐬
        	//pairwisedistancevZ
        	mat[] matArr = new mat[params.loci];
        	for(int i=0;i<params.loci;i++){
            	matArr[i] = mat.distanceMatrix(params,seq[i]);
        	}
        	//EGCg,IɑIԁB
            weight n = weight.chooseWeight(params);
            // show optionŃEGCg\
            if( (n.name().equals("TT0")) &&(params.compareMethod.equals("show"))){
            	double[][][] weight = n.W(matArr);
            	for(int i=0;i<weight.length;i++){
            		System.out.print(params.fileName[i+1]);
            		System.out.print("\t");
            		System.out.print(seq[i][0].length());
            		System.out.print("\t");
            		System.out.println(weight[i][0][1]);
            	}
            }
            //n쐬
            //ʂ̌nresultTree
            node resultTree=null;
            try{
                double[][] d = n.d(matArr);
                //n쐬
                resultTree =  make_tree.nj( d );
                //OTU̖OĂ
                node.putName(resultTree,params.OTUName);
            }catch(ArrayIndexOutOfBoundsException e){
        		System.out.println("Failed to reconstruct tree.");
            	return;
            }
            //ʂ̌nStringɂ̂resultString
    		String resultString = resultTree.unrootedTreeToString();
            //Bootstrapő̌nAbootTreesɊi[
    		Vector<String> bootTreesBuffer = new Vector<String>();
    		for(int k=0;k<params.trial;k++){
            	//bootstrap
            	String[][] bootSeq = SequenceLoad.bootStrap(seq, params);
            	//pairwisedistancevZ
            	for(int i=0;i<params.loci;i++){
                	matArr[i] = mat.distanceMatrix(params,bootSeq[i]);
            	}
            	//EGCg,IɑIԁB
                n = weight.chooseWeight(params);
                node bootTree=null;
                try{
                    double[][] d = n.d(matArr);
                    //n쐬
                    bootTree =  make_tree.nj( d );
                    //OTU̖OĂ
                    node.putName(bootTree,params.OTUName);
                    bootTreesBuffer.add(bootTree.unrootedTreeToString());
                }catch(ArrayIndexOutOfBoundsException e){
                }
            }
    		String[] bootTreesArray = new String[bootTreesBuffer.size()];
    		bootTreesBuffer.copyInto(bootTreesArray);
    		System.out.println(ManyTrees.bootStrap(resultString, bootTreesArray, params));
    	}
    }
    
    public static void simulation(parameters params){
    	//vpӂ
    	stas stas = new stas();
    	//paramsɎw肳ꂽ񐔂loop
    	for(int trial=0;trial<params.trial;trial++){
        	//`q̐ɍ킹Čnp
        	seq_node[] org = new seq_node[params.loci];
        	//`q̐̕V~[V̌ɂȂn
        	for(int i=0;i<params.loci;i++){
            	org[i] = ModelTree.newTree(params);
        	}
        	//org.show3();
        	//`qƂɌnɍ킹ăV~[VszQbg
        	String[][] seq = new String[params.loci][];
        	for(int i=0;i<params.loci;i++){
            	seq[i] = seq_node.generateSequences(org[i]);
        	}
            //pairwisedistancevZ
        	mat[] matArr = new mat[params.loci];
        	for(int i=0;i<params.loci;i++){
            	matArr[i] = mat.distanceMatrix(params,seq[i]);
        	}
        	//EGCg,IɑIԁB
            weight n = weight.chooseWeight(params);
            try{
                double[][] d = n.d(matArr);
                //n쐬
                node resultTree =  make_tree.nj( d );
                //nrďo
//                System.out.println(node.compareTreeAssumingRootAs0(params, org[0], resultTree));
                stas.sample(node.compareTreeAssumingRootAs0(params, org[0], resultTree));
            }catch(ArrayIndexOutOfBoundsException e){
//            	stas.noData();
            }
    	}
        output(params,stas);
    }
    
    public static void output(parameters params, stas stas){
   		System.out.print(params.toString());
		System.out.print("\t");
		System.out.print(stas.mean());
		System.out.print("\t");
		System.out.print(stas.SD());
		System.out.print("\t");
		System.out.println();
    }
} 
