package distanceManager;

import distance.*;
 
public class mat_K2 extends mat_JC{ 
	
    public void init_mat(int size){ 
    	distance = new dis[size][size];
        for (int i=0;i<size;i++) distance[i][i] = new Kim2_dis();
        for (int i=0;i<size-1;i++){
            for (int j=i+1;j<size;j++){
                distance[i][j] = distance[j][i] =  new Kim2_dis();  //the same object
            }
        }
    }
 
    public double rho(){ 
        double r,S,T;
        r=1;
        S=T=0;
        int size=distance.length;
        for (int i=0;i<size-1;i++){
            for (int j=i;j<size;j++){
                S += ((Kim2_dis) distance[i][j]).S; //transitional
                T += ((Kim2_dis) distance[i][j]).T; //transversional
            }
        }
//*4mar*/System.out.print(S*2/(size-1)/(size));
//*4mar*/System.out.print(",");
//*4mar*/System.out.print(T*2/(size-1)/(size));
//*4mar*/System.out.print(",\t");
        if(T>0) r = S/T;
        return r;
    }
 
    public double wa(){ //arithmetic mean 
        int size=distance.length;
        int count=0;
        double w,d1,d2,V1,V2,cov;
        w=0;d1=0;d2=0;V1=0;V2=0;cov=0;
        for (int i=0;i<size-1;i++){
            for (int j=i;j<size;j++){
                d1 = ((Kim2_dis) distance[i][j]).d1; //transitional
                V1 = ((Kim2_dis) distance[i][j]).Vd1(); //transitional
                d2 = ((Kim2_dis) distance[i][j]).d2; //transversional
                V2 = ((Kim2_dis) distance[i][j]).Vd2(); //transitional
                cov = ((Kim2_dis) distance[i][j]).covd1d2();
                if((d1*V2-d2*cov)>0){
                    w += (d2*V1-d1*cov)/(d1*V2-d2*cov);
                    count++;
                }
            }
        }
//*4mar*/System.out.println(w/count);
        if(count>0) return w/count;
        return -1; // illegal
    }
 
    public double wh(){  //harmonic mean 
        int size=distance.length;
        int count=0;
        double w,d1,d2,V1,V2,cov;
        w=0;d1=0;d2=0;V1=0;V2=0;cov=0;
        for (int i=0;i<size-1;i++){
            for (int j=i;j<size;j++){
                d1 = ((Kim2_dis) distance[i][j]).d1; //transitional
                V1 = ((Kim2_dis) distance[i][j]).Vd1(); //transitional
                d2 = ((Kim2_dis) distance[i][j]).d2; //transversional
                V2 = ((Kim2_dis) distance[i][j]).Vd2(); //transitional
                cov = ((Kim2_dis) distance[i][j]).covd1d2();
                if((d2*V1-d1*cov)>0){
                    w += (d1*V2-d2*cov)/(d2*V1-d1*cov);
                    count++;
                }
            }
        }
//*4mar*/System.out.println(count/w);
        if(w>0) return count/w;
        return -1;
    }
 
    public double wm(){  //maximum 
        int size=distance.length;
        double max=0;
        double w,d1,d2,V1,V2,cov;
        w=0;d1=0;d2=0;V1=0;V2=0;cov=0;
        for (int i=0;i<size-1;i++){
            for (int j=i;j<size;j++){
                d1 = ((Kim2_dis) distance[i][j]).d1; //transitional
                V1 = ((Kim2_dis) distance[i][j]).Vd1(); //transitional
                d2 = ((Kim2_dis) distance[i][j]).d2; //transversional
                V2 = ((Kim2_dis) distance[i][j]).Vd2(); //transitional
                cov = ((Kim2_dis) distance[i][j]).covd1d2();
                w = (d2*V1-d1*cov)/(d1*V2-d2*cov);
                if(w>max) max=w;
            }
        }
        rho();
//*4mar*/System.out.println(max);
        return max;
    }
 
    public String name(){ 
        return "K2";
    }
 
} 
  

