package distance;

// superclass of estimator of distances
public abstract class dis{ 
    public double p; // proportion of difference  
    public double k; // number of substitutions per site
    public int len;  // sequence length
    public boolean set;
    public boolean existence;
    public static double[] UB;  //unbiased estimator
    public static double[][] UB2;  //unbiased estimator
    public double[] unbiased;
	
    public String name() {return "ab";} 
 
    public dis(){ 
        p=0.0; k=0.0; len=1; set=false; existence = false;
    }
 
    public double k() throws ArithmeticException { 
        if ( ! existence ) return Double.NaN;
        return k;
    }
    public double p() throws ArithmeticException { 
        if ( ! existence ) return Double.NaN;
        return p;
    }
    public int len(){ 
        return len;
    }
 
    void set_len(int len0) throws ArithmeticException{ 
        len = len0;
        set = true;
    }

    public boolean exist(){ return existence; }

    public boolean isComparable(String data1, String data2){ 
        if(data1.length()<=0||data2.length()<=0) return false;
        if(data1.length()==data2.length()) return true;
        return false;
    }

    abstract public double dk(); 
    abstract public double dp(); 
    abstract public void set_seq(String seq1, String seq2) throws ArithmeticException ; 
    abstract public double Vk() ; 
    abstract public double Vkinv() ; 
    abstract public double Vp() throws ArithmeticException;
}
