package distance;

public class JC_dis extends Poi_dis{ 
	
    public static final double C = 0.75; 
 
    public String name() {return "JC";} 
 
    double unbiased(int P,int seq_len) { 
        UB2 = TableMan.init_2D(seq_len,P,UB2);
        if (UB2[seq_len][P]<0){ // if not initialized, calculate.
            double total=0;
            for(int j=1;j<=P;j++){
                double ln = 1;
                ln = fact.lnP(P,j) - ( Math.log(j) +  (j-1) * Math.log(C) + fact.lnP(len,j) ); //tajima 1993
                total += Math.exp( ln );  // to avoid overflow
            }
            if( Double.isNaN(total)||Double.isInfinite(total) ){ //inapplicable
                System.err.println("out of range");
                double q = ((double) P) / ((double) seq_len);
                total = - C*Math.log(1-q/C);
            }
            UB2[seq_len][P]=total;
        }
        return UB2[seq_len][P];
    }
 
    public double dk() { 
        if(!set) throw new ArithmeticException("JC: not set yet!");
        return C/(C-p); // biased!?
    }
 
    public double dp() { 
        if(!set) throw new ArithmeticException("JC: not set yet!");
        return (p-C)/C; // unbiased
    }
    public double Vp() throws ArithmeticException { 
        if(!set) throw new ArithmeticException("not set yet!");
        return p*(1-p)/len;
    }

}
  

