package distance;

/**/ 
  
public class GP_K extends Kim2_dis{ 
    public double T2;
    double rho2,vs,vt,cv;
    Kim2_dis org;
	
    public GP_K(double r2, Kim2_dis org0){ 
        rho2 = r2;
        org = org0;
        set =true;


//        System.err.print( "GPcon" ); // a/a^2

    }
 
    double covST2(){ 
        if(!set) throw new ArithmeticException("GP: not set yet!");
        return rho2*org.covST();
        // Pollock and Goldstein 1995
    }
 
    double VT2(){ 
        if(!set) throw new ArithmeticException("GP: not set yet!");
       return rho2*rho2* org.VT();
    }
 
    double S2(){ 
       return org.S;
    }
 
    double T2(){ 
       return rho2*org.T;
    }
 
    double VS2(){ 
        if(!set) throw new ArithmeticException("GP: not set yet!");
//        System.err.print(org.VS());
        return org.VS();
    }
 
    public double k() throws ArithmeticException { 
        vs=VS2();
        vt=VT2();
        cv=covST2();
        if(T2()==0) return S2();  // the same expectation
        if(S2()==0) return T2();  // the same expectation
        if ( (vs-2*cv+vt)==0) return 0;
//June10
//        System.out.println(S2()+","+T2()+","+ ( (vt-cv)*S2()+(vs-cv)*T2() ) / (vs-2*cv+vt));
/**/
        return ( (vt-cv)*S2()+(vs-cv)*T2() ) / (vs-2*cv+vt); // a/a^2
       // Goldstein and Pollock 1994
    }
 
    public double Vk() throws ArithmeticException { 
        vs=VS2();
        vt=VT2();
        cv=covST2();
        if(T2()==0) return VS2();  //
        if(S2()==0) return VT2();  // see k();
        if ( (vs-2*cv+vt)==0) return 0;
        return (vs*vt-cv*cv) / (vs-2*cv+vt); // a/a^2
       // Goldstein and Pollock 1994
    }


/*352
V[S(vt-cv)+T(vs-cv)]
=vs*(vt-cv)*(vt-cv) + vt*(vs-cv)*(vs-cv) +2*(vs-cv)*(vt-cv)*cv
= vs*vt*vt - 2*vs*vt*cv + vs*cv*cv
+ vt*vs*vs - 2*vs*vt*cv + vt*cv*cv
+ 2*vs*vt*cv - 2*(vs+vt)*cv*cv + 2*cv*cv*cv
= 2*cv*cv*cv - (vs+vt)*cv*cv - 2*vs*vt*cv + (vs+vt)*vs*vt
= cv*cv*(2*cv - (vs+vt)) - vs*vt*(2*cv - (vs+vt))
= (cv*cv-vs*vt)(2*cv - (vs+vt))
= (vs*vt-cv*cv)(vs-2*cv+vt)
*/
 
    public String name(){ return ("GP"); } 
}
  

