#include <stdio.h>
#include <stdlib.h>

#include "snp_Config.h"
#include "snp_MemoryControl.h"
#include "snp_TypeI.h"
#include "snp_Chi.h"

#define LENGTH 5

void TypeIMain()
{
    int m = 0;
    int n = 0;
    int sampleSize = 1000;
    int burnin = 0;
    int copyNumber = 0;
    int L = 0;
    int **X = NULL;

    double total = 0;
    double diff = 0;
    double gen = 1000000;

    double h[LENGTH] = {0.5252, 0.1902, 0.1776, 0.042, 0.065};
    L = LENGTH;

    for (burnin = 0; burnin < 1 + gen * 0; burnin += 100000){
        copyNumber = sampleSize * 2;

        /* m */
        X = (int**)mallocInt2Dim(2, L);
        if (NULL == X) { goto finalize; }

        /* procedure 2 */
        TypeIStartSet(sampleSize, L, X[0]);
        TypeIStartSet(sampleSize, L, X[1]);
        ChiSetSigniDiff(sampleSize * 2);

        /* start Markov */
        /* burn in */
        for (m = 0; m < burnin; m++){
            TypeIMarkov(X, h, L);
        }

        for (n = 0; n < 200; n++){
            for (m = 0; m < gen; m++){
                total++;
                TypeIMarkov(X, h, L);
                if (ChiIsSigniDiff(X, L) == FLAG_TRUE){
                    diff++;
                }
            }
            printf("%d\t%d\t%d\t%lf\n", sampleSize, copyNumber, burnin, diff/total);
        }
    }

finalize:;
    /* mۂJ */
    freeInt2Dim(X, 2);
    ChiDeleteSigniDiff();
    return;
}

void TypeIMarkov(int **X, double *h, int L)
{
    int j = 0;
    int u = 0;
    int v = 0;
    int XjuStar = 0;
    int XjvStar = 0;

    double c = 0;
    double tmp = 0;

    /* procedure 3 */
    j = TypeIZeroOne();

    /* procedure 4 */
    u = (int)(ran2(&idum) * L);

    if (0 == X[j][u]){ /* condition 5 */
        /* invariant */
    }
    else{ /* condition 6 */
        v = 0;
        do{
            v = (int)(ran2(&idum) * L);
        } while(u == v);
        
        /* new candidate */
        XjuStar = X[j][u] - 1;
        XjvStar = X[j][v] + 1;

        /* transition probability */
        c = h[v] * X[j][u] / (h[u] * (X[j][v] +1));

        if (c >= 1){ /* condition 8 */
            X[j][u] = XjuStar;
            X[j][v] = XjvStar;
        }
        else{
            tmp = ran2(&idum);
            if (tmp < c){
                X[j][u] = XjuStar;
                X[j][v] = XjvStar;
            }
        }

        /* procedure 10 */
    }
}

int TypeIStartSet(int sampleSize, int L, int *result)
{
    int i = 0;
    int sum = 0;

    do{
        sum = 0;
        for (i = 0; i < L-1; i++){
            result[i] = (int)(ran2(&idum) * sampleSize);
            sum += result[i];
        }
    } while(sum > sampleSize);
    result[L-1] = sampleSize-sum;

    return 0;
}

int TypeIZeroOne()
{
    /* return 0 or 1 with probability 0.5 */
    int result = 0;

    result = (int)(ran2(&idum) * 2);

    return result;
}

