/************************************************************************/
/************************************************************************/
#ifndef __HEADER_FILE_RAT__
#define __HEADER_FILE_RAT__

#include "snp_Config.h"
#include "snp_DataReader.h"
#include "snp_MemoryControl.h"
#include "snp_Table.h"
#include "snp_Factorial.h"
#include "snp_Permutation.h"
#include "snp_Random.h"


/* ̓f[^i[p\ */
typedef struct struct_InputDataForRAT {
    char inputFile1[MAX_LEN];   /* ̓t@C */
    char inputFile2[MAX_LEN];   /* ̓t@C */
    char outputFile1[MAX_LEN];  /* o̓t@C */
    int areaFileType;           /* ̈wt@C̃^Cv */
    char blockAreaFile[MAX_LEN];/* haplotypeubN̈wt@C */
    int score;                  /* XRAvZ@̎w */
    long gen;                   /* MCMC㐔 */
    long burnin;                /* OMCMC */
    int dataType;               /* ̓f[^tH[}bg̎w */
} InputRAT;


/* RATPermutations */
void MainProgramRAT(InputRAT *inputRAT);
/* RATPermutations */
double RATExecute(SnpData *snpData1, SnpData *snpData2, double Sobs, long a, long b, long jStart, long jEnd, long gen, long burnin);
/* }[J[jnumberOfDiInHj[j]ɔႵmŕԂ */
long RATAlgorithmA(double *numberOfDiInHj, long m);
/* 􉽕zɏ]MCMCŁAȑÕe[v玟̃e[v쐬 */
int RATAlgorithmB(SnpTable T, double Score, int **table);
/* 􌻕\Ppermutation event𓙊mŒo */
int RATAlgorithmC(int *genotype, int **table, int *di);
/* Q̒lvZ */
long RATCalcQvalue(int **genotype, int *di, double Sobs, long n, long dataNum);
double RATNumberOfDiInHj(SnpTable table, double Sobs);
/* genotypevZ */
int RATGenotype(SnpData *snpData1, SnpData *snpData2, int *genotype);

#endif /* __HEADER_FILE_RAT__ */
