#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "snp_Allele.h"

extern double ChiTest_threshold; // d.f.=1, p=1%
double ChiTestChiSquare1(int A, int B, int C, int D);

void AlleleInit(Allele* p_struct, char** haplotype, int haplotype_num, int samplesize){

  int i, j;
  unsigned int k;
  int* count;
  char c, d, major;
  int max = 0, maxk = 0;
  char* nucleotide;

//    threshold = 6.635; // d.f.=1, p=1%
//  public static double threshold = 20.08; // d.f.=8, p=1%

  p_struct->num = samplesize;
  nucleotide = "ATGC";

  p_struct->state = (int**)malloc(sizeof(int*)*haplotype_num);
  if(NULL == p_struct->state) goto allocateerror;

  for(i = 0; i < haplotype_num; i++) {
    p_struct->state[i] = (int*)malloc(sizeof(int)*strlen(haplotype[0]));
    if(NULL == p_struct->state[i]) goto allocateerror;
  }
  for(i=0;i<(int)strlen(haplotype[0]);i++){
    count = (int*)malloc(sizeof(int)*strlen(nucleotide));
    if(NULL == count) goto allocateerror;
    for(j=0;j<haplotype_num;j++){
      c = haplotype[j][i];
      for(k=0; k<strlen(nucleotide);k++){
        d = nucleotide[k];
        if(c==d) count[k]++;
      }
    }
    max = 0; maxk = 0;
    for(k=0;k<strlen(nucleotide);k++){
      if(max < count[k]){
        max = count[k];
        maxk = k;
      }
    }
    major = nucleotide[maxk];
    for(j=0;j< haplotype_num;j++){
      c = haplotype[j][i];
      if(c == major){
        p_struct->state[j][i] = 1;
      }else{
        p_struct->state[j][i] = 0;
      }
    }
    free(count);
  }
  return;

allocateerror:
  printf("memory allocate error!\n");
  exit(9);
}

void AlleleFinalize(Allele* p_struct, int haplotype_num){
  int i;
  for(i = 0; i < haplotype_num; i++) {
    free(p_struct->state[i]);
  }
  free(p_struct->state);
}

void AlleleShow(Allele* p_struct, int haplotype_num, int haplotype_length){
  int i, j;
  printf("Allele.show");
  for(i=0;i<haplotype_num;i++){
    for(j=0;j<haplotype_length;j++){
      printf(",%d", p_struct->state[i][j]);
    }
    printf("\n");
  }
}

int AlleleF(Allele* p_struct, int** X, int haplotype_num){
  int result = 0;
  int len = haplotype_num;
  int i;
  for(i=0;i<len;i++){ // for each locus
    if ( ChiTestChiSquare1(X[0][i], p_struct->num-X[0][i], X[1][i], p_struct->num-X[1][i]) > ChiTest_threshold ) result = 1;
  }
  return result;
}

