#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>

#include "snp_Factorial.h"
#include "snp_Allele.h"
#include "snp_Kuriage.h"
#include "snp_BunkaiOld.h"
#include "snp_MultiNomial.h"
#include "snp_Range.h"
#include "snp_DataReader.h"
#include "snp_MemoryControl.h"

/* m@ɂType I error̊mvZs */
double ExactExecute(double *h, char **haplotype, long L, long caseSample, long controlSample);

/* ̓f[^i[p\ */
typedef struct struct_InputDataForExact {
    char inputFile1[MAX_LEN];   /* ̓t@C */
    char inputFile2[MAX_LEN];   /* ̓t@C */
    char outputFile1[MAX_LEN];  /* o̓t@C */
    int areaFileType;           /* ̈wt@C̃^Cv */
    char blockAreaFile[MAX_LEN];/* haplotypeubN̈wt@C */
    int score;                      /* XRAvZ@̎w */
    int dataType;                   /* ̓f[^tH[}bg̎w */
} InputExact;


int main(int argc, char* argv[])
{
    int retval = 0;
    int flag = 0;
    long i = 0;
	long j = 0;
    long fileLine1 = 0; /* ̓t@C̃C */
    long fileLine2 = 0; /* ̓t@C̃C */
    long areaFileLine = 0; /* haplotypeubN̈wt@C̃C */
    long a = 0;
    long b = 0;
    long n = 0;
    long dataNum;       /* caseAcontrolf[^̑SNP */
    long index = 0;
    long jStart = 0;    /* haplotypeubN̍ŏSNP */
    long jEnd = 0;      /* haplotypeubN̍ŌSNP */
    long blockNum = 0;  /* HaplotypeubN */
    long repeat = 0;
    long startPos = 0;
    long endPos = 0;
    double S = 0;

    int **T = NULL;             /* 􌻕\ */
    int *populationType = NULL;
    long *L = NULL;             /* HaplotypeubNHaplotypep^[ */
    long *blockArea = NULL;     /* ehaplotypeubN̈i[ */
    long *linkSNPNum = NULL;    /* ehaplotypeubNSNP */
    long *linkSNPStart = NULL;  /* ehaplotypeubN̍ŏSNP */
    long *maxScoreIndex = NULL;  /* HaplotypeubÑXRAől̍ */
    char ***haplotype = NULL;    /* haplotypef[^ */
    double **h = NULL;        /* px */
    double *typeIError = NULL;  /* type I error i[z */
    double *Sobs = NULL;        /* HaplotypeubÑXRAől */

    FILE *fpCase = NULL;    /* ́icasejt@C|C^ */
    FILE *fpCntl = NULL;    /* ́icontroljt@C|C^ */
    FILE *fpOut = NULL;     /* o̓t@C|C^ */
    FILE *fpArea = NULL;    /* haplotypeubN̈wt@C|C^ */

    char *caseData = NULL;      /* Tvf[^icaseji[p */
    char *controlData = NULL;   /* Tvf[^icontrolji[p */

    SnpData *snpTmpData1 = NULL;
    SnpData *snpTmpData2 = NULL;
    SnpData *snpData1 = NULL;
    SnpData *snpData2 = NULL;


    InputExact inputExact={"", "", "", 0, 0, 0, 0};

    if(argc != 8){
        printf("[usage]main.exe [InputFile1] [InputFile2] [outputFile] [AreaFileType] [BlockAreaFile] [Score] [dataType] \n");
        return 255;
    }
    strcpy(inputExact.inputFile1, argv[1]);
    strcpy(inputExact.inputFile2, argv[2]);
    strcpy(inputExact.outputFile1, argv[3]);
    inputExact.areaFileType = atoi(argv[4]);
    strcpy(inputExact.blockAreaFile, argv[5]);
    inputExact.score = atoi(argv[6]);
    inputExact.dataType = atoi(argv[7]);

    /* t@CI[v */
    retval = InputFileOpen(&fpCase, inputExact.inputFile1);
    if (retval != 0){
        goto finalize;
    }
    retval = InputFileOpen(&fpCntl, inputExact.inputFile2);
    if (retval != 0){
        goto finalize;
    }
    retval = OutputFileOpen(&fpOut, inputExact.outputFile1);
    if (retval != 0){
        goto finalize;
    }
    retval = InputFileOpen(&fpArea, inputExact.blockAreaFile);
    if (retval != 0){
        goto finalize;
    }

/****************************************************************/
/* f[^                                                   */
/****************************************************************/
 
    /* haplotypeubN̈wt@C̃C擾 */
    areaFileLine = DataReaderCountFileLine(fpArea);
    /* haplotypeubN̈i[pz̃m */
    blockArea = (long*)malloc1Dim(sizeof(long), areaFileLine);
    if (NULL == blockArea){ goto finalize; }
    /* t@C|C^擪ɖ߂ */
    fseek(fpArea, 0L, SEEK_SET);
    /* haplotypeubN̈zɎ߂ */
    DataReaderSetHaplotypeBlockArea(fpArea, blockArea);

    /* ̓t@C̃C擾 */
    fileLine1 = DataReaderCountFileLine(fpCase);
    fileLine2 = DataReaderCountFileLine(fpCntl);

    /* t@C|C^擪ɖ߂ */
    fseek(fpCase, 0L, SEEK_SET);
    fseek(fpCntl, 0L, SEEK_SET);

    /* f[^ꎞi[p\̂̃m */
    snpTmpData1 = (SnpData*)malloc1Dim(sizeof(SnpData), fileLine1);
    snpTmpData2 = (SnpData*)malloc1Dim(sizeof(SnpData), fileLine2);

    /* f[^t@Cǂݍݍ\̂Ɏ߂ */
    DataReaderSetAllData(fpCase, snpTmpData1, fileLine1, inputExact.dataType);
    DataReaderSetAllData(fpCntl, snpTmpData2, fileLine2, inputExact.dataType);

    /* ̓f[^̐`FbNĕ񉻗p̓̓f[^쐬 */
    /* MPI_Bcast̉񐔂炷߂ɃTvf[^͕ʔzicaseData, controlDatajŕێ */
    dataNum = DataReaderMakeParallelData(snpTmpData1, snpTmpData2, fileLine1, fileLine2, &snpData1, &snpData2, &caseData, &controlData);

    /* gpȂz̃J */
    /* \SnpDataõJ */
    DataReaderSnpDataMemoryFree(snpTmpData1, fileLine1);
    DataReaderSnpDataMemoryFree(snpTmpData2, fileLine2);
    snpTmpData1 = NULL;
    snpTmpData2 = NULL;

    /* ̓f[^̃Tv擾 */
    a = snpData1[0].dataNum;
    b = snpData2[0].dataNum;
    n = a + b;

    /* \SnpDataɃTvf[^Rs[ */
    DataReaderDataCopyToSnpData(snpData1, caseData, dataNum, a);
    DataReaderDataCopyToSnpData(snpData2, controlData, dataNum, b);

/****************************************************************/
/* m                                                   */
/****************************************************************/

    /* haplotypeubN */
    if (inputExact.areaFileType == 0){
        blockNum = areaFileLine - 1;
    }
    else {
        /* haplotypeubŇvZ */
        if (blockArea[0] > dataNum){
            blockNum = 1;
            blockArea[1] = dataNum; /* linkSNPNum̒lf[^ɂȂ */
        }
        else{
            blockNum = (dataNum - (blockArea[0] - blockArea[1]) ) / blockArea[1];
        }
    }
    /* ehaplotypeubN̈SNPi[pz̃m */
    linkSNPNum = (long*)malloc1Dim(sizeof(long), blockNum);
    if (NULL == linkSNPNum){ goto finalize; }
    /* ehaplotypeubN̈̍ŏSNPʊi[pz̃m */
    linkSNPStart = (long*)malloc1Dim(sizeof(long), blockNum);
    if (NULL == linkSNPStart){ goto finalize; }

    /* ehaplotypeubN̈ɊYSNPf[^ */
    if (inputExact.areaFileType == 0){
        for (i = 0; i < blockNum; i++){ /* Ä̏dꍇl */
            startPos = blockArea[i];
            endPos = blockArea[i+1];
            flag = 0;
            /* ̓f[^̓|WVŃ\[gĂƉ */
            for (j = 0; j < dataNum; j++){
                if (startPos <= snpData1[j].pos){
                    if (snpData1[j].pos < endPos){
                        /* ̈SNPJEg */
                        linkSNPNum[i]++;
                        /* ̈̍ŏSNPʂێ */
                        if (0 == flag ){
                            linkSNPStart[i] = j;
                            flag = 1;
                        }
                    }
                    /* ȍ~ÄɊYf[^͏oȂ̂Ŏ̃ubN𒲂ׂ */
                    else {
                        break;
                    }
                }
            }
        }
    }
    else {
        for (i = 0; i < blockNum; i++){
            linkSNPNum[i] = blockArea[0];
            linkSNPStart[i] = i * blockArea[1];
        }
    }

    /* 􌻕\T̃m */
    T = (int**)mallocInt2Dim(ROW, COLUMN);
    if (NULL == T){ goto finalize; }
    /* populationTypẽm */
    populationType = (int*)malloc1Dim(sizeof(int), n);
    if (NULL == populationType) { goto finalize; }
    /* type I error i[z̃m */
    typeIError = (double*)malloc1Dim(sizeof(double), blockNum);
    if (NULL == typeIError) { goto finalize; }
    /* haplotypef[^̃m */
    haplotype = (char***)malloc1Dim(sizeof(char**), blockNum);
    if (NULL == haplotype) { goto finalize; }
    /* p^[px̃m */
    h = (double**)malloc1Dim(sizeof(double*), blockNum);
    if (NULL == h) { goto finalize; }
    /* p^[̃m */
    L = (long*)malloc1Dim(sizeof(long), blockNum);
    if (NULL == L) { goto finalize; }
    /* HaplotypeubÑXRAől̍ʂ̃m */
    maxScoreIndex = (long*)malloc1Dim(sizeof(long), blockNum);
    if (NULL == maxScoreIndex) { goto finalize; }
    /* HaplotypeubÑXRAől̃m */
    Sobs = (double*)malloc1Dim(sizeof(double), blockNum);
    if (NULL == Sobs) { goto finalize; }

/****************************************************************/
/* m@ɂ錟菈                                         */
/****************************************************************/

    /* haplotypeubNPʂŃ[v */
    jStart = 0;
    for (i = 0; i < blockNum; i++){
        jStart = linkSNPStart[i];
        jEnd = jStart + linkSNPNum[i];
        /* ehaplotypeubNŃ[v */
        for (j = jStart; j < jEnd; j++){
            /* ϑl􌻕\쐬 */
            DataReaderPopulationType(&snpData1[j], &snpData2[j], populationType);
            DataReaderMakeTableDi(&snpData1[j], &snpData2[j], populationType, T);
            /* XRAvZ@XRAvZ0ɂȂĂ܂ꍇ-1Ԃ */
            S = TableCalcScore(T);
            /* őXRA肷 */
            if (S > Sobs[i]){
                Sobs[i] = S;
                maxScoreIndex[i] = j;
            }
        }
        /* eHaplotype̕pxvZ */
        L[i] = DataReaderHaplotypeFrequency(snpData1, snpData2, jStart, jEnd, &haplotype[i], &h[i]);

        /* m@ɂmvZ */
        typeIError[i] = ExactExecute(h[i], haplotype[i], L[i], a, b);

    }

/****************************************************************/
/* 茋ʏo                                                 */
/****************************************************************/

    index = 0;
    fprintf(fpOut, "CaseData    = %s\n", inputExact.inputFile1);
    fprintf(fpOut, "ControlData = %s\n", inputExact.inputFile2);
    fprintf(fpOut, "BlockArea\tSNPNum\trsNumber\tPosition\tScore\tTypeIerror\n");
    if (inputExact.areaFileType == 0){
        for (i = 0; i < blockNum; i++){
            if (Sobs[i] != 0){
                fprintf(fpOut, "%ld-%ld\t%ld\t%s\t%ld\t%.3e\t%.3e\n", 
                    blockArea[i],
                    blockArea[i+1],
                    linkSNPNum[i],
                    snpData1[ maxScoreIndex[i] ].rsNumber,
                    snpData1[ maxScoreIndex[i] ].pos,
                    Sobs[i],
                    typeIError[i]);
            }
            else {
                fprintf(fpOut, "%ld-%ld\t%ld\tNoData\n", 
                    blockArea[i],
                    blockArea[i+1],
                    linkSNPNum[i]);
            }
        }
    }
    else {
        for (i = 0; i < blockNum; i++){
            if (Sobs[i] != 0){
                fprintf(fpOut, "%ld-%ld\t%ld\t%s\t%ld\t%.3e\t%.3e\n", 
                    snpData1[ linkSNPStart[i] ].pos,
                    snpData1[ linkSNPStart[i] + linkSNPNum[i] - 1 ].pos,
                    linkSNPNum[i],
                    snpData1[ maxScoreIndex[i] ].rsNumber,
                    snpData1[ maxScoreIndex[i] ].pos,
                    Sobs[i],
                    typeIError[i]);
            }
            else {
                fprintf(fpOut, "%ld-%ld\t%ld\tNoData\n", 
                    snpData1[ linkSNPStart[i] ].pos,
                    snpData1[ linkSNPStart[i] + linkSNPNum[i] - 1 ].pos,
                    linkSNPNum[i]);
            }
        }
    }

/****************************************************************/
/* I                                                     */
/****************************************************************/

finalize:;
    /* t@CN[Y */
    FileClose(fpCase);
    FileClose(fpCntl);
    FileClose(fpOut);
    FileClose(fpArea);
    /* mۂJ */
    // haplotypeϐchar^̂Rz
    // e̗vf͔zL킩BlinkedSNPNumłB
    // p̊J̊֐쐬KvBƂ肠ʂfree
    for (i = blockNum-1; i >= 0; i--){
        for (index = L[i]-1; index >= 0; index--){
            free1Dim(haplotype[i][index]);
        }
        free1Dim(haplotype[i]);
    }
    free1Dim(haplotype);

    free1Dim(blockArea);
    free1Dim(linkSNPNum);
    free1Dim(linkSNPStart);
    free1Dim(typeIError);
    freeDouble2Dim(h,blockNum);
    freeInt2Dim(T, ROW);
    free1Dim(populationType);
    free1Dim(L);
    free1Dim(maxScoreIndex);
    free1Dim(Sobs);
    DataReaderSnpDataMemoryFree(snpTmpData1, fileLine1);
    DataReaderSnpDataMemoryFree(snpTmpData2, fileLine2);
    free1Dim(caseData);
    free1Dim(controlData);
    free1Dim(snpData1);
    free1Dim(snpData2);

    return;
}


/* m@ɂType I error̊mvZs */
double ExactExecute(double *h, char **haplotype, long L, long caseSample, long controlSample)
{
    Allele* A = NULL;
    int* X[2];
    double total=0.0;
    double result = -1.0;
    int* lower = NULL;
    int* upper = NULL;
    BunkaiOld* a = NULL;
    BunkaiOld* b = NULL;
 
    int samplesize = 5;
    int copyNumber = samplesize*2;
    int haba = 5; 
    int retval = 0;
    long i = 0;

    haba = (int)L;
    //case,controlŋʂKv
    samplesize = caseSample;
    copyNumber = caseSample + controlSample;

    X[0] = NULL;
    X[1] = NULL;

    A = (Allele*)malloc(sizeof(Allele));
    if(NULL == A) { goto finalize; }
    AlleleInit(A, haplotype, L, copyNumber);

    if(1 == FactorialSetFactorial(copyNumber+10)) { goto finalize; }

    lower = (int*)malloc(sizeof(int)*L);
    if(NULL == lower) { goto finalize; }
    upper = (int*)malloc(sizeof(int)*L);
    if(NULL == lower) { goto finalize; }
    for(i=0;i<L;i++){
	    //*
        lower[i] = RangeLowerLimit(copyNumber,h[i],haba);
        upper[i] = RangeUpperLimit(copyNumber,h[i],haba);
	    /*/
	    lower[i] = 0;
	    upper[i] = copyNumber;
	    /**/
    }

    a = (BunkaiOld*)malloc(sizeof(BunkaiOld));
    if(NULL == a) { goto finalize; }

    for( BunkaiOldInit(a, lower, L,upper,copyNumber); !(BunkaiOldDone(a)); BunkaiOldCount(a)){
        if(	BunkaiOldAllSum(a)==copyNumber) {
            b = (BunkaiOld*)malloc(sizeof(BunkaiOld));
            if(NULL == b) { goto finalize; }
            for( BunkaiOldInit(b, lower, L,upper,copyNumber); !(BunkaiOldDone(b)); BunkaiOldCount(b)){
                if( BunkaiOldAllSum(b)==copyNumber) {
                    /*
                    data = (int**)malloc(sizeof(int*)*2);
                    data[0] = BunkaiOldBunkai(a); // case
                    data[1] = BunkaiOldBunkai(b); // control
                    X[0]=data[0];
                    X[1]=data[1];
                    */
                    X[0]=BunkaiOldBunkai(a); // case
                    X[1]=BunkaiOldBunkai(b); // control
                    if ( AlleleF(A, X, L)==0 ){
                        //if ( ChiTest.significant2(samplesize,X,h)==0 ){
                        total+=MultiNomialMultinomialP2(copyNumber, X, L, h);
                    }
                }
            }
            BunkaiOldFinalize(b);
            free(b);
        }
    }
    BunkaiOldFinalize(a);

  printf("1-total=%g\n", 1.0-total);
    result = 1.0 - total;


finalize:;
    FactorialDeleteFactorial();
    if(A) AlleleFinalize(A, L);
    if(A) free(A);
    if(lower) free(lower);
    if(upper) free(upper);
    if(a) free(a);

    //printf("memory allocate error!\n");
    //exit(9);

    return result;

}
