#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "snp_Permutation.h"
#include "snp_Table.h"
#include "snp_Config.h"
#include "snp_MemoryControl.h"


void PermutationMain()
{
    int a1 = 66,        /* genotype1, case */
        a2 = 34;        /* genotype2, case */
    int b1 = 90,        /* genotype1, control */
        b2 = 10;        /* gneotype2, control */
    //int a1 = 155,        /* genotype1, case */
    //    a2 = 11;        /* genotype2, case */
    //int b1 = 88,        /* genotype1, control */
    //    b2 = 0;        /* gneotype2, control */
    int a = a1 + a2,    /* case ̍v */
        b = b1 + b2,    /* control̍v */
        n = a + b;      /* case,control̍v */

    int *genotype = NULL;       /* `q^ */
    int *type = NULL;           /* case ܂ control */
    int *observerOrder = NULL;  /* ώ@ꂽ */
    int **Tobs = NULL;          /* ϑn쐬􌻕\ */
    double Sobs = 0;            /* ϑl̋􌻕\̃XRA */

    int *omega = NULL;
    int *di = NULL;
    int tmp[] = {65, 67, 68};
    int tmp_length = 0;
    int *tmp2 = NULL;
    int **T = NULL;
    double S = 0;

    int repeat = 100;           /* permutation̉ */
    int count = 0;              /* permutatioňʂϑlz */
    int h = 0;
    int i = 0;
    int retval = 0;

    /* genotypẽm */
    genotype = (int*)malloc1Dim(sizeof(int), n);
    if (NULL == genotype) { goto finalize; }
    /* typẽm */
    type = (int*)malloc1Dim(sizeof(int), n);
    if (NULL == type) { goto finalize; }
    /* observerOrder̃m */
    observerOrder = (int*)malloc1Dim(sizeof(int), n);
    if (NULL == observerOrder){ goto finalize; }

    for (h = 0; h < n; h++){
        if ( (0 <= h) && (h < a1) ){
            genotype[h] = 1;
            type[h] = 1;
        }
        else if ( (a1 <= h) && (h < a) ){
            genotype[h] = 0;
            type[h] = 1;
        }
        else if ( (a <= h) && (h < a+b1) ){
            genotype[h] = 1;
            type[h] = 0;
        }
        else if ( (a+b1 <= h) && (h < n) ){
            genotype[h] = 0;
            type[h] = 0;
        }
        observerOrder[h] = h;
    }

    /* Tobs̃m */
    Tobs = (int**)mallocInt2Dim(ROW, COLUMN);
    if (NULL == Tobs){ goto finalize; }
    /* T̃m */
    T = (int**)mallocInt2Dim(ROW, COLUMN);
    if (NULL == T) { goto finalize; }

    /* ϑl􌻕\쐬 */
    retval = PermutationCalcT(type, genotype, Tobs, n);
    if (retval != 0){
        printf("can not create Tobs\n");
        return;
    }

    /* ϑl̋􌻕\̃XRA쐬 */
    Sobs = TableCalcScore(Tobs);

    /* omegãm */
    omega = (int*)malloc1Dim(sizeof(int), n);
    if (NULL == omega) { goto finalize; }
    /* dĩm */
    di = (int*)malloc1Dim(sizeof(int), n);
    if (NULL == di) { goto finalize; }
    /* tmp2̃m */
    tmp_length = (int)(sizeof(tmp) / sizeof(tmp[0]));
    tmp2 = (int*)malloc1Dim(sizeof(int), tmp_length);

    /* permutation */
    for (i = 0; i < repeat; i++){
        retval = PermutationCalcOmega(n, omega);
        if (retval != 0){
            printf("can not create omega\n");
            return;
        }
        retval = PermutationCalcDi(n, a, omega, di);
        //retval = PermutationCalcDi_multi(tmp, omega, di, tmp_length, n);
        if (retval != 0){
            printf("can not create di\n");
            return;
        }
        /* tmp2z0ŏ */
        for (h = 0; h < tmp_length; h++){
            tmp2[h] = 0;
        }

        for (h = 0; h < n; h++){
            tmp2[ di[h] ]++;
        }
        //PermutationShowVector(tmp2, tmp_length);
        retval = PermutationCalcT(di, genotype, T, n);
        if (retval != 0){
            printf("can not create T\n");
            return;
        }
        S = TableCalcScore(T);
        if (S >= Sobs){
            count++;
        }
    }

    printf("%lf\n", (double)count/repeat);

finalize:;
    /* mۂJ */
	free1Dim(genotype);
    free1Dim(type);
    free1Dim(observerOrder);
    free1Dim(omega);
    free1Dim(di);
    free1Dim(tmp2);
    freeInt2Dim(Tobs, ROW);
    freeInt2Dim(T, ROW);

#ifdef DBG
    //test
    printf("%d\n", getMallocCount());
#endif

	return;
}

/* 􌻕\쐬 */
int PermutationCalcT(int *d, int *genotype, int **result, int len)
{
    int h = 0;
    int i = 0;
    int j = 0;

    /* result0ŏ */
    for (i = 0; i < ROW; i++){
        for (j = 0; j < COLUMN; j++){
            result[i][j] = 0;
        }
    }

    /* 􌻕\쐬 */
    for (h = 0; h < len; h++){
        result[ d[h] ][ genotype[h] ]++;
    }

    return 0;
}

/* 􌻕\̃XRAvZ */
double PermutationCalcS(int **T)
{
    return TableCalcFst(T); 
}

/* ԂVbt */
int PermutationCalcOmega(int len, int* result)
{
    int *flag = NULL;
    int h = 0;
    int x = 0;
    int retval = 0;

    /* flag̃m */
    flag = (int*)malloc1Dim(sizeof(int), len);
    if (NULL == flag) {
        retval = 1;
        goto finalize;
    }

    /* ԂVbt */
    for (h = 0; h < len; h++){
        x = 1;
        do{
            //x = rand() % len;   /* 0len-1܂ł̗𔭐 */
            x = (int)(ran2(&idum) * len);
            result[h] = x;
        } while(flag[x] > 0);
        flag[x]++;              /* oOȂ0AoȂ1Ƃ */
    }

    /* I */
    retval = 0;

finalize:;
    /* mۂJ */
	free1Dim(flag);

    return retval;
}

/* divZ */
int PermutationCalcDi(int n, int a, int *omega, int *result)
{
    int h = 0;
    int i = 0;

    /* z0ŏ */
    for (i = 0; i< n; i++){
        result[i] = 0;
    }

    for (h = 0; h < a; h++){
        result[ omega[h] ]++;   /* 0a-1܂łcaseƂ */
    }

    return 0;
}

/* divZ multidimensional */
int PermutationCalcDi_multi(int *n, int *omega, int *result, int l, int len)
{
    int h = 0;
    int h2 = 0;
    int i = 0;
    int target = 0;

    /* z0ŏ */
    for (i = 0; i< len; i++){
        result[i] = 0;
    }

    for (h = 0; h < len; h++){
        target = omega[h];
        for (h2 = 0; h2 < l; h2++){
            if (target < n[h2]){
                result[h] = h2;
                h2 = l;
            }
            else{
                target -= n[h2];
            }
        }
    }

    return 0;
}

/* f[^\ */
void PermutationShowVector(int *data, int len)
{
    int h = 0;

    for (h = 0; h < len; h++){
        printf("%d\t", data[h]);
    }
    printf("\n");
}

int PermutationConditionedDi(int *genotype, int **T, int *result_type)
{
    int a1 = T[0][0], /* case */
        a2 = T[0][1],
        a = a1 + a2;
    int b1 = T[1][0], /* control */
        b2 = T[1][1],
        b = b1 + b2;
    int n1 = a1 + b1,
        n2 = a2 + b2,
        n = n1 + n2;

    int *count = NULL;
    int *tmp = NULL;
    int **num = NULL;
    int **shuffle = NULL;

    int h = 0;
    int i = 0;
    int j = 0;
    int tag = 0;
    int gen = 0;
    int retval = 0;

    /* tmp̃m */
    tmp = (int*)malloc1Dim(sizeof(int), VAL);
    if (NULL == tmp) {
        retval = 1;
        goto finalize;
    }
    tmp[0] = n1;
    tmp[1] = n2;
    /* count̃m */
    count = (int*)malloc1Dim(sizeof(int), VAL);
    if (NULL == tmp) {
        retval = 2;
        goto finalize;
    }
    /* num̃m */
    num = (int**)malloc1Dim(sizeof(int*), VAL);
    if (NULL == num) {
        retval = 3;
        goto finalize;
    }
    for (i = 0; i < VAL; i++){
        num[i] = (int*)malloc1Dim(sizeof(int), tmp[i]);
        if (NULL == num[i]) {
            retval = 4;
            goto finalize;
        }
    }
    /* shufflẽm */
    shuffle = (int**)malloc1Dim(sizeof(int*), VAL);
    if (NULL == shuffle) {
        retval = 5;
        goto finalize;
    }
    for (i = 0; i < VAL; i++){
        shuffle[i] = (int*)malloc1Dim(sizeof(int), tmp[i]);
        if (NULL == shuffle[i]) {
            retval = 6;
            goto finalize;
        }
    }

    for (h = 0; h < n; h++){
        gen = genotype[h];
        num[gen][ count[gen] ] = h;
        count[gen]++;
    }
    /* ̈`q^ɑΉł悤ɏIɂ͊g */

    /* ւ */
    for(gen = 0; gen < VAL; gen++){
        retval = PermutationCalcOmega(tmp[gen], shuffle[gen]);
    }

    /* ӓxɍ킹casecontrolU */
    for (gen = 0; gen < 2; gen++){
        for (h = 0; h < tmp[gen]; h++){
            tag = shuffle[gen][h];
            if (h < T[0][gen]){
                result_type[tag] = 0;
            }
            else{
                result_type[tag] = 1;
            }
        }
    }

    /* I */
    retval = 0;

finalize:;
    /* mۂJ */
	free1Dim(tmp);
	free1Dim(count);
    freeInt2Dim(num, VAL);
    freeInt2Dim(shuffle, VAL);

	return retval;
}

int PermutationCalcGenotype(char **sequence, int n, int **result) /* n : number of sequences */
{
    int sequenceLength = 0;
    int i = 0;
    int j = 0;

    sequenceLength = strlen(sequence[0]);

    for (j = 0; j < sequenceLength; j++){
        for (i = 0; i < n; i++){
            //if (strcmp(sequence[i][j], sequence[0][j])){
            if (sequence[i][j] == sequence[0][j]){
                //genotype[i] = 0;
                result[j][i] = 0;
            }
            else{
                //genotype[i] = 1;
                result[j][i] = 1;
            }
        }
        //result[j] = genotype;
    }

    return 0;
}

/* Permutations */
int PermutationExecute(int ** Tobs, double Sobs, long repeat)
{
    int a1 = 0,     /* genotype1, case */
        a2 = 0;     /* genotype2, case */
    int b1 = 0,     /* genotype1, control */
        b2 = 0;     /* gneotype2, control */
    int a = 0,      /* case ̍v */
        b = 0,      /* control̍v */
        n = 0;      /* case,control̍v */

    int *genotype = NULL;       /* `q^ */
    int *omega = NULL;
    int *di = NULL;
    int **T = NULL;
    double S = 0;

    int count = 0;              /* permutatioňʂϑlz */
    int h = 0;
    int retval = 0;
    long i = 0;
    int result = -1;

    a1 = Tobs[0][0];
    a2 = Tobs[0][1];
    b1 = Tobs[1][0];
    b2 = Tobs[1][1];
    a = a1 + a2;
    b = b1 + b2;
    n = a + b;

    /* genotypẽm */
    genotype = (int*)malloc1Dim(sizeof(int), n);
    if (NULL == genotype) { goto finalize; }
    /* T̃m */
    T = (int**)mallocInt2Dim(ROW, COLUMN);
    if (NULL == T) { goto finalize; }
    /* omegãm */
    omega = (int*)malloc1Dim(sizeof(int), n);
    if (NULL == omega) { goto finalize; }
    /* dĩm */
    di = (int*)malloc1Dim(sizeof(int), n);
    if (NULL == di) { goto finalize; }

    for (h = 0; h < n; h++){
        if ( (0 <= h) && (h < a1) ){
            genotype[h] = 1;
        }
        else if ( (a1 <= h) && (h < a) ){
            genotype[h] = 0;
        }
        else if ( (a <= h) && (h < a+b1) ){
            genotype[h] = 1;
        }
        else if ( (a+b1 <= h) && (h < n) ){
            genotype[h] = 0;
        }
    }

    /* permutation */
    for (i = 0; i < repeat; i++){
        retval = PermutationCalcOmega(n, omega);
        if (retval != 0){
            printf("can not create omega\n");
            return result;
        }
        retval = PermutationCalcDi(n, a, omega, di);
        if (retval != 0){
            printf("can not create di\n");
            return result;
        }
        retval = PermutationCalcT(di, genotype, T, n);
        if (retval != 0){
            printf("can not create T\n");
            return result;
        }
        S = TableCalcScore(T);
        if (S >= Sobs){
            count++;
        }
    }

    result = count;

finalize:;
    /* mۂJ */
	free1Dim(genotype);
    free1Dim(omega);
    free1Dim(di);
    freeInt2Dim(T, ROW);

	return result;
}
