#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "snp_Q.h"
#include "snp_Permutation.h"
#include "snp_Factorial.h"
#include "snp_G.h"
#include "snp_Config.h"
#include "snp_MemoryControl.h"


void GMain()
{
    char *caseSequence[CASE] = {"ATAATTTAC",
                                "ACGGCCGGT",
                                "GTAATTTAT"};
    char *controlSequence[CONTROL] = {"ATAATTTAT",
                                      "GTAATTTAC",
                                      "ATAATTTAT"};
    int a = CASE;       /* the number of cases */
    int b = CONTROL;    /* the number of controls */
    int n = a + b;      /* sample size */

    char **sequence = NULL;
    int *type = NULL;
    int *observedOrder = NULL;

    int h = 0;
    int i = 0;
    int retval = 0;
    int sequenceLength = 0;
    double Qsum = 0;
    double g = 0;

    sequenceLength = strlen(caseSequence[0]);

    /* sequencẽm */
    sequence = (char**)mallocChar2Dim(n, sequenceLength);
    if (NULL == sequence) { goto finalize; }
    /* typẽm */
    type = (int*)malloc1Dim(sizeof(int), n);
    if (NULL == type) { goto finalize; }
    /* observedOrder̃m */
    observedOrder = (int*)malloc1Dim(sizeof(int), n);
    if (NULL == observedOrder) { goto finalize; }

    /* loge[u쐬 */
    if (FactorialSetFactorial(n) != 0){
        goto finalize;
    }

    for (h = 0; h < n; h++){
        if ( (0 <= h) && (h < a) ){ /* case */
            strcpy(sequence[h], caseSequence[h]);
            type[h] = 1;
        }
        if ( (a <= h) && (h < n) ){ /* control */
            strcpy(sequence[h], controlSequence[h-a]);
            type[h] = 0;
        }
        observedOrder[h] = h;
    }

    Qsum = GCalcSumQ(sequence, type, 3, n);
    g = GCalcg(sequence, type, 3, n);
    printf("%.18lf\n", g);

finalize:;
    /* mۂJ */
    freeChar2Dim(sequence, n);
    free1Dim(type);
	free1Dim(observedOrder);
    /* loge[uNA */
    FactorialDeleteFactorial();

#ifdef DBG
    //test
    printf("%d\n", getMallocCount());
#endif

    return;
}

double GCalcg(char **sequence, int *di, double Sobs, int n)
{
    double result = 0;

    result = QCalcQvalue(sequence, di, Sobs, n) / GCalcSumQ(sequence, di, Sobs, n);

    return result;
}

double GCalcSumQ(char **sequence, int *di, double Sobs, int n)
{
    double result = 0.0;
    int i = 0;
    int c1 = 0;
    int retval = 0;
    int sequenceLength = 0;
    int *genotype = NULL;
    int **T = NULL;
    Table table;

    sequenceLength = strlen(sequence[0]);

    /* genotypẽm */
    genotype = (int*)malloc1Dim(sizeof(int), n);
    if (NULL == genotype) {
        retval = 1;
        goto finalize;
    }
    /* T̃m */
    T = (int**)mallocInt2Dim(ROW, COLUMN);
    if (NULL == T) {
        retval = 2;
        goto finalize;
    }

    for (c1 = 0; c1 < sequenceLength; c1++){
        /* genotype0ŏ */
        for (i = 0; i < n; i++){
            genotype[i] = 0;
        }
        for (i = 0; i < n; i++){
            if (sequence[i][c1] == sequence[0][c1]){
                genotype[i] = 0;
            }
            else{
                genotype[i] = 1;
            }
            retval = PermutationCalcT(di, genotype, T, n);

            /* TableNX̃NXIuWFNg쐬 */
            retval = TableMakeTableIntArray(&table, T);
            result += GGetNumberOfDiInHj(table, Sobs);

            /* \tablẽJ */
            TableFinalTable(&table);
        }
    }

finalize:;
    /* mۂJ */
    free1Dim(genotype);
    freeInt2Dim(T, ROW);
    /* \tablẽJ */
    TableFinalTable(&table);

    return result;
}


double GGetNumberOfDiInHj(Table table, double Sobs)
{
    double result = 0;
    int l = 0;
    int u = 0;
    int retval = 0;
    int **T = NULL;

    int i = 0;
    int a1 = 0;

    /* T̃m */
    T = (int**)mallocInt2Dim(ROW, COLUMN);
    if (NULL == T) {
        retval = 1;
        goto finalize;
    }

    l = TableCalcL(table);
    u = TableCalcU(table);

    for (a1 = l; a1 <= u; a1++){
        retval = TableNewTable(table, a1, T);
        if (FLAG_TRUE == TableInCj(Sobs, T, ROW, COLUMN)){
            result += TableCalcMu(T);
        }
    }

finalize:;
    /* mۂJ */
    freeInt2Dim(T, ROW);

    return result;
}

/* m@ŊmPvZ */
double GCalcP(Table table, double Sobs)
{
    double result = 0;
    double logF = 0;
    int l = 0;
    int u = 0;
    int retval = 0;
    int **T = NULL;

    int i = 0;
    int a1 = 0;



    /* T̃m */
    T = (int**)mallocInt2Dim(ROW, COLUMN);
    if (NULL == T) {
        retval = 1;
        goto finalize;
    }

    logF = FactorialGetLogCombination(table.horizontalSum[0] + table.horizontalSum[1], table.horizontalSum[0]);

    l = TableCalcL(table);
    u = TableCalcU(table);

    for (a1 = l; a1 <= u; a1++){
        retval = TableNewTable(table, a1, T);
        if (FLAG_TRUE == TableInCj(Sobs, T, ROW, COLUMN)){
            result += exp(TableCalcLogMu(T) - logF);
        }
    }

finalize:;
    /* mۂJ */
    freeInt2Dim(T, ROW);

    return result;
}

