package primitive;

import io.*;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;

public class Snp_DataReader {
	
	public static void main(String[] args) throws FileNotFoundException,IOException {
        String[] data1 = fileload.loadLine0(args[0]);
        char[][] nucleotides = new char[data1.length][];
        //String[] data2 = fileload.loadLine0(args[1]);
        for(int j=0;j<data1.length;j++){
        	SnpData data = DataReaderSetData(data1[j],2);
        	nucleotides[j] = data.SNPdata;
        	for(int h=0;h<nucleotides[j].length;h++){
        		System.out.print("\t");
        		System.out.print(nucleotides[j][h]);
        	}
        	System.out.println();
//        	System.out.println(data.rsNumber);
        }
    }
	
    public static SnpData DataReaderSetData(String dataString, int dataType){
    	try{
        	switch(dataType){
    		case 0: /*̓f[^Hapmap*/
    			return DataReaderSetHapmapData(dataString);
    		case 1: /*̓f[^HaplotypeData*/
    			return DataReaderSetHaplotypeData(dataString);
    		case 2: /*̓f[^PhasedHapMap*/
    			return DataReaderSetPhasingHapmapData(dataString);
    		default: 
    			break;
        	}
    	}catch(Exception e){
    		
    	}
		return new SnpData();
    }
    /*sϊ̂Ŋ֐allĂBȉ*/
    static SnpData DataReaderSetHapmapData(String dataString){
    	AwkLike a = new AwkLike(dataString);
    	int size = a.NF(); // number of haplotypes
    	SnpData result = new SnpData();
    	result.rsNumber  = a.doller(1);
    	result.SNPalleles= a.doller(2);
    	result.chrom     = a.doller(3);
    	result.pos = (new Long(a.doller(4))).longValue();
    	Vector v = new Vector();
    	for(int i=12;i<=size;i++){
    		v.add(a.doller(i));
    	}
    	int SNP_DATA_LEN = v.size()*2;
    	char[] SNPdata = new char[SNP_DATA_LEN];
    	for(int i=0;i<SNP_DATA_LEN;i++){
    		SNPdata[2*i] = ((String) v.elementAt(i)).charAt(0);
    		SNPdata[2*i+1] = ((String) v.elementAt(i)).charAt(1);
    	}
    	result.SNPdata = SNPdata;
    	return result;
    }

    static SnpData DataReaderSetHaplotypeData(String dataString){
    	AwkLike a = new AwkLike(dataString);
    	int size = a.NF(); // number of haplotypes
    	SnpData result = new SnpData();
    	result.rsNumber = a.doller(1);
    	result.SNPalleles= a.doller(6);
    	result.chrom     = a.doller(3);
    	result.pos = (new Long(a.doller(5))).longValue();
    	Vector v = new Vector();
    	for(int i=7;i<=size;i++){
    		v.add(a.doller(i));
    	}
    	int SNP_DATA_LEN = v.size();
    	char[] SNPdata = new char[SNP_DATA_LEN];
    	for(int i=0;i<SNP_DATA_LEN;i++){
    		SNPdata[i] = ((String) v.elementAt(i)).charAt(0);
    	}
    	result.SNPdata = SNPdata;
    	return result;
    }
    
    static SnpData DataReaderSetPhasingHapmapData(String dataString){
    	AwkLike a = new AwkLike(dataString);
    	int size = a.NF(); // number of haplotypes
    	SnpData result = new SnpData();
    	result.rsNumber = a.doller(1);
    	result.pos = (new Long(a.doller(2))).longValue();
    	Vector v = new Vector();
    	for(int i=3;i<=size;i++){
    		v.add(a.doller(i));
    	}
    	int SNP_DATA_LEN = v.size();
    	char[] SNPdata = new char[SNP_DATA_LEN];
    	for(int i=0;i<SNP_DATA_LEN;i++){
    		SNPdata[i] = ((String) v.elementAt(i)).charAt(0);
    	}
    	result.SNPdata = SNPdata;
    	return result;
    }

    public static SnpData[][] DataReaderMakeParallelData(SnpData[] snpTmpData1, SnpData[] snpTmpData2)
    {
    	//낦̂ԂB[0]case, [1]control
    	//java͔z̍ŏ0
//        int retval = 0;
        long index = 0;
        int caseIndex = 0;    // Javał͔z̈longgȂ̂intɕϊ
        int controlIndex = 0; // Aint͈̔͂傫B-
        long line1=snpTmpData1.length;
        long line2=snpTmpData2.length;

        /* f[^i[p\̂̃m */
        Vector snpData1 = new Vector();
        Vector snpData2 = new Vector();
        //z̑VectorgBƂŔzɕϊ
        
        try{
            while ( caseIndex < line1 || controlIndex < line2 ){
                /* f[^posrAӏ̈`qł邱ƂmF */
                if (snpTmpData1[caseIndex].pos == snpTmpData2[controlIndex].pos){
                    /* Q̃f[^SNPalleles̏Ԃ`FbN / javałł͂̋@\͏ȗ
                    retval = DataReaderCheckSNPalleles(&snpTmpData1[caseIndex], &snpTmpData2[controlIndex]);
                    */
                    if(0 == 0){
                        /* 񉻃f[^̍쐬 */
                        //memcpy(&snpTmpData1[caseIndex], &((*snpData1)[index]), sizeof(SnpData));
                        //memcpy(&snpTmpData2[controlIndex], &((*snpData2)[index]), sizeof(SnpData));
                    	snpData1.add(snpTmpData1[caseIndex]);
                        snpData2.add(snpTmpData2[controlIndex]);
                        index++;
                    }
                    /* snpTmpData1(case)̎̃f[^QƂ */
                    caseIndex++;
                    /* snpTmpData2̎̃f[^QƂ */
                    controlIndex++;
                }
                else if (snpTmpData1[caseIndex].pos < snpTmpData2[controlIndex].pos){
                    /* snpData1(case)̎̃f[^QƂ */
                    caseIndex++;
                }
                else if (snpTmpData1[caseIndex].pos > snpTmpData2[controlIndex].pos){
                    /* snpData2(control)̎̃f[^QƂ */
                    controlIndex++;
                }
            }       	
        }catch(java.lang.ArrayIndexOutOfBoundsException e){
//        	  System.out.println("exception");
        }
//        System.out.println("test3");
      

        SnpData[][] result = new SnpData[2][];
        int dataCount = snpData1.size();
        result[0] = new SnpData[dataCount];
        result[1] = new SnpData[dataCount];
        for(int j=0;j<dataCount;j++){
        	result[0][j]=(SnpData) snpData1.elementAt(j);
        	result[1][j]=(SnpData) snpData2.elementAt(j);
        }
        return result;
    }

    public static char maximumNuc(SnpData snpData){
    	char[] SNPdata = snpData.SNPdata;
    	int[] count = new int[5];
    	char[] nuc = {'N','T','C','A','G'};
    	for(int h=0;h<SNPdata.length;h++){
    		int tmp = 0;
    		// Jan21 2009
    		switch (SNPdata[h]){
    		    case 'u':tmp=1; break;
    		    case 'U':tmp=1; break;
    		    case 'T':tmp=1; break;
    		    case 't':tmp=1; break;
    		    case 'C':tmp=2; break;
    		    case 'c':tmp=2; break;
    		    case 'A':tmp=3; break;
    		    case 'a':tmp=3; break;
    		    case 'G':tmp=4; break;
    		    case 'g':tmp=4; break;
    		    default :
    		}
    		count[tmp]++;
    	}    	
    	int max=0;
    	int maxi=0;
    	for(int tmp=1;tmp<5;tmp++){
    		if(max<count[tmp]) {
    			max = count[tmp];
        		maxi = tmp;
    		}
    	}
    	return nuc[maxi];
    }
    
    public static int[] genotype(SnpData snpData, char reference){
    	char[] SNPdata = snpData.SNPdata;
    	int[] result = new int[SNPdata.length];
    	for(int h=0;h<SNPdata.length;h++){
    		if(SNPdata[h]==reference){
    			result[h]=0;
    		}else{
    			result[h]=1;
    		}
    	}
    	return result;
    }

    public static int[][] DataReaderMakeTable(SnpData snpData1, SnpData snpData2, int[] d)
    {
    	char reference = maximumNuc(snpData1);
    	int[] data1 = genotype(snpData1,reference);
    	int[] data2 = genotype(snpData2,reference);
    	int[] data = new int[data1.length+data2.length];
    	for(int h=0;h<data1.length;h++)	data[h]=data1[h];
    	for(int h=0;h<data2.length;h++)	data[h+data1.length]=data2[h];
    	int len = data.length;

    	int[][] T = new int[2][2];
		for(int h=0;h<len;h++){
			T[d[h]][data[h]]++;
		}
		/*
		 * T[0][0]control@&@genotype 1
		 * T[0][1]control@&@genotype 2
		 * T[1][0]case & genotype 1
		 * T[1][1]case & genotype 2
		 * XRAɂ͉eȂcasecontrolւĂ̂Œ
		 */
		return T;
    }
    
    public static int[] populationType(SnpData snpData1, SnpData snpData2){
    	// first population =0 second population =1Ƃ֐
    	// 𐔂̂ɕ֗
    	int len1 = snpData1.SNPdata.length;
    	int len2 = snpData2.SNPdata.length;
    	int[] data = new int[len1+len2];
    	for(int h=0;h<len1;h++)	data[h]=0;
    	for(int h=0;h<len2;h++)	data[h+len1]=1;
    	return data;
    }
    
    
    public static HaplotypeFrequency[] haplotypeFrequency(SnpData[][] snpData){
    	//rsԍĂ邱ƂOBmissing dataȂƉB
    	// popNumber͏Wc̐
    	int popNumber = snpData.length;
    	//WcƂsequence̔z̔zBhaplotypełcB
    	String[][] sequences = new String[popNumber][];
    	Vector haplotypeList = new Vector();
    	int maxHaplotypeNumber = 0;
    	for(int i=0;i<popNumber;i++){
    		sequences[i] = sequences(snpData[i]);
    		maxHaplotypeNumber+=sequences[i].length;
    	}
    	String[] allSNP = new String[maxHaplotypeNumber];
    	int tmp = 0;
    	for(int i=0;i<popNumber;i++){
    		for(int i2=0;i2<sequences[i].length;i2++){
    	    	allSNP[tmp] = sequences[i][i2];    			
    	    	tmp++;
    		}
    	}
    	for(int h=0;h<maxHaplotypeNumber;h++){
   			String haplotype = allSNP[h].toString();
   			//java當񂪎gBCȂchar[]
   			//haplotypehaplotypeListɓo^ς݂ǂׂ
   			int size = haplotypeList.size();
   			boolean flag = false;
    		for(int h2=0;h2<size;h2++){ // allSNPhaplotypeList𑍓Ŕr
    			if( haplotype.equals( ((HaplotypeFrequency) haplotypeList.elementAt(h2)).haplotype) ) {
    				((HaplotypeFrequency)haplotypeList.elementAt(h2)).count++;// haplotypeɑz񐔂JEg
    				flag=true;
    			}
    			// Cłequals()strcmp()Ȃǂőp
    		}
    		if(flag==false){
    			haplotypeList.add(new HaplotypeFrequency(haplotype) );
    		}
    	}
		int size = haplotypeList.size();
		HaplotypeFrequency[] result = new HaplotypeFrequency[size];
		for(int h2=0;h2<size;h2++){ 
			result[h2] =  (HaplotypeFrequency) haplotypeList.elementAt(h2);
		}
		return result;
    }

    public static String[] sequences(SnpData[] snpData1){
    	//rsԍĂ邱ƂOBmissing dataȂƉB
    	int m = snpData1.length;
    	int maxHaplotypeNumber = snpData1[0].SNPdata.length; // c
    	// 肤HaplotypeNumber̍ől
    	//char[][] allSNP = new char[maxHaplotypeNumber][m+1];  // C-like
    	StringBuffer[] allSNP = new StringBuffer[maxHaplotypeNumber];  // java
    	for(int h=0;h<maxHaplotypeNumber;h++){
    		allSNP[h]=new StringBuffer(); // 
    	}
    	// Si[iԂԂ邪A͂ōƂȗj
    	for(int j=0;j<m;j++){
        	//ži܂Ƃ܂jɒ
        	//allSNP[h]haplotype{,m
        	// C-like
        	//for(int h=0;h<len1;h++)	allSNP[h][j]=snpData1[j].SNPdata[h];
        	//java
        	for(int h=0;h<maxHaplotypeNumber;h++)	allSNP[h].append(snpData1[j].SNPdata[h]);
    	}

		String[] result = new String[maxHaplotypeNumber];
		for(int h=0;h<maxHaplotypeNumber;h++){ 
			result[h] =  allSNP[h].toString();
		}
		return result;
    }
    
    public static SnpData[] sequenceToSnpData(String[] sequences){  // DNAzf[^SnpData̔zɕϊ
    	int seqLen=sequences[0].length();
    	SnpData[] result = new SnpData[seqLen];
    	int size = sequences.length;
    	for(int j=0;j<seqLen;j++){ //cƉϊ
    		result[j]=new SnpData();
    		result[j].SNPdata = new char[size];
    		result[j].pos=j; // position
    		for(int h=0;h<size;h++){
    			result[j].SNPdata[h]=sequences[h].charAt(j);
    		}
    	}
    	return result;
    }

}
