/*
 * Decompiled with CFR 0.152.
 */
package probability;

import probability.Bunkai;
import probability.Factorial;

public class Keisan {
    public static double threshold = 6.635;
    public static int haba = 10;

    public static void main(String[] args) {
        int samplesize = 100;
        samplesize = 10;
        while (samplesize < 5000) {
            long time = System.currentTimeMillis();
            double[] h = new double[]{0.3333, 0.3333, 0.3334};
            double[] h2 = new double[h.length * 2];
            int i = 0;
            while (i < h.length) {
                double d = h[i];
                h2[i + h.length] = d;
                h2[i] = d;
                ++i;
            }
            int L = h2.length;
            Factorial f = new Factorial(samplesize * 2);
            int[] lower = new int[L];
            int[] upper = new int[L];
            int[] range = new int[L];
            int i2 = 0;
            while (i2 < L) {
                lower[i2] = Keisan.lowerLimit(samplesize, h2[i2], haba);
                upper[i2] = Keisan.upperLimit(samplesize, h2[i2], haba);
                range[i2] = upper[i2] - lower[i2] + 1;
                ++i2;
            }
            Bunkai b = new Bunkai(lower, upper, samplesize);
            double total = 0.0;
            int count = 0;
            do {
                int[][] X = new int[2][L];
                b.count();
                System.out.println(++count);
                int[] result = b.bunkai();
                int tmp1 = 0;
                int tmp2 = 0;
                int i3 = 0;
                while (i3 < result.length / 2) {
                    X[0][i3] = lower[i3] + result[i3];
                    X[1][i3] = lower[i3 + result.length / 2] + result[i3 + result.length / 2];
                    tmp1 += X[0][i3];
                    tmp2 += X[0][i3];
                    ++i3;
                }
                if (tmp1 != samplesize || tmp2 != samplesize) continue;
                total += Keisan.multinomialP(samplesize, X[0], h2, f) * Keisan.multinomialP(samplesize, X[1], h2, f);
            } while (!b.done());
            System.out.print(samplesize);
            System.out.print("\t");
            System.out.print(L);
            System.out.print("\t");
            System.out.print(total);
            System.out.print("\t");
            System.out.println((System.currentTimeMillis() - time) / 1000L);
            samplesize += 10;
        }
    }

    public static double multinomialP(int size, int[] X, double[] h, Factorial fact) {
        int L = X.length;
        if (Keisan.significant(size, X, h) == 0) {
            return 0.0;
        }
        double logResult = fact.logFactrial(size);
        int i = 0;
        while (i < L) {
            logResult -= fact.logFactrial(X[i]);
            logResult += Math.log(h[i]) * (double)X[i];
            ++i;
        }
        return Math.exp(logResult);
    }

    public static int upperLimit(int sampleSize, double frequency, int haba) {
        double x = Math.sqrt(threshold * (double)sampleSize * frequency);
        int n = (int)((double)sampleSize * frequency + x) + haba;
        if (n < sampleSize) {
            return n;
        }
        return sampleSize;
    }

    public static int lowerLimit(int sampleSize, double frequency, int haba) {
        double x = Math.sqrt(threshold * (double)sampleSize * frequency);
        int n = (int)((double)sampleSize * frequency - x) - haba;
        if (n >= 0) {
            return n;
        }
        return 0;
    }

    public static int significant(int sampleSize, int[] obs, double[] frequency) {
        int result = 0;
        int i = 0;
        while (i < obs.length) {
            if (Keisan.significant(sampleSize, obs[i], frequency[i]) == 1) {
                result = 1;
            }
            ++i;
        }
        return result;
    }

    public static int significant(int sampleSize, int obs, double frequency) {
        double exp = (double)sampleSize * frequency;
        double chi2 = ((double)obs - exp) * ((double)obs - exp) / exp;
        if (chi2 > threshold) {
            return 1;
        }
        return 0;
    }
}

