/*
 * Decompiled with CFR 0.152.
 */
package probability;

import java.io.FileNotFoundException;
import java.io.IOException;
import probability.HapMapLoad;

public class HapMapScore {
    public static void main(String[] args) throws FileNotFoundException, IOException {
        int number = args.length;
        boolean flag = true;
        if (number == 0) {
            flag = false;
        }
        HapMapLoad[] list = new HapMapLoad[number];
        int pop = 0;
        while (pop < number) {
            list[pop] = new HapMapLoad(args[pop]);
            ++pop;
        }
        while (flag) {
            double result = 0.0;
            String SNP = "";
            try {
                double[][] counts = new double[number][];
                int[] positions = new int[number];
                SNP = list[0].currentSNPnubmer();
                int max = 0;
                int pop2 = 0;
                while (pop2 < number) {
                    int work;
                    if (list[pop2].eof()) {
                        flag = false;
                    }
                    list[pop2].read();
                    positions[pop2] = work = list[pop2].currentPosition();
                    if (max < list[pop2].currentPosition()) {
                        max = list[pop2].currentPosition();
                    }
                    counts[pop2] = list[pop2].counts();
                    ++pop2;
                }
                result = HapMapScore.peasonScore(counts);
            }
            catch (NullPointerException e) {
                flag = false;
            }
            System.out.print(SNP);
            System.out.print("\t");
            System.out.print(result);
            System.out.println();
        }
    }

    public static double peasonScore(double[][] counts) {
        int number = counts.length;
        int sum = 0;
        int all = 0;
        double numerator = 0.0;
        int pop = 0;
        while (pop < number) {
            all = (int)((double)all + counts[pop][0]);
            sum = (int)((double)sum + counts[pop][1]);
            ++pop;
        }
        double allP = (double)all / (double)sum;
        int pop2 = 0;
        while (pop2 < number) {
            double tmp = counts[pop2][0] / counts[pop2][1] - allP;
            numerator += tmp * tmp * counts[pop2][1];
            ++pop2;
        }
        return numerator / allP / (1.0 - allP);
    }
}

