/*
 * Decompiled with CFR 0.152.
 */
package probability;

import probability.Bunkai;
import probability.ChiTest;
import probability.Factorial;
import probability.MultiNomial;

public class Alelle {
    public static double threshold = 6.635;
    public static int haba = 5;
    int[][] state;
    ChiTest chiTest;

    public static void main(String[] args) {
        int samplesize = new Integer(args[0]);
        samplesize = 0;
        while (samplesize <= 50) {
            double[] test;
            long time = System.currentTimeMillis();
            String[] haplotype = new String[]{"ATAATTTAC", "ACGGCCGGT", "GTAATTTAT", "ATAATTTAT", "GTAATTTAC"};
            Alelle A = new Alelle(haplotype, samplesize);
            double[] old = new double[]{0.55232887, 0.179332453, 0.167452385, 0.039600226, 0.061286064};
            double[] old2 = new double[]{0.5252, 0.1902, 0.1776, 0.042, 0.065};
            double[] old3 = new double[]{0.5252, 0.1902, 0.1776, 0.021, 0.021, 0.065};
            double[] h = test = new double[]{0.1, 0.1, 0.8};
            h = old2;
            int L = h.length;
            int[][] X = new int[2][L];
            Factorial f = new Factorial(samplesize * 2);
            int[] lower = new int[L];
            int[] upper = new int[L];
            int i = 0;
            while (i < L) {
                lower[i] = ChiTest.lowerLimit(samplesize, h[i], haba);
                upper[i] = ChiTest.upperLimit(samplesize, h[i], haba);
                ++i;
            }
            double total = 0.0;
            Bunkai a = new Bunkai(lower, upper, samplesize);
            while (!a.done()) {
                Bunkai b = new Bunkai(lower, upper, samplesize);
                while (!b.done()) {
                    int[][] data = new int[][]{a.bunkai(), b.bunkai()};
                    X[0] = data[0];
                    X[1] = data[1];
                    if (ChiTest.significant2(samplesize, X, h) == 0) {
                        total += MultiNomial.multinomialP2(samplesize, X, h, f);
                    }
                    b.count();
                }
                a.count();
            }
            System.out.print(samplesize);
            System.out.print("\t");
            System.out.print(1.0 - total);
            System.out.print("\t");
            System.out.println((System.currentTimeMillis() - time) / 1000L);
            samplesize += 10;
        }
    }

    public Alelle(String[] haplotype, int samplesize) {
        this.chiTest = new ChiTest(samplesize);
        String nucleotide2 = "ATGC";
        this.state = new int[haplotype.length][haplotype[0].length()];
        int i = 0;
        while (i < haplotype[0].length()) {
            int k;
            int[] count = new int[nucleotide2.length()];
            int j = 0;
            while (j < haplotype.length) {
                char c = haplotype[j].charAt(i);
                k = 0;
                while (k < nucleotide2.length()) {
                    char d = nucleotide2.charAt(k);
                    if (c == d) {
                        int n = k;
                        count[n] = count[n] + 1;
                    }
                    ++k;
                }
                ++j;
            }
            int max = 0;
            int maxk = 0;
            k = 0;
            while (k < count.length) {
                if (max < count[k]) {
                    max = count[k];
                    maxk = k;
                }
                ++k;
            }
            char major = nucleotide2.charAt(maxk);
            int j2 = 0;
            while (j2 < haplotype.length) {
                char c = haplotype[j2].charAt(i);
                this.state[j2][i] = c == major ? 1 : 0;
                ++j2;
            }
            ++i;
        }
    }

    public void show() {
        int i = 0;
        while (i < this.state.length) {
            int j = 0;
            while (j < this.state[i].length) {
                System.out.print(this.state[i][j]);
                ++j;
            }
            System.out.println();
            ++i;
        }
    }
}

